/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.embedded;

import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.jetty.embedded.HelloHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.spdy.server.NPNServerConnectionFactory;
import org.eclipse.jetty.spdy.server.SPDYServerConnectionFactory;
import org.eclipse.jetty.spdy.server.http.HTTPSPDYServerConnectionFactory;
import org.eclipse.jetty.spdy.server.http.PushStrategy;
import org.eclipse.jetty.spdy.server.http.ReferrerPushStrategy;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SpdyConnector {
    public static void main(String[] args) throws Exception {
        String jettyHomeBuild = "../../jetty-distribution/target/distribution";
        String homePath = System.getProperty("jetty.home", jettyHomeBuild);
        File homeDir = new File(homePath);
        if (!homeDir.exists()) {
            throw new FileNotFoundException(homeDir.getAbsolutePath());
        }
        String jetty_home = homeDir.getAbsolutePath();
        System.setProperty("jetty.home", jetty_home);
        Server server = new Server();
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setSecureScheme("https");
        http_config.setSecurePort(8443);
        ServerConnector http = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(http_config)});
        http.setPort(8080);
        server.addConnector((Connector)http);
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(jetty_home + "/etc/keystore");
        sslContextFactory.setKeyStorePassword("OBF:1vny1zlo1x8e1vnw1vn61x8g1zlu1vn4");
        sslContextFactory.setKeyManagerPassword("OBF:1u2u1wml1z7s1z7a1wnl1u2g");
        HttpConfiguration https_config = new HttpConfiguration(http_config);
        https_config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        HTTPSPDYServerConnectionFactory spdy2 = new HTTPSPDYServerConnectionFactory(2, https_config);
        HTTPSPDYServerConnectionFactory spdy3 = new HTTPSPDYServerConnectionFactory(3, https_config, (PushStrategy)new ReferrerPushStrategy());
        SPDYServerConnectionFactory.checkProtocolNegotiationAvailable();
        NPNServerConnectionFactory npn = new NPNServerConnectionFactory(new String[]{spdy3.getProtocol(), spdy2.getProtocol(), http.getDefaultProtocol()});
        npn.setDefaultProtocol(http.getDefaultProtocol());
        SslConnectionFactory ssl = new SslConnectionFactory(sslContextFactory, npn.getProtocol());
        ServerConnector spdyConnector = new ServerConnector(server, new ConnectionFactory[]{ssl, npn, spdy3, spdy2, new HttpConnectionFactory(https_config)});
        spdyConnector.setPort(8443);
        server.addConnector((Connector)spdyConnector);
        server.setHandler((Handler)new HelloHandler());
        server.start();
        server.join();
    }
}

