/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.WrongMethodTypeException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public interface MethodHolder {
    public static final String METHOD_HOLDER_BINDING_PROPERTY = "jetty.websocket.methodholder.binding";
    public static final boolean IS_BINDING = System.getProperty("jetty.websocket.methodholder.binding") == null || Boolean.getBoolean("jetty.websocket.methodholder.binding");

    public static MethodHolder from(MethodHandle methodHandle) {
        return MethodHolder.from(methodHandle, IS_BINDING);
    }

    public static MethodHolder from(MethodHandle methodHandle, boolean binding) {
        if (methodHandle == null) {
            return null;
        }
        return binding ? new Binding(methodHandle) : new NonBinding(methodHandle);
    }

    public Object invoke(Object ... var1) throws Throwable;

    default public MethodHolder bindTo(Object arg) {
        throw new UnsupportedOperationException();
    }

    default public MethodHolder bindTo(Object arg, int idx) {
        throw new UnsupportedOperationException();
    }

    default public Class<?> parameterType(int idx) {
        throw new UnsupportedOperationException();
    }

    default public Class<?> returnType() {
        throw new UnsupportedOperationException();
    }

    public static Object doInvoke(MethodHandle methodHandle, Object ... args) throws Throwable {
        switch (args.length) {
            case 0: {
                return methodHandle.invoke();
            }
            case 1: {
                return methodHandle.invoke(args[0]);
            }
            case 2: {
                return methodHandle.invoke(args[0], args[1]);
            }
            case 3: {
                return methodHandle.invoke(args[0], args[1], args[2]);
            }
            case 4: {
                return methodHandle.invoke(args[0], args[1], args[2], args[3]);
            }
            case 5: {
                return methodHandle.invoke(args[0], args[1], args[2], args[3], args[4]);
            }
            case 6: {
                return methodHandle.invoke(args[0], args[1], args[2], args[3], args[4], args[5]);
            }
            case 7: {
                return methodHandle.invoke(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }
            case 8: {
                return methodHandle.invoke(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]);
            }
            case 9: {
                return methodHandle.invoke(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8]);
            }
        }
        return methodHandle.invokeWithArguments(args);
    }

    public static class Binding
    implements MethodHolder {
        public MethodHandle _methodHandle;

        private Binding(MethodHandle methodHandle) {
            this._methodHandle = methodHandle;
        }

        @Override
        public Object invoke(Object ... args) throws Throwable {
            return MethodHolder.doInvoke(this._methodHandle, args);
        }

        @Override
        public Binding bindTo(Object arg) {
            this._methodHandle = this._methodHandle.bindTo(arg);
            return this;
        }

        @Override
        public MethodHolder bindTo(Object arg, int idx) {
            this._methodHandle = MethodHandles.insertArguments(this._methodHandle, idx, arg);
            return this;
        }

        @Override
        public Class<?> parameterType(int idx) {
            return this._methodHandle.type().parameterType(idx);
        }

        @Override
        public Class<?> returnType() {
            return this._methodHandle.type().returnType();
        }
    }

    public static class NonBinding
    implements MethodHolder {
        private final MethodHandle _methodHandle;
        private final Object[] _parameters;
        private final List<Integer> _unboundParamIndexes = new ArrayList<Integer>();

        private NonBinding(MethodHandle methodHandle) {
            this._methodHandle = Objects.requireNonNull(methodHandle);
            int numParams = methodHandle.type().parameterCount();
            this._parameters = new Object[numParams];
            for (int i = 0; i < numParams; ++i) {
                this._unboundParamIndexes.add(i);
            }
        }

        @Override
        public Object invoke(Object ... args) throws Throwable {
            try {
                this.insertArguments(args);
                Object object = MethodHolder.doInvoke(this._methodHandle, this._parameters);
                return object;
            }
            finally {
                this.clearArguments();
            }
        }

        @Override
        public MethodHolder bindTo(Object arg, int idx) {
            this._parameters[this._unboundParamIndexes.get((int)idx).intValue()] = arg;
            this._unboundParamIndexes.remove(idx);
            return this;
        }

        @Override
        public MethodHolder bindTo(Object arg) {
            return this.bindTo(arg, 0);
        }

        private void insertArguments(Object ... args) {
            if (this._unboundParamIndexes.size() != args.length) {
                throw new WrongMethodTypeException(String.format("Expected %s params but had %s", this._unboundParamIndexes.size(), args.length));
            }
            int argsIndex = 0;
            for (int index : this._unboundParamIndexes) {
                this._parameters[index] = args[argsIndex++];
            }
        }

        private void clearArguments() {
            for (int i : this._unboundParamIndexes) {
                this._parameters[i] = null;
            }
        }

        @Override
        public Class<?> parameterType(int idx) {
            return this._methodHandle.type().parameterType(this._unboundParamIndexes.get(idx));
        }

        @Override
        public Class<?> returnType() {
            return this._methodHandle.type().returnType();
        }
    }
}

