/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.QuotedCSV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotedQualityCSV
extends QuotedCSV
implements Iterable<String> {
    private static final Logger LOG = LoggerFactory.getLogger(QuotedQualityCSV.class);
    public static ToIntFunction<String> MOST_SPECIFIC_MIME_ORDERING = s -> {
        if ("*/*".equals(s)) {
            return 0;
        }
        if (s.endsWith("/*")) {
            return 1;
        }
        if (s.indexOf(59) < 0) {
            return 2;
        }
        return 3;
    };
    private final List<QualityValue> _qualities = new ArrayList<QualityValue>();
    private QualityValue _lastQuality;
    private boolean _sorted = false;
    private final ToIntFunction<String> _secondaryOrdering;

    public QuotedQualityCSV() {
        this((ToIntFunction<String>)null);
    }

    public QuotedQualityCSV(String[] preferredOrder) {
        this((String s) -> {
            for (int i = 0; i < preferredOrder.length; ++i) {
                if (!preferredOrder[i].equals(s)) continue;
                return preferredOrder.length - i;
            }
            if ("*".equals(s)) {
                return preferredOrder.length;
            }
            return 0;
        });
    }

    public QuotedQualityCSV(List<String> preferredOrder) {
        this((String s) -> {
            for (int i = 0; i < preferredOrder.size(); ++i) {
                if (!((String)preferredOrder.get(i)).equals(s)) continue;
                return preferredOrder.size() - i;
            }
            if ("*".equals(s)) {
                return preferredOrder.size();
            }
            return 0;
        });
    }

    public QuotedQualityCSV(ToIntFunction<String> secondaryOrdering) {
        super(new String[0]);
        this._secondaryOrdering = secondaryOrdering == null ? s -> 0 : secondaryOrdering;
    }

    @Override
    protected void parsedValueAndParams(StringBuilder buffer) {
        super.parsedValueAndParams(buffer);
        this._lastQuality = new QualityValue(buffer.toString(), this._lastQuality._quality, this._lastQuality._index);
        this._qualities.set(this._lastQuality._index, this._lastQuality);
    }

    @Override
    protected void parsedValue(StringBuilder buffer) {
        super.parsedValue(buffer);
        this._sorted = false;
        this._lastQuality = new QualityValue(buffer.toString(), 1.0, this._qualities.size());
        this._qualities.add(this._lastQuality);
    }

    @Override
    protected void parsedParam(StringBuilder buffer, int valueLength, int paramName, int paramValue) {
        this._sorted = false;
        if (paramName < 0) {
            if (buffer.charAt(buffer.length() - 1) == ';') {
                buffer.setLength(buffer.length() - 1);
            }
        } else if (paramValue >= 0 && buffer.charAt(paramName) == 'q' && paramValue > paramName && buffer.length() >= paramName && buffer.charAt(paramName + 1) == '=') {
            double q;
            try {
                q = this._keepQuotes && buffer.charAt(paramValue) == '\"' ? Double.valueOf(buffer.substring(paramValue + 1, buffer.length() - 1)) : Double.valueOf(buffer.substring(paramValue));
            }
            catch (Exception e) {
                LOG.trace("IGNORED", e);
                q = 0.0;
            }
            buffer.setLength(Math.max(0, paramName - 1));
            if (q != 1.0) {
                this._lastQuality = new QualityValue(buffer.toString(), q, this._lastQuality._index);
                this._qualities.set(this._lastQuality._index, this._lastQuality);
            }
        }
    }

    @Override
    public List<String> getValues() {
        if (!this._sorted) {
            this.sort();
        }
        return this._values;
    }

    @Override
    public Iterator<String> iterator() {
        if (!this._sorted) {
            this.sort();
        }
        return this._values.iterator();
    }

    protected void sort() {
        this._values.clear();
        this._qualities.stream().filter(qv -> qv._quality != 0.0).sorted().map(QualityValue::getValue).collect(Collectors.toCollection(() -> this._values));
        this._sorted = true;
    }

    public List<QualityValue> getQualityValues() {
        return this._qualities.stream().sorted().toList();
    }

    public class QualityValue
    implements Comparable<QualityValue> {
        private final String _value;
        private final double _quality;
        private final int _index;

        private QualityValue(String value, double quality, int index) {
            this._value = value;
            this._quality = quality;
            this._index = index;
        }

        public String getValue() {
            return this._value;
        }

        public double getWeight() {
            return this._quality;
        }

        public boolean isAcceptable() {
            return this.getWeight() > 0.0;
        }

        public int hashCode() {
            return Objects.hash(this._quality, this._value, this._index);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof QualityValue)) {
                return false;
            }
            QualityValue that = (QualityValue)obj;
            return this._quality == that._quality && Objects.equals(this._value, that._value) && this._index == that._index;
        }

        @Override
        public int compareTo(QualityValue o) {
            int compare = Double.compare(o._quality, this._quality);
            if (compare == 0 && (compare = Integer.compare(QuotedQualityCSV.this._secondaryOrdering.applyAsInt(o._value), QuotedQualityCSV.this._secondaryOrdering.applyAsInt(this._value))) == 0) {
                compare = -Integer.compare(o._index, this._index);
            }
            return compare;
        }

        public String toString() {
            return String.format("%s@%x[%s,q=%.3f,i=%d]", this.getClass().getSimpleName(), this.hashCode(), this.getValue(), this.getWeight(), this._index);
        }
    }
}

