/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.runner;

import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.jetty.ee9.annotations.AnnotationConfiguration;
import org.eclipse.jetty.ee9.nested.ServletConstraint;
import org.eclipse.jetty.ee9.nested.SessionHandler;
import org.eclipse.jetty.ee9.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.ee9.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.ee9.security.ConstraintMapping;
import org.eclipse.jetty.ee9.security.ConstraintSecurityHandler;
import org.eclipse.jetty.ee9.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.ee9.servlet.ServletContextHandler;
import org.eclipse.jetty.ee9.webapp.FragmentConfiguration;
import org.eclipse.jetty.ee9.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.ee9.webapp.JspConfiguration;
import org.eclipse.jetty.ee9.webapp.MetaInfConfiguration;
import org.eclipse.jetty.ee9.webapp.WebAppConfiguration;
import org.eclipse.jetty.ee9.webapp.WebAppContext;
import org.eclipse.jetty.ee9.webapp.WebInfConfiguration;
import org.eclipse.jetty.ee9.webapp.WebXmlConfiguration;
import org.eclipse.jetty.io.ConnectionStatistics;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.ShutdownMonitor;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.RolloverFileOutputStream;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class Runner {
    private static final Logger LOG = LoggerFactory.getLogger(Runner.class);
    public static final String[] PLUS_CONFIGURATION_CLASSES = new String[]{WebInfConfiguration.class.getCanonicalName(), WebXmlConfiguration.class.getCanonicalName(), MetaInfConfiguration.class.getCanonicalName(), FragmentConfiguration.class.getCanonicalName(), EnvConfiguration.class.getCanonicalName(), PlusConfiguration.class.getCanonicalName(), AnnotationConfiguration.class.getCanonicalName(), JettyWebXmlConfiguration.class.getCanonicalName(), WebAppConfiguration.class.getCanonicalName(), JspConfiguration.class.getCanonicalName()};
    public static final String CONTAINER_INCLUDE_JAR_PATTERN = ".*/jetty-runner-[^/]*\\.jar$";
    public static final String DEFAULT_CONTEXT_PATH = "/";
    public static final int DEFAULT_PORT = 8080;
    protected Server _server;
    protected URLClassLoader _classLoader;
    protected Classpath _classpath = new Classpath();
    protected ContextHandlerCollection _contexts;
    protected String _logFile;
    protected ArrayList<String> _configFiles;
    protected boolean _enableStats = false;
    protected String _statsPropFile;
    protected String _serverUriFile;

    public void usage(String error) {
        if (error != null) {
            System.err.println("ERROR: " + error);
        }
        System.err.println("Usage: java [-Djetty.home=dir] -jar jetty-runner.jar [--help|--version] [ server opts] [[ context opts] context ...] ");
        System.err.println("Server opts:");
        System.err.println(" --version                           - display version and exit");
        System.err.println(" --log file                          - request log filename (with optional 'yyyy_mm_dd' wildcard");
        System.err.println(" --out file                          - info/warn/debug log filename (with optional 'yyyy_mm_dd' wildcard");
        System.err.println(" --host name|ip                      - interface to listen on (default is all interfaces)");
        System.err.println(" --port n                            - port to listen on (default 8080)");
        System.err.println(" --server-uri-file path              - file to write a single line with server base URI");
        System.err.println(" --stop-port n                       - port to listen for stop command (or -DSTOP.PORT=n)");
        System.err.println(" --stop-key n                        - security string for stop command (required if --stop-port is present) (or -DSTOP.KEY=n)");
        System.err.println(" [--jar file]*n                      - each tuple specifies an extra jar to be added to the classloader");
        System.err.println(" [--lib dir]*n                       - each tuple specifies an extra directory of jars to be added to the classloader");
        System.err.println(" [--classes dir]*n                   - each tuple specifies an extra directory of classes to be added to the classloader");
        System.err.println(" --stats [unsecure|realm.properties] - enable stats gathering servlet context");
        System.err.println(" [--config file]*n                   - each tuple specifies the name of a jetty xml config file to apply (in the order defined)");
        System.err.println("Context opts:");
        System.err.println(" [[--path /path] context]*n          - WAR file, web app dir or context xml file, optionally with a context path");
        System.exit(1);
    }

    public void version() {
        System.err.println("org.eclipse.jetty.runner.Runner: " + Server.getVersion());
        System.exit(1);
    }

    public void configure(String[] args) throws Exception {
        try (ResourceFactory.Closeable resourceFactory = ResourceFactory.closeable();){
            for (int i = 0; i < args.length; ++i) {
                if ("--lib".equals(args[i])) {
                    Resource lib;
                    if (!(lib = resourceFactory.newResource(args[++i])).exists() || !lib.isDirectory()) {
                        this.usage("No such lib directory " + String.valueOf(lib));
                    }
                    this._classpath.addJars(lib);
                    continue;
                }
                if ("--jar".equals(args[i])) {
                    Resource jar;
                    if (!(jar = resourceFactory.newResource(args[++i])).exists() || jar.isDirectory()) {
                        this.usage("No such jar " + String.valueOf(jar));
                    }
                    this._classpath.addPath(jar);
                    continue;
                }
                if ("--classes".equals(args[i])) {
                    Resource classes;
                    if (!(classes = resourceFactory.newResource(args[++i])).exists() || !classes.isDirectory()) {
                        this.usage("No such classes directory " + String.valueOf(classes));
                    }
                    this._classpath.addPath(classes);
                    continue;
                }
                if (!args[i].startsWith("--")) continue;
                ++i;
            }
        }
        this.initClassLoader();
        LOG.info("Runner");
        LOG.debug("Runner classpath {}", (Object)this._classpath);
        Object contextPath = DEFAULT_CONTEXT_PATH;
        boolean contextPathSet = false;
        int port = 8080;
        String host = null;
        int stopPort = Integer.getInteger("STOP.PORT", 0);
        Object stopKey = System.getProperty("STOP.KEY", null);
        boolean runnerServerInitialized = false;
        block41: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "--port": {
                    port = Integer.parseInt(args[++i]);
                    continue block41;
                }
                case "--host": {
                    host = args[++i];
                    continue block41;
                }
                case "--stop-port": {
                    stopPort = Integer.parseInt(args[++i]);
                    continue block41;
                }
                case "--stop-key": {
                    stopKey = args[++i];
                    continue block41;
                }
                case "--log": {
                    this._logFile = args[++i];
                    continue block41;
                }
                case "--out": {
                    String outFile = args[++i];
                    PrintStream out = new PrintStream(new RolloverFileOutputStream(outFile, true, -1));
                    LOG.info("Redirecting stderr/stdout to {}", (Object)outFile);
                    System.setErr(out);
                    System.setOut(out);
                    continue block41;
                }
                case "--path": {
                    contextPath = args[++i];
                    contextPathSet = true;
                    continue block41;
                }
                case "--config": {
                    if (this._configFiles == null) {
                        this._configFiles = new ArrayList();
                    }
                    this._configFiles.add(args[++i]);
                    continue block41;
                }
                case "--lib": {
                    ++i;
                    continue block41;
                }
                case "--jar": {
                    ++i;
                    continue block41;
                }
                case "--classes": {
                    ++i;
                    continue block41;
                }
                case "--stats": {
                    this._enableStats = true;
                    this._statsPropFile = args[++i];
                    this._statsPropFile = "unsecure".equalsIgnoreCase(this._statsPropFile) ? null : this._statsPropFile;
                    continue block41;
                }
                case "--server-uri-file": {
                    this._serverUriFile = args[++i];
                    continue block41;
                }
                default: {
                    Resource ctx;
                    if (args[i].startsWith("-D")) {
                        String[] sysProps = args[i].substring(2).split("=", 2);
                        if ("STOP.KEY".equals(sysProps[0])) {
                            stopKey = sysProps[1];
                            continue block41;
                        }
                        if ("STOP.PORT".equals(sysProps[0])) {
                            stopPort = Integer.parseInt((String)sysProps[1]);
                            continue block41;
                        }
                    }
                    if (!runnerServerInitialized) {
                        Connector[] connectors;
                        Handler.Sequence handlers;
                        if (this._server == null) {
                            this._server = new Server();
                        }
                        if (this._configFiles != null) {
                            for (String cfg : this._configFiles) {
                                Resource resource = ResourceFactory.of(this._server).newResource(cfg);
                                XmlConfiguration xmlConfiguration = new XmlConfiguration(resource);
                                xmlConfiguration.configure(this._server);
                            }
                        }
                        if ((handlers = this._server.getDescendant(Handler.Sequence.class)) == null) {
                            handlers = new Handler.Sequence(new Handler[0]);
                            this._server.setHandler(handlers);
                        }
                        this._contexts = handlers.getDescendant(ContextHandlerCollection.class);
                        if (this._contexts == null) {
                            this._contexts = new ContextHandlerCollection(new ContextHandler[0]);
                            this.prependHandler(this._contexts, handlers);
                        }
                        if (this._enableStats && handlers.getDescendant(StatisticsHandler.class) == null) {
                            StatisticsHandler statsHandler = new StatisticsHandler();
                            Handler oldHandler = this._server.getHandler();
                            statsHandler.setHandler(oldHandler);
                            this._server.setHandler(statsHandler);
                            ServletContextHandler statsContext = new ServletContextHandler(this._contexts, "/stats");
                            statsContext.setSessionHandler(new SessionHandler());
                            if (this._statsPropFile != null) {
                                ResourceFactory resourceFactory = ResourceFactory.of(statsContext);
                                Resource statsResource = resourceFactory.newResource(this._statsPropFile);
                                HashLoginService loginService = new HashLoginService("StatsRealm", statsResource);
                                ServletConstraint constraint = new ServletConstraint();
                                constraint.setName("Admin Only");
                                constraint.setRoles(new String[]{"admin"});
                                constraint.setAuthenticate(true);
                                ConstraintMapping cm = new ConstraintMapping();
                                cm.setConstraint(constraint);
                                cm.setPathSpec("/*");
                                ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
                                securityHandler.setLoginService(loginService);
                                securityHandler.setConstraintMappings(Collections.singletonList(cm));
                                securityHandler.setAuthenticator(new BasicAuthenticator());
                                statsContext.setSecurityHandler(securityHandler);
                            }
                        }
                        if (handlers.getDescendant(DefaultHandler.class) == null) {
                            handlers.addHandler(new DefaultHandler());
                        }
                        if ((connectors = this._server.getConnectors()) == null || connectors.length == 0) {
                            Connector[] connector = new ServerConnector(this._server);
                            connector.setPort(port);
                            if (host != null) {
                                connector.setHost(host);
                            }
                            this._server.addConnector((Connector)connector);
                            if (this._enableStats) {
                                connector.addBean(new ConnectionStatistics());
                            }
                        } else if (this._enableStats) {
                            for (Connector connector : connectors) {
                                ((AbstractConnector)connector).addBean(new ConnectionStatistics());
                            }
                        }
                        runnerServerInitialized = true;
                    }
                    if (!(ctx = ResourceFactory.of(this._server).newResource(args[i])).exists()) {
                        this.usage("Context '" + String.valueOf(ctx) + "' does not exist");
                    }
                    if (contextPathSet && !((String)contextPath).startsWith(DEFAULT_CONTEXT_PATH)) {
                        contextPath = DEFAULT_CONTEXT_PATH + (String)contextPath;
                    }
                    if (!ctx.isDirectory() && ctx.toString().toLowerCase(Locale.ENGLISH).endsWith(".xml")) {
                        WebAppContext wac;
                        XmlConfiguration xmlConfiguration = new XmlConfiguration(ctx);
                        xmlConfiguration.getIdMap().put("Server", this._server);
                        org.eclipse.jetty.ee9.nested.ContextHandler handler = (org.eclipse.jetty.ee9.nested.ContextHandler)xmlConfiguration.configure();
                        if (contextPathSet) {
                            handler.setContextPath((String)contextPath);
                        }
                        this._contexts.addHandler(handler);
                        Object containerIncludeJarPattern = (String)handler.getAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern");
                        if (containerIncludeJarPattern == null) {
                            containerIncludeJarPattern = CONTAINER_INCLUDE_JAR_PATTERN;
                        } else if (!((String)containerIncludeJarPattern).contains(CONTAINER_INCLUDE_JAR_PATTERN)) {
                            containerIncludeJarPattern = (String)containerIncludeJarPattern + (StringUtil.isBlank((String)containerIncludeJarPattern) ? "" : "|") + CONTAINER_INCLUDE_JAR_PATTERN;
                        }
                        handler.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", containerIncludeJarPattern);
                        if (handler instanceof WebAppContext && ((wac = (WebAppContext)handler).getConfigurationClasses() == null || wac.getConfigurationClasses().length == 0)) {
                            wac.setConfigurationClasses(PLUS_CONFIGURATION_CLASSES);
                        }
                    } else {
                        WebAppContext webapp = new WebAppContext((Handler.Container)this._contexts, ctx.toString(), (String)contextPath);
                        webapp.setConfigurationClasses(PLUS_CONFIGURATION_CLASSES);
                        webapp.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", CONTAINER_INCLUDE_JAR_PATTERN);
                    }
                    contextPathSet = false;
                    contextPath = DEFAULT_CONTEXT_PATH;
                }
            }
        }
        if (this._server == null) {
            this.usage("No Contexts defined");
        }
        this._server.setStopAtShutdown(true);
        switch ((stopPort > 0 ? 1 : 0) + (stopKey != null ? 2 : 0)) {
            case 1: {
                this.usage("Must specify --stop-key when --stop-port is specified");
                break;
            }
            case 2: {
                this.usage("Must specify --stop-port when --stop-key is specified");
                break;
            }
            case 3: {
                ShutdownMonitor monitor = ShutdownMonitor.getInstance();
                monitor.setPort(stopPort);
                monitor.setKey((String)stopKey);
                monitor.setExitVm(true);
                break;
            }
        }
        if (this._logFile != null) {
            CustomRequestLog requestLog = new CustomRequestLog(this._logFile);
            this._server.setRequestLog(requestLog);
        }
    }

    protected void prependHandler(Handler handler, Handler.Sequence handlers) {
        if (handler == null || handlers == null) {
            return;
        }
        List<Handler> existing = handlers.getHandlers();
        ArrayList<Handler> children = new ArrayList<Handler>(existing.size() + 1);
        children.add(handler);
        children.addAll(existing);
        handlers.setHandlers(children);
    }

    public void run() throws Exception {
        this._server.start();
        if (this._serverUriFile != null) {
            Path fileWithPort = Paths.get(this._serverUriFile, new String[0]);
            Files.deleteIfExists(fileWithPort);
            String serverUri = this._server.getURI().toString();
            Files.writeString(fileWithPort, (CharSequence)serverUri, new OpenOption[0]);
        }
        this._server.join();
    }

    private URL toURL(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void initClassLoader() {
        URL[] paths = (URL[])Arrays.stream(this._classpath.asArray()).map(this::toURL).toArray(URL[]::new);
        if (this._classLoader == null && paths.length > 0) {
            ClassLoader context = Thread.currentThread().getContextClassLoader();
            this._classLoader = context == null ? new URLClassLoader(paths) : new URLClassLoader(paths, context);
            Thread.currentThread().setContextClassLoader(this._classLoader);
        }
    }

    public static void main(String[] args) {
        System.err.println("WARNING: jetty-runner is deprecated.");
        System.err.println("         See Jetty Documentation for startup options");
        System.err.println("         https://jetty.org/docs/");
        Runner runner = new Runner();
        try {
            if (args.length > 0 && args[0].equalsIgnoreCase("--help")) {
                runner.usage(null);
            } else if (args.length > 0 && args[0].equalsIgnoreCase("--version")) {
                runner.version();
            } else {
                runner.configure(args);
                runner.run();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            runner.usage(null);
        }
    }

    public class Classpath {
        private List<URI> _classpath = new ArrayList<URI>();

        public void addJars(Resource lib) throws IOException {
            if (lib == null || !lib.exists()) {
                throw new IllegalStateException("No such lib: " + String.valueOf(lib));
            }
            for (Resource item : lib.list()) {
                if (item.isDirectory()) {
                    this.addJars(item);
                    continue;
                }
                if (!FileID.isLibArchive(item.getFileName())) continue;
                this._classpath.add(item.getURI());
            }
        }

        public void addPath(Resource path) {
            if (path == null || !path.exists()) {
                throw new IllegalStateException("No such path: " + String.valueOf(path));
            }
            this._classpath.add(path.getURI());
        }

        public URI[] asArray() {
            return this._classpath.toArray(new URI[0]);
        }
    }
}

