/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.maven.plugin;

import java.nio.file.Path;
import org.eclipse.jetty.ee9.quickstart.QuickStartConfiguration;
import org.eclipse.jetty.ee9.webapp.Configuration;
import org.eclipse.jetty.ee9.webapp.WebAppContext;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.resource.CombinedResource;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenQuickStartConfiguration
extends QuickStartConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(QuickStartConfiguration.class);

    public Class<? extends Configuration> replaces() {
        return QuickStartConfiguration.class;
    }

    public void deconfigure(WebAppContext context) throws Exception {
        if (!context.isPersistTempDirectory()) {
            Resource originalBases = (Resource)context.getAttribute("org.eclipse.jetty.resources.originalBases");
            String originalBaseStr = originalBases.toString();
            Resource res = context.getBaseResource();
            if (res instanceof CombinedResource) {
                for (Resource r : ((CombinedResource)res).getResources()) {
                    if (originalBaseStr.contains(r.toString())) continue;
                    IO.delete((Path)r.getPath());
                }
            }
        }
        super.deconfigure(context);
    }
}

