/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.jaas.spi;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.eclipse.jetty.ee9.jaas.JAASLoginService;
import org.eclipse.jetty.ee9.jaas.PropertyUserStoreManager;
import org.eclipse.jetty.ee9.jaas.spi.AbstractLoginModule;
import org.eclipse.jetty.ee9.security.PropertyUserStore;
import org.eclipse.jetty.ee9.security.RolePrincipal;
import org.eclipse.jetty.ee9.security.UserPrincipal;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFileLoginModule
extends AbstractLoginModule {
    public static final String DEFAULT_FILENAME = "realm.properties";
    private static final Logger LOG = LoggerFactory.getLogger(PropertyFileLoginModule.class);
    private PropertyUserStore _store;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.setupPropertyUserStore(options);
    }

    private void setupPropertyUserStore(Map<String, ?> options) {
        String filename = (String)options.get("file");
        filename = filename == null ? DEFAULT_FILENAME : filename;
        PropertyUserStoreManager mgr = (PropertyUserStoreManager)((Object)JAASLoginService.INSTANCE.get().getBean(PropertyUserStoreManager.class));
        if (mgr == null) {
            throw new IllegalStateException("No PropertyUserStoreManager");
        }
        this._store = mgr.getPropertyUserStore(filename);
        if (this._store == null) {
            int refreshInterval = 0;
            String tmp = (String)options.get("refreshInterval");
            if (tmp != null) {
                try {
                    refreshInterval = Integer.parseInt(tmp);
                }
                catch (NumberFormatException e) {
                    LOG.warn("'refreshInterval' is not an integer");
                }
            } else {
                tmp = (String)options.get("hotReload");
                if (tmp != null) {
                    LOG.warn("Use 'refreshInterval' boolean property instead of 'hotReload'");
                    refreshInterval = Boolean.parseBoolean(tmp) ? 1 : 0;
                }
            }
            PropertyUserStore newStore = new PropertyUserStore();
            ResourceFactory resourceFactory = ResourceFactory.of((Container)newStore);
            Resource config = resourceFactory.newResource(filename);
            newStore.setConfig(config);
            newStore.setRefreshInterval(refreshInterval);
            this._store = mgr.addPropertyUserStore(filename, newStore);
            try {
                this._store.start();
            }
            catch (Exception e) {
                LOG.warn("Exception starting propertyUserStore {} ", (Object)config, (Object)e);
            }
        }
    }

    @Override
    public AbstractLoginModule.JAASUser getUser(String userName) throws Exception {
        UserPrincipal up;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking PropertyUserStore {} for {}", (Object)this._store.getConfig(), (Object)userName);
        }
        if ((up = this._store.getUserPrincipal(userName)) == null) {
            return null;
        }
        List rps = this._store.getRolePrincipals(userName);
        final List roles = rps == null ? Collections.emptyList() : rps.stream().map(RolePrincipal::getName).collect(Collectors.toList());
        return new AbstractLoginModule.JAASUser(up){

            @Override
            public List<String> doFetchRoles() {
                return roles;
            }
        };
    }
}

