/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.demos;

import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.function.Supplier;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.eclipse.jetty.ee9.annotations.AnnotationConfiguration;
import org.eclipse.jetty.ee9.demos.ExampleUtil;
import org.eclipse.jetty.ee9.demos.JettyDemos;
import org.eclipse.jetty.ee9.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.ee9.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.ee9.webapp.Configuration;
import org.eclipse.jetty.ee9.webapp.WebAppContext;
import org.eclipse.jetty.plus.jndi.EnvEntry;
import org.eclipse.jetty.plus.jndi.Resource;
import org.eclipse.jetty.plus.jndi.Transaction;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.jndi.NamingDump;
import org.example.MockDataSource;
import org.example.MockUserTransaction;

public class ServerWithAnnotations {
    public static Server createServer(int port) throws NamingException, FileNotFoundException {
        Server server = new Server(port);
        WebAppContext webapp = new WebAppContext();
        webapp.addConfiguration(new Configuration[]{new EnvConfiguration(), new PlusConfiguration(), new AnnotationConfiguration()});
        webapp.setContextPath("/");
        JettyDemos.MavenCoordinate mavenCoordinate = new JettyDemos.MavenCoordinate("org.eclipse.jetty.ee9.demos", "jetty-ee9-demo-spec-webapp", "", "war");
        Path warFile = JettyDemos.find("jetty-ee9-demo-spec/jetty-ee9-demo-spec-webapp/target/jetty-ee9-demo-spec-webapp-@VER@.war", mavenCoordinate);
        webapp.setWar(warFile.toString());
        webapp.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/jetty-jakarta-servlet-api-[^/]*\\.jar$");
        server.setHandler((Supplier)webapp);
        new Transaction("ee9", (Reference)new MockUserTransaction());
        new EnvEntry((Object)webapp, "maxAmount", (Object)100.0, true);
        new Resource((Object)server, "jdbc/mydatasource", (Object)new MockDataSource());
        server.addBean((Object)new NamingDump());
        String realmResourceName = "etc/realm.properties";
        org.eclipse.jetty.util.resource.Resource realmResource = webapp.getResourceFactory().newClassLoaderResource(realmResourceName, false);
        if (realmResource == null) {
            throw new FileNotFoundException("Unable to find " + realmResourceName);
        }
        HashLoginService loginService = new HashLoginService();
        loginService.setName("Test Realm");
        loginService.setConfig(realmResource);
        server.addBean((Object)loginService);
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Server server = ServerWithAnnotations.createServer(port);
        server.start();
        server.dumpStdErr();
        server.join();
    }
}

