/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.demos;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.jetty.ee9.demos.ExampleUtil;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class FileServer {
    public static Server createServer(int port, Resource baseResource) throws Exception {
        Server server = new Server(port);
        server.setDefaultHandler((Handler)new DefaultHandler());
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirAllowed(true);
        resourceHandler.setWelcomeFiles(new String[]{"index.html"});
        resourceHandler.setBaseResource(baseResource);
        server.setHandler((Handler)resourceHandler);
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Path userDir = Paths.get(System.getProperty("user.dir"), new String[0]);
        Resource pathResource = ResourceFactory.root().newResource(userDir);
        Server server = FileServer.createServer(port, pathResource);
        server.start();
        server.join();
    }
}

