/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.demos;

import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.eclipse.jetty.ee9.demos.ExampleUtil;
import org.eclipse.jetty.ee9.demos.JettyDemos;
import org.eclipse.jetty.ee9.webapp.Configurations;
import org.eclipse.jetty.ee9.webapp.WebAppContext;
import org.eclipse.jetty.server.Server;

public class OneWebApp {
    public static Server createServer(int port) throws IOException {
        Server server = new Server(port);
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath("/");
        JettyDemos.MavenCoordinate mavenCoordinate = new JettyDemos.MavenCoordinate("org.eclipse.jetty.ee9.demos", "jetty-ee9-demo-async-rest-webapp", "", "war");
        Path warFile = JettyDemos.find("jetty-ee9-demo-async-rest/jetty-ee9-demo-async-rest-webapp/target/jetty-ee9-demo-async-rest-webapp-@VER@.war", mavenCoordinate);
        webapp.setWar(warFile.toString());
        server.setHandler((Supplier)webapp);
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Server server = OneWebApp.createServer(port);
        Configurations.setServerDefault((Server)server);
        server.start();
        server.dumpStdErr();
        server.join();
    }
}

