/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.demos;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.function.Supplier;
import org.eclipse.jetty.ee9.demos.DumpServlet;
import org.eclipse.jetty.ee9.demos.ExampleUtil;
import org.eclipse.jetty.ee9.demos.HelloServlet;
import org.eclipse.jetty.ee9.servlet.DefaultServlet;
import org.eclipse.jetty.ee9.servlet.ListenerHolder;
import org.eclipse.jetty.ee9.servlet.ServletContextHandler;
import org.eclipse.jetty.ee9.servlet.ServletHolder;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class OneServletContext {
    public static Server createServer(int port, Resource baseResource) {
        Server server = new Server(port);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        context.setBaseResource(baseResource);
        server.setHandler((Supplier)context);
        context.addServlet(HelloServlet.class, "/hello/*");
        ServletHolder debugHolder = new ServletHolder("debug", DumpServlet.class);
        context.addServlet(debugHolder, "/dump/*");
        context.addServlet(debugHolder, "*.dump");
        context.addServlet(DefaultServlet.class, "/");
        context.addFilter(TestFilter.class, "/test/*", EnumSet.of(DispatcherType.REQUEST));
        context.addFilter(TestFilter.class, "*.test", EnumSet.of(DispatcherType.REQUEST, DispatcherType.ASYNC));
        context.getServletHandler().addListener(new ListenerHolder(InitListener.class));
        context.getServletHandler().addListener(new ListenerHolder(RequestListener.class));
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Path tempDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        Server server = OneServletContext.createServer(port, ResourceFactory.root().newResource(tempDir));
        server.start();
        server.dumpStdErr();
        server.join();
    }

    public static class TestFilter
    implements Filter {
        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            if (response instanceof HttpServletResponse) {
                HttpServletResponse httpServletResponse = (HttpServletResponse)response;
                httpServletResponse.setHeader("X-TestFilter", "true");
            }
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    }

    public static class InitListener
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent sce) {
            sce.getServletContext().setAttribute("X-Init", (Object)"true");
        }

        public void contextDestroyed(ServletContextEvent sce) {
        }
    }

    public static class RequestListener
    implements ServletRequestListener {
        public void requestInitialized(ServletRequestEvent sre) {
            sre.getServletRequest().setAttribute("X-ReqListener", (Object)"true");
        }

        public void requestDestroyed(ServletRequestEvent sre) {
        }
    }
}

