/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.demos;

import java.util.function.Supplier;
import org.eclipse.jetty.ee9.demos.ExampleUtil;
import org.eclipse.jetty.ee9.servlet.ServletContextHandler;
import org.eclipse.jetty.ee9.websocket.api.Session;
import org.eclipse.jetty.ee9.websocket.api.WriteCallback;
import org.eclipse.jetty.ee9.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.ee9.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.ee9.websocket.server.JettyWebSocketServlet;
import org.eclipse.jetty.ee9.websocket.server.JettyWebSocketServletFactory;
import org.eclipse.jetty.ee9.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.eclipse.jetty.server.Server;

public class WebSocketServer {
    public static Server createServer(int port) {
        Server server = new Server(port);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        server.setHandler((Supplier)context);
        context.addServlet(EchoServlet.class, "/echo");
        JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)context, null);
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Server server = WebSocketServer.createServer(port);
        server.start();
        server.join();
    }

    public static class EchoServlet
    extends JettyWebSocketServlet {
        public void configure(JettyWebSocketServletFactory factory) {
            factory.addMapping("/", (req, res) -> new EchoSocket());
        }
    }

    @WebSocket
    public static class EchoSocket {
        @OnWebSocketMessage
        public void onMessage(Session session, String message) {
            session.getRemote().sendString(message, WriteCallback.NOOP);
        }
    }
}

