/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.demos;

import jakarta.servlet.Servlet;
import java.lang.management.ManagementFactory;
import org.eclipse.jetty.ee9.demos.ExampleUtil;
import org.eclipse.jetty.ee9.demos.HelloServlet;
import org.eclipse.jetty.ee9.servlet.DefaultServlet;
import org.eclipse.jetty.ee9.servlet.ServletContextHandler;
import org.eclipse.jetty.ee9.servlet.ServletHolder;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;

public class ManyServletContexts {
    public static Server createServer(int port) {
        Server server = new Server(port);
        MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        server.addBean((Object)mbContainer, true);
        ContextHandlerCollection contexts = new ContextHandlerCollection(new ContextHandler[0]);
        server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((Handler.Container)contexts, "/", 1);
        root.addServlet(new ServletHolder((Servlet)new HelloServlet("Hello")), "/");
        root.addServlet(new ServletHolder((Servlet)new HelloServlet("Ciao")), "/it/*");
        root.addServlet(new ServletHolder((Servlet)new HelloServlet("Bonjour")), "/fr/*");
        ServletContextHandler other = new ServletContextHandler((Handler.Container)contexts, "/other", 1);
        other.addServlet(DefaultServlet.class.getCanonicalName(), "/");
        other.addServlet(new ServletHolder((Servlet)new HelloServlet("YO!")), "*.yo");
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Server server = ManyServletContexts.createServer(port);
        server.start();
        server.dumpStdErr();
        server.join();
    }
}

