/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.demos;

import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;

public class HelloHandler
extends Handler.Abstract {
    final String greeting;
    final String body;

    public HelloHandler() {
        this("Hello World");
    }

    public HelloHandler(String greeting) {
        this(greeting, null);
    }

    public HelloHandler(String greeting, String body) {
        this.greeting = greeting;
        this.body = body;
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        response.getHeaders().add(HttpHeader.CONTENT_TYPE, "text/html; charset=utf-8");
        response.setStatus(200);
        if (this.body == null) {
            response.write(true, BufferUtil.toBuffer((String)("<h1>" + this.greeting + "</h1>")), callback);
        } else {
            response.write(false, BufferUtil.toBuffer((String)("<h1>" + this.greeting + "</h1>")), Callback.from(() -> response.write(true, BufferUtil.toBuffer((String)this.body), callback), arg_0 -> ((Callback)callback).failed(arg_0)));
        }
        return true;
    }
}

