/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.demos;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;

public class DumpServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        response.setStatus(200);
        PrintWriter out = response.getWriter();
        out.println("<h1>DumpServlet</h1>");
        out.println("<pre>");
        out.println("requestURI=" + request.getRequestURI());
        out.println("requestURL=" + request.getRequestURL().toString());
        out.println("contextPath=" + request.getContextPath());
        out.println("servletPath=" + request.getServletPath());
        out.println("pathInfo=" + request.getPathInfo());
        out.println("session=" + request.getSession(true).getId());
        ServletContext servletContext = this.getServletContext();
        String r = request.getParameter("resource");
        if (r != null) {
            out.println("resource(" + r + ")=" + String.valueOf(servletContext.getResource(r)));
        }
        Collections.list(request.getAttributeNames()).stream().filter(name -> name.startsWith("X-")).sorted().forEach(name -> out.println("request.attribute[" + name + "]=" + String.valueOf(request.getAttribute(name))));
        Collections.list(servletContext.getAttributeNames()).stream().filter(name -> name.startsWith("X-")).sorted().forEach(name -> out.println("servletContext.attribute[" + name + "]=" + String.valueOf(servletContext.getAttribute(name))));
        out.println("</pre>");
    }
}

