/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.demos;

import jakarta.servlet.Servlet;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.function.Supplier;
import org.eclipse.jetty.ee9.demos.ExampleUtil;
import org.eclipse.jetty.ee9.demos.HelloServlet;
import org.eclipse.jetty.ee9.nested.ServletConstraint;
import org.eclipse.jetty.ee9.security.Authenticator;
import org.eclipse.jetty.ee9.security.ConstraintMapping;
import org.eclipse.jetty.ee9.security.ConstraintSecurityHandler;
import org.eclipse.jetty.ee9.security.SecurityHandler;
import org.eclipse.jetty.ee9.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.ee9.servlet.ServletContextHandler;
import org.eclipse.jetty.ee9.servlet.ServletHolder;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class SecuredHelloHandler {
    public static Server createServer(int port) throws FileNotFoundException {
        Server server = new Server(port);
        String realmResourceName = "etc/realm.properties";
        Resource realmResource = ResourceFactory.of((Container)server).newClassLoaderResource("etc/realm.properties", false);
        if (realmResource == null) {
            throw new FileNotFoundException("Unable to find " + realmResourceName);
        }
        HashLoginService loginService = new HashLoginService("MyRealm", realmResource);
        server.addBean((Object)loginService);
        ServletContextHandler context = new ServletContextHandler();
        server.setHandler((Supplier)context);
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        context.setSecurityHandler((SecurityHandler)security);
        ServletConstraint constraint = new ServletConstraint();
        constraint.setName("auth");
        constraint.setAuthenticate(true);
        constraint.setRoles(new String[]{"user", "admin"});
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setPathSpec("/*");
        mapping.setConstraint(constraint);
        security.setConstraintMappings(Collections.singletonList(mapping));
        security.setAuthenticator((Authenticator)new BasicAuthenticator());
        security.setLoginService((LoginService)loginService);
        ServletHolder holder = new ServletHolder();
        holder.setServlet((Servlet)new HelloServlet("Hello World"));
        context.getServletHandler().addServletWithMapping(holder, "/");
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Server server = SecuredHelloHandler.createServer(port);
        server.start();
        server.join();
    }
}

