/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.demos;

import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.eclipse.jetty.ee9.annotations.AnnotationConfiguration;
import org.eclipse.jetty.ee9.demos.ExampleUtil;
import org.eclipse.jetty.ee9.demos.JettyDemos;
import org.eclipse.jetty.ee9.webapp.Configuration;
import org.eclipse.jetty.ee9.webapp.WebAppContext;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.resource.Resource;

public class OneWebAppWithJsp {
    public static Server createServer(int port) throws FileNotFoundException {
        Server server = new Server(port);
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath("/");
        JettyDemos.MavenCoordinate mavenCoordinate = new JettyDemos.MavenCoordinate("org.eclipse.jetty.ee9.demos", "jetty-ee9-demo-jsp-webapp", "", "war");
        Path warFile = JettyDemos.find("jetty-ee9-demo-jsp-webapp/target/jetty-ee9-demo-jsp-webapp-@VER@.war", mavenCoordinate);
        webapp.setWarResource(webapp.getResourceFactory().newResource(warFile));
        webapp.setExtractWAR(true);
        webapp.addConfiguration(new Configuration[]{new AnnotationConfiguration()});
        webapp.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/jetty-jakarta-servlet-api-[^/]*\\.jar$|.*/jakarta.servlet.jsp.jstl-.*\\.jar$|.*/[^/]*taglibs.*\\.jar$");
        server.setHandler((Supplier)webapp);
        String realmResourceName = "etc/realm.properties";
        Resource realmResource = webapp.getResourceFactory().newClassLoaderResource(realmResourceName, false);
        if (realmResource == null) {
            throw new FileNotFoundException("Unable to find " + realmResourceName);
        }
        HashLoginService loginService = new HashLoginService();
        loginService.setName("Test Realm");
        loginService.setConfig(realmResource);
        server.addBean((Object)loginService);
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Server server = OneWebAppWithJsp.createServer(port);
        server.start();
        server.dumpStdErr();
        server.join();
    }
}

