/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.demos;

import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.function.Supplier;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.eclipse.jetty.ee9.demos.ExampleUtil;
import org.eclipse.jetty.ee9.demos.JettyDemos;
import org.eclipse.jetty.ee9.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.ee9.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.ee9.webapp.Configuration;
import org.eclipse.jetty.ee9.webapp.WebAppContext;
import org.eclipse.jetty.plus.jndi.EnvEntry;
import org.eclipse.jetty.plus.jndi.Resource;
import org.eclipse.jetty.plus.jndi.Transaction;
import org.eclipse.jetty.server.Server;
import org.example.MockDataSource;
import org.example.MockUserTransaction;

public class ServerWithJNDI {
    public static Server createServer(int port) throws NamingException, FileNotFoundException {
        Server server = new Server(port);
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath("/");
        JettyDemos.MavenCoordinate mavenCoordinate = new JettyDemos.MavenCoordinate("org.eclipse.jetty.ee9.demos", "jetty-ee9-demo-jndi-webapp", "", "war");
        Path testJndiWar = JettyDemos.find("jetty-ee9-demo-jndi-webapp/target/jetty-ee9-demo-jndi-webapp-@VER@.war", mavenCoordinate);
        webapp.setWarResource(webapp.getResourceFactory().newResource(testJndiWar));
        server.setHandler((Supplier)webapp);
        webapp.addConfiguration(new Configuration[]{new EnvConfiguration(), new PlusConfiguration()});
        new Transaction("ee9", (Reference)new MockUserTransaction());
        new EnvEntry((Object)"ee9", "woggle", (Object)4000, false);
        new EnvEntry((Object)webapp, "wiggle", (Object)100.0, true);
        new Resource((Object)webapp, "jdbc/mydatasource", (Object)new MockDataSource());
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Server server = ServerWithJNDI.createServer(port);
        server.start();
        server.join();
    }
}

