/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.demos;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;
import org.eclipse.jetty.ee9.demos.ExampleUtil;
import org.eclipse.jetty.ee9.demos.HelloSessionServlet;
import org.eclipse.jetty.ee9.nested.SessionHandler;
import org.eclipse.jetty.ee9.servlet.ServletContextHandler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.session.DefaultSessionCache;
import org.eclipse.jetty.session.NullSessionDataStore;
import org.eclipse.jetty.session.SessionCache;
import org.eclipse.jetty.session.SessionDataStore;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class OneServletContextWithSession {
    public static Server createServer(int port, Resource baseResource) {
        Server server = new Server(port);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        context.setBaseResource(baseResource);
        server.setHandler((Supplier)context);
        SessionHandler sessions = context.getSessionHandler();
        DefaultSessionCache cache = new DefaultSessionCache(sessions.getSessionManager());
        cache.setSessionDataStore((SessionDataStore)new NullSessionDataStore());
        sessions.setSessionCache((SessionCache)cache);
        context.addServlet(HelloSessionServlet.class, "/");
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Path dir = Paths.get(System.getProperty("user.dir"), new String[0]);
        Resource baseResource = ResourceFactory.root().newResource(dir);
        Server server = OneServletContextWithSession.createServer(port, baseResource);
        server.start();
        server.dumpStdErr();
        server.join();
    }
}

