/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.demos;

import java.lang.management.ManagementFactory;
import java.util.function.Supplier;
import org.eclipse.jetty.ee9.demos.DumpServlet;
import org.eclipse.jetty.ee9.demos.ExampleUtil;
import org.eclipse.jetty.ee9.servlet.DefaultServlet;
import org.eclipse.jetty.ee9.servlet.ServletContextHandler;
import org.eclipse.jetty.io.ConnectionStatistics;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Server;

public class OneServletContextJmxStats {
    public static Server createServer(int port) {
        Server server = new Server(port);
        server.addBean((Object)new MBeanContainer(ManagementFactory.getPlatformMBeanServer()));
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        server.setHandler((Supplier)context);
        context.addServlet(DumpServlet.class, "/dump/*");
        context.addServlet(DefaultServlet.class, "/");
        server.addBeanToAllConnectors((Object)new ConnectionStatistics());
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Server server = OneServletContextJmxStats.createServer(port);
        server.start();
        server.join();
    }
}

