/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.demos;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.jetty.ee9.demos.ExampleUtil;
import org.eclipse.jetty.ee9.demos.HelloHandler;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ajax.JSON;

public class ManyHandlers {
    public static Server createServer(int port) throws IOException {
        Server server = new Server(port);
        server.setDefaultHandler((Handler)new DefaultHandler());
        ParamHandler param = new ParamHandler();
        WelcomeWrapHandler wrapper = new WelcomeWrapHandler();
        HelloHandler hello = new HelloHandler();
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setMinGzipSize(10);
        gzipHandler.addIncludedMimeTypes(new String[]{"text/plain"});
        gzipHandler.addIncludedMimeTypes(new String[]{"text/html"});
        Path requestLogFile = Files.createTempFile("demo", "log", new FileAttribute[0]);
        CustomRequestLog ncsaLog = new CustomRequestLog(requestLogFile.toString());
        server.setRequestLog((RequestLog)ncsaLog);
        wrapper.setHandler((Handler)hello);
        ContextHandler helloContext = new ContextHandler("/hello");
        helloContext.setHandler((Handler)wrapper);
        ContextHandler paramContext = new ContextHandler("/params");
        paramContext.setHandler((Handler)param);
        ContextHandlerCollection contexts = new ContextHandlerCollection(new ContextHandler[]{helloContext, paramContext});
        gzipHandler.setHandler((Handler)contexts);
        server.setHandler((Handler)gzipHandler);
        server.setDumpAfterStart(true);
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Server server = ManyHandlers.createServer(port);
        server.start();
        server.join();
    }

    public static class ParamHandler
    extends Handler.Abstract {
        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            response.getHeaders().add(HttpHeader.CONTENT_TYPE, "text/plain");
            response.setStatus(200);
            response.write(true, BufferUtil.toBuffer((String)new JSON().toJSON((Object)request.getAttributeNameSet())), callback);
            return true;
        }
    }

    public static class WelcomeWrapHandler
    extends Handler.Wrapper {
        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            Handler next = this.getHandler();
            if (next == null) {
                return false;
            }
            response.getHeaders().add(HttpHeader.CONTENT_TYPE, "text/plain");
            return next.handle(request, response, callback);
        }
    }
}

