/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.demos;

import jakarta.servlet.Servlet;
import java.io.FileNotFoundException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.jetty.ee9.demos.ExampleUtil;
import org.eclipse.jetty.ee9.servlet.DefaultServlet;
import org.eclipse.jetty.ee9.servlet.ServletContextHandler;
import org.eclipse.jetty.ee9.servlet.ServletHolder;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class JarServer {
    public static Server createServer(int port, URI jarBase) throws Exception {
        Objects.requireNonNull(jarBase);
        URI baseUri = jarBase;
        if (FileID.isArchive((URI)baseUri)) {
            baseUri = URIUtil.toJarFileUri((URI)baseUri);
        }
        Server server = new Server(port);
        Resource baseResource = ResourceFactory.of((Container)server).newResource(baseUri);
        ServletContextHandler context = new ServletContextHandler();
        context.setBaseResource(baseResource);
        ServletHolder defaultHolder = new ServletHolder("default", (Servlet)new DefaultServlet());
        context.addServlet(defaultHolder, "/");
        server.setHandler((Supplier)context);
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Path jarFile = Paths.get("src/main/other/content.jar", new String[0]);
        if (!Files.exists(jarFile, new LinkOption[0])) {
            throw new FileNotFoundException(jarFile.toString());
        }
        Server server = JarServer.createServer(port, jarFile.toUri());
        server.start();
        server.join();
    }
}

