/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.demos;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.jetty.ee9.demos.ExampleUtil;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.xml.XmlConfiguration;

public class FileServerXml {
    public static Server createServer(int port, Path basePath) throws Exception {
        ResourceFactory.LifeCycle resourceFactory = ResourceFactory.lifecycle();
        Resource fileServerXml = resourceFactory.newClassLoaderResource("fileserver.xml");
        Resource baseResource = resourceFactory.newResource(basePath);
        XmlConfiguration configuration = new XmlConfiguration(fileServerXml);
        configuration.getProperties().put("fileserver.baseResource", baseResource.toString());
        configuration.getProperties().put("http.port", Integer.toString(port));
        Server server = (Server)configuration.configure();
        server.addBean((Object)resourceFactory, true);
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Path userDir = Paths.get(System.getProperty("user.dir"), new String[0]);
        Server server = FileServerXml.createServer(port, userDir);
        server.start();
        server.join();
    }
}

