/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.demos;

import java.io.File;
import org.eclipse.jetty.ee9.demos.ExampleUtil;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.Callback;

public class FastFileServer {
    public static Server createServer(int port, File resourceBase) {
        Server server = new Server(port);
        server.setHandler((Handler)new FastFileHandler(resourceBase));
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        File directory = new File(System.getProperty("user.dir"));
        Server server = FastFileServer.createServer(port, directory);
        server.start();
        server.join();
    }

    static class FastFileHandler
    extends Handler.Abstract {
        private FastFileHandler(File dir) {
        }

        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            return false;
        }
    }
}

