/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.demos;

import java.util.List;
import org.eclipse.jetty.ee9.demos.ExampleUtil;
import org.eclipse.jetty.ee9.demos.HelloHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;

public class ManyContexts {
    public static Server createServer(int port) {
        Server server = new Server(port);
        ContextHandler context = new ContextHandler("/");
        context.setContextPath("/");
        context.setHandler((Handler)new HelloHandler("Root Hello"));
        ContextHandler contextFR = new ContextHandler("/fr");
        contextFR.setHandler((Handler)new HelloHandler("Bonjour"));
        ContextHandler contextIT = new ContextHandler("/it");
        contextIT.setHandler((Handler)new HelloHandler("Buongiorno"));
        ContextHandler contextV = new ContextHandler("/");
        contextV.setVirtualHosts(List.of("127.0.0.2"));
        contextV.setHandler((Handler)new HelloHandler("Virtual Hello"));
        ContextHandlerCollection contexts = new ContextHandlerCollection(new ContextHandler[]{context, contextFR, contextIT, contextV});
        server.setHandler((Handler)contexts);
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Server server = ManyContexts.createServer(port);
        server.start();
        server.dumpStdErr();
        server.join();
    }
}

