/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.demos;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.ee9.demos.AbstractRestServlet;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.ajax.JSON;

public class AsyncRestServlet
extends AbstractRestServlet {
    static final String RESULTS_ATTR = "org.eclipse.jetty.demo.client";
    static final String DURATION_ATTR = "org.eclipse.jetty.demo.duration";
    static final String START_ATTR = "org.eclispe.jetty.demo.start";
    HttpClient _client;

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this._client = new HttpClient();
        try {
            this._client.start();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long start = NanoTime.now();
        ConcurrentLinkedQueue results = (ConcurrentLinkedQueue)request.getAttribute(RESULTS_ATTR);
        if (results == null) {
            results = new ConcurrentLinkedQueue();
            request.setAttribute(RESULTS_ATTR, results);
            final AsyncContext async = request.startAsync();
            async.setTimeout(30000L);
            String[] keywords = AsyncRestServlet.sanitize(request.getParameter("items")).split(",");
            final AtomicInteger outstanding = new AtomicInteger(keywords.length);
            final ConcurrentLinkedQueue resultsQueue = results;
            for (String item : keywords) {
                this._client.newRequest(this.restURL(item)).method(HttpMethod.GET).send((Response.CompleteListener)new AsyncRestRequest(this){
                    final /* synthetic */ AsyncRestServlet this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    void onAuctionFound(Map<String, Object> auction) {
                        resultsQueue.add(auction);
                    }

                    @Override
                    void onComplete() {
                        if (outstanding.decrementAndGet() <= 0) {
                            async.dispatch();
                        }
                    }
                });
            }
            request.setAttribute(START_ATTR, (Object)start);
            request.setAttribute(DURATION_ATTR, (Object)NanoTime.since((long)start));
            return;
        }
        String thumbs = this.generateThumbs(results);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html><head>");
        out.println("<style type='text/css'>  img.thumb:hover {height:50px}  img.thumb {vertical-align:text-top}  span.red {color: #ff0000}  span.green {color: #00ff00}  iframe {border: 0px}</style>");
        out.println("</head><body><small>");
        long initial = (Long)request.getAttribute(DURATION_ATTR);
        long start0 = (Long)request.getAttribute(START_ATTR);
        long now = NanoTime.now();
        long total = NanoTime.elapsed((long)start0, (long)now);
        long generate = NanoTime.elapsed((long)start, (long)now);
        long thread = initial + generate;
        out.print("<b>Asynchronous: " + AsyncRestServlet.sanitize(request.getParameter("items")) + "</b><br/>");
        out.print("Total Time: " + this.ms(total) + "ms<br/>");
        out.print("Thread held (<span class='red'>red</span>): " + this.ms(thread) + "ms (" + this.ms(initial) + " initial + " + this.ms(generate) + " generate )<br/>");
        out.print("Async wait (<span class='green'>green</span>): " + this.ms(total - thread) + "ms<br/>");
        out.println("<img border='0px' src='asyncrest/red.png'   height='20px' width='" + this.width(initial) + "px'><img border='0px' src='asyncrest/green.png' height='20px' width='" + this.width(total - thread) + "px'><img border='0px' src='asyncrest/red.png'   height='20px' width='" + this.width(generate) + "px'>");
        out.println("<hr />");
        out.println(thumbs);
        out.println("</small>");
        out.println("</body></html>");
        out.close();
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private static abstract class AsyncRestRequest
    implements Response.Listener {
        private final Utf8StringBuilder _content = new Utf8StringBuilder();

        AsyncRestRequest() {
        }

        public void onContent(Response response, ByteBuffer content) {
            byte[] bytes = BufferUtil.toArray((ByteBuffer)content);
            this._content.append(bytes, 0, bytes.length);
        }

        public void onComplete(Result result) {
            Map query = (Map)new JSON().fromJSON((CharSequence)this._content.toCompleteString());
            Object[] auctions = (Object[])query.get("Item");
            if (auctions != null) {
                for (Object o : auctions) {
                    Map auction = (Map)o;
                    this.onAuctionFound(auction);
                }
            }
            this.onComplete();
        }

        abstract void onComplete();

        abstract void onAuctionFound(Map<String, Object> var1);
    }
}

