/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.websocket.javax.server.config;

import java.util.ArrayList;
import java.util.List;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContainerDefaultConfigurator
extends ServerEndpointConfig.Configurator {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerDefaultConfigurator.class);
    private static final String NO_SUBPROTOCOL = "";

    public boolean checkOrigin(String originHeaderValue) {
        return true;
    }

    public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(".getEndpointInstance({})", endpointClass);
        }
        try {
            return endpointClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            String errorMsg = String.format("%s: %s", e.getClass().getName(), e.getMessage());
            InstantiationException instantiationException = new InstantiationException(errorMsg);
            instantiationException.initCause(e);
            throw instantiationException;
        }
    }

    public List<Extension> getNegotiatedExtensions(List<Extension> installed, List<Extension> requested) {
        ArrayList<Extension> negotiatedExtensions = new ArrayList<Extension>();
        for (Extension ext : requested) {
            long matches = negotiatedExtensions.stream().filter(e -> e.getName().equals(ext.getName())).count();
            if (matches != 0L) continue;
            negotiatedExtensions.add(ext);
        }
        return negotiatedExtensions;
    }

    public String getNegotiatedSubprotocol(List<String> supported, List<String> requested) {
        if (requested == null || requested.size() == 0) {
            return NO_SUBPROTOCOL;
        }
        if (supported == null || supported.isEmpty()) {
            LOG.warn("Client requested Subprotocols on endpoint with none supported: {}", (Object)String.join((CharSequence)",", requested));
            return NO_SUBPROTOCOL;
        }
        for (String possible : requested) {
            if (possible == null || !supported.contains(possible)) continue;
            return possible;
        }
        LOG.warn("Client requested subprotocols {} do not match any endpoint supported subprotocols {}", (Object)String.join((CharSequence)",", requested), (Object)String.join((CharSequence)",", supported));
        return NO_SUBPROTOCOL;
    }

    public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
    }
}

