/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.osgi.boot;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jetty.deploy.Deployer;
import org.eclipse.jetty.deploy.StandardDeployer;
import org.eclipse.jetty.ee.WebAppClassLoader;
import org.eclipse.jetty.ee8.osgi.boot.PackageAdminServiceTracker;
import org.eclipse.jetty.ee8.webapp.Configuration;
import org.eclipse.jetty.ee8.webapp.Configurations;
import org.eclipse.jetty.ee8.webapp.WebAppContext;
import org.eclipse.jetty.osgi.AbstractContextProvider;
import org.eclipse.jetty.osgi.BundleContextProvider;
import org.eclipse.jetty.osgi.BundleMetadata;
import org.eclipse.jetty.osgi.BundleWebAppProvider;
import org.eclipse.jetty.osgi.ContextFactory;
import org.eclipse.jetty.osgi.OSGiWebappClassLoader;
import org.eclipse.jetty.osgi.OSGiWebappConstants;
import org.eclipse.jetty.osgi.util.BundleFileLocatorHelperFactory;
import org.eclipse.jetty.osgi.util.FakeURLClassLoader;
import org.eclipse.jetty.osgi.util.OSGiClassLoader;
import org.eclipse.jetty.osgi.util.ServerClasspathContributor;
import org.eclipse.jetty.osgi.util.Util;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.URLResourceFactory;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EE8Activator
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(EE8Activator.class);
    public static final String ENVIRONMENT = "ee8";
    private static Collection<ServerClasspathContributor> __serverClasspathContributors = new ArrayList<ServerClasspathContributor>();
    private PackageAdminServiceTracker _packageAdminServiceTracker;
    private ServiceTracker _tracker;

    public static void registerServerClasspathContributor(ServerClasspathContributor contributor) {
        __serverClasspathContributors.add(contributor);
    }

    public static void unregisterServerClasspathContributor(ServerClasspathContributor contributor) {
        __serverClasspathContributors.remove(contributor);
    }

    public static Collection<ServerClasspathContributor> getServerClasspathContributors() {
        return __serverClasspathContributors;
    }

    public void start(BundleContext context) throws Exception {
        this._packageAdminServiceTracker = new PackageAdminServiceTracker(context);
        this._tracker = new ServiceTracker(context, context.createFilter("(objectclass=" + Server.class.getName() + ")"), (ServiceTrackerCustomizer)new ServerTracker(context.getBundle()));
        this._tracker.open();
        ResourceFactory.registerResourceFactory((String)"bundleresource", (ResourceFactory)new URLResourceFactory());
    }

    public void stop(BundleContext context) throws Exception {
        if (this._tracker != null) {
            this._tracker.close();
            this._tracker = null;
        }
    }

    public static class ServerTracker
    implements ServiceTrackerCustomizer {
        private Bundle _myBundle = null;

        public ServerTracker(Bundle bundle) {
            this._myBundle = bundle;
        }

        public Object addingService(ServiceReference sr) {
            Bundle contributor = sr.getBundle();
            Server server = (Server)contributor.getBundleContext().getService(sr);
            ArrayList contributedURLs = new ArrayList();
            ArrayList contributedBundles = new ArrayList();
            Collection<ServerClasspathContributor> serverClasspathContributors = EE8Activator.getServerClasspathContributors();
            serverClasspathContributors.forEach(c -> contributedBundles.addAll(c.getScannableBundles()));
            contributedBundles.forEach(b -> contributedURLs.addAll(this.convertBundleToURL((Bundle)b)));
            if (!contributedURLs.isEmpty()) {
                ClassLoader serverClassLoader = (ClassLoader)server.getAttribute("org.eclipse.jetty.osgi.server.classLoader");
                if (serverClassLoader != null) {
                    server.setAttribute("org.eclipse.jetty.osgi.server.classLoader", (Object)new FakeURLClassLoader(serverClassLoader, contributedURLs.toArray(new URL[0])));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Server classloader for contexts = {}", server.getAttribute("org.eclipse.jetty.osgi.server.classLoader"));
                    }
                }
                server.setAttribute("org.eclipse.jetty.osgi.server.classpathBundles", contributedBundles);
            }
            Optional<StandardDeployer> serverDeployer = this.getDeployer(server);
            BundleWebAppProvider webAppProvider = null;
            BundleContextProvider contextProvider = null;
            String containerScanBundlePattern = null;
            if (!contributedBundles.isEmpty()) {
                containerScanBundlePattern = contributedBundles.stream().map(Bundle::getSymbolicName).collect(Collectors.joining("|"));
            }
            if (serverDeployer.isPresent()) {
                StandardDeployer deployer = serverDeployer.get();
                Collection osgiProviders = deployer.getBeans(AbstractContextProvider.class);
                for (AbstractContextProvider provider : osgiProviders) {
                    BundleWebAppProvider bundleWebAppProvider;
                    BundleContextProvider bundleContextProvider;
                    if (provider instanceof BundleContextProvider && (bundleContextProvider = (BundleContextProvider)provider).getEnvironmentName().equalsIgnoreCase(EE8Activator.ENVIRONMENT)) {
                        contextProvider = bundleContextProvider;
                    }
                    if (!(provider instanceof BundleWebAppProvider) || !(bundleWebAppProvider = (BundleWebAppProvider)provider).getEnvironmentName().equalsIgnoreCase(EE8Activator.ENVIRONMENT)) continue;
                    webAppProvider = bundleWebAppProvider;
                }
                if (contextProvider == null) {
                    contextProvider = new BundleContextProvider(server, (Deployer)deployer, EE8Activator.ENVIRONMENT, (ContextFactory)new EE9ContextFactory(this._myBundle));
                    deployer.addBean((Object)contextProvider);
                }
                if (webAppProvider == null) {
                    webAppProvider = new BundleWebAppProvider(server, (Deployer)deployer, EE8Activator.ENVIRONMENT, (ContextFactory)new EE9WebAppFactory(this._myBundle));
                    deployer.addBean((Object)webAppProvider);
                }
                if (containerScanBundlePattern != null) {
                    contextProvider.getAttributes().setAttribute("org.eclipse.jetty.server.webapp.containerIncludeBundlePattern", (Object)containerScanBundlePattern);
                    webAppProvider.getAttributes().setAttribute("org.eclipse.jetty.server.webapp.containerIncludeBundlePattern", (Object)containerScanBundlePattern);
                }
            } else {
                LOG.info("No DeploymentManager for Server {}", (Object)server);
            }
            try {
                if (!server.isStarted()) {
                    server.start();
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to start server {}", (Object)server);
            }
            return server;
        }

        public void modifiedService(ServiceReference reference, Object service) {
            this.removedService(reference, service);
            this.addingService(reference);
        }

        public void removedService(ServiceReference reference, Object service) {
        }

        private Optional<StandardDeployer> getDeployer(Server server) {
            Collection deployers = server.getBeans(StandardDeployer.class);
            return deployers.stream().findFirst();
        }

        private List<URL> convertBundleToURL(Bundle bundle) {
            ArrayList<URL> urls = new ArrayList<URL>();
            try {
                File file = BundleFileLocatorHelperFactory.getFactory().getHelper().getBundleInstallLocation(bundle);
                if (file.isDirectory()) {
                    for (File f : file.listFiles()) {
                        if (FileID.isJavaArchive((String)f.getName()) && f.isFile()) {
                            urls.add(f.toURI().toURL());
                            continue;
                        }
                        if (!f.isDirectory() || !f.getName().equals("lib")) continue;
                        for (File f2 : file.listFiles()) {
                            if (!FileID.isJavaArchive((String)f2.getName()) || !f2.isFile()) continue;
                            urls.add(f2.toURI().toURL());
                        }
                    }
                    urls.add(file.toURI().toURL());
                } else {
                    urls.add(file.toURI().toURL());
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to convert bundle {} to url", (Object)bundle, (Object)e);
            }
            return urls;
        }
    }

    public static class EE9WebAppFactory
    implements ContextFactory {
        private Bundle _myBundle;

        public EE9WebAppFactory(Bundle bundle) {
            this._myBundle = bundle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ContextHandler createContextHandler(AbstractContextProvider provider, BundleMetadata metadata) throws Exception {
            URI defaultWebXml;
            URI webXml;
            String tmp;
            String jettyHome = (String)provider.getServer().getAttribute("jetty.home");
            Path jettyHomePath = StringUtil.isBlank((String)jettyHome) ? null : ResourceFactory.of((Container)provider.getServer()).newResource(jettyHome).getPath();
            WebAppContext webApp = new WebAppContext();
            webApp.setAttribute("org.eclipse.jetty.osgi.bundle", (Object)metadata.getBundle());
            ResourceFactory resourceFactory = ResourceFactory.of((Container)webApp);
            webApp.initializeDefaults(provider.getAttributes());
            ClassLoader coreLoader = (ClassLoader)provider.getServer().getAttribute("org.eclipse.jetty.osgi.server.classLoader");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Core classloader = {}", (Object)coreLoader);
            }
            OSGiClassLoader environmentLoader = new OSGiClassLoader(coreLoader, this._myBundle);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Environment classloader = {}", (Object)environmentLoader);
            }
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)environmentLoader);
                WebAppClassLoader.runWithHiddenClassAccess(() -> {
                    Configurations.getKnown();
                    return null;
                });
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
            webApp.setConfigurations((Configuration[])Configurations.getKnown().stream().filter(Configuration::isEnabledByDefault).toArray(Configuration[]::new));
            OSGiWebappClassLoader webAppLoader = new OSGiWebappClassLoader((ClassLoader)environmentLoader, (WebAppClassLoader.Context)webApp, metadata.getBundle());
            String requireTldBundles = (String)metadata.getAttributes().getAttribute("Require-TldBundle");
            List pathsToTldBundles = Util.getPathsToBundlesBySymbolicNames((String)requireTldBundles, (BundleContext)metadata.getBundle().getBundleContext());
            for (Path p : pathsToTldBundles) {
                webAppLoader.addClassPath(p.toUri().toString());
            }
            String extraClasspath = (String)metadata.getAttributes().getAttribute("Jetty-extraClasspath");
            if (extraClasspath != null) {
                webApp.setExtraClasspath(extraClasspath);
            }
            webApp.setClassLoader((ClassLoader)webAppLoader);
            webApp.setAttribute("org.eclipse.jetty.server.webapp.containerIncludeBundlePattern", provider.getAttributes().getAttribute("org.eclipse.jetty.server.webapp.containerIncludeBundlePattern"));
            webApp.setAttribute("Require-TldBundle", (Object)requireTldBundles);
            webApp.setAttribute("osgi-bundlecontext", (Object)metadata.getBundle().getBundleContext());
            webApp.setAttribute("org.springframework.osgi.web." + BundleContext.class.getName(), (Object)metadata.getBundle().getBundleContext());
            webApp.setAttribute("osgi-bundle", (Object)metadata.getBundle());
            URI tmpUri = null;
            URL contextXmlURL = Util.getLocalizedEntry((String)"/META-INF/jetty-webapp-context.xml", (Bundle)metadata.getBundle());
            if (contextXmlURL != null) {
                tmpUri = contextXmlURL.toURI();
            }
            if (contextXmlURL == null && (tmp = (String)metadata.getAttributes().getAttribute("Jetty-ContextFilePath")) != null) {
                String[] filenames = tmp.split("[,;]");
                tmpUri = Util.resolvePathAsLocalizedURI((String)filenames[0], (Bundle)metadata.getBundle(), (Path)jettyHomePath);
            }
            if (tmpUri != null) {
                URI contextXmlUri = tmpUri;
                ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(webApp.getClassLoader());
                    WebAppClassLoader.runWithHiddenClassAccess(() -> {
                        Server server = provider.getServer();
                        XmlConfiguration xmlConfiguration = new XmlConfiguration(ResourceFactory.of((Container)webApp).newResource(contextXmlUri));
                        xmlConfiguration.setJettyStandardIdsAndProperties((Object)server, null);
                        WebAppClassLoader.runWithHiddenClassAccess(() -> {
                            HashMap<String, String> properties = new HashMap<String, String>();
                            properties.put("bundle.root", metadata.getPath().toUri().toString());
                            properties.put("jetty.home", (String)server.getAttribute("jetty.home"));
                            xmlConfiguration.getProperties().putAll(properties);
                            xmlConfiguration.configure((Object)webApp);
                            return null;
                        });
                        return null;
                    });
                }
                catch (Exception e) {
                    LOG.warn("Error applying context xml", (Throwable)e);
                    throw e;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldLoader);
                }
            }
            webApp.setContextPath(metadata.getContextPath());
            webApp.setAttribute("osgi-bundlecontext", (Object)metadata.getBundle().getBundleContext());
            webApp.setAttribute("o.e.j.o.b.watermark", (Object)"o.e.j.o.b.watermark");
            String[] targets = webApp.getProtectedTargets();
            String[] updatedTargets = null;
            if (targets != null) {
                updatedTargets = new String[targets.length + OSGiWebappConstants.DEFAULT_PROTECTED_OSGI_TARGETS.length];
                System.arraycopy(targets, 0, updatedTargets, 0, targets.length);
            } else {
                updatedTargets = new String[OSGiWebappConstants.DEFAULT_PROTECTED_OSGI_TARGETS.length];
            }
            System.arraycopy(OSGiWebappConstants.DEFAULT_PROTECTED_OSGI_TARGETS, 0, updatedTargets, targets.length, OSGiWebappConstants.DEFAULT_PROTECTED_OSGI_TARGETS.length);
            webApp.setProtectedTargets(updatedTargets);
            Resource bundleResource = Util.newBundleResource((Bundle)metadata.getBundle(), (ResourceFactory)resourceFactory);
            String pathToResourceBase = metadata.getPathToResourceBase();
            if (StringUtil.isBlank((String)pathToResourceBase) || ".".equals(pathToResourceBase)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Webapp base using bundle install location: {}", (Object)bundleResource);
                }
                webApp.setWarResource(bundleResource);
            } else if (pathToResourceBase.startsWith("/") || pathToResourceBase.startsWith("file:")) {
                Path p = Paths.get(pathToResourceBase, new String[0]);
                webApp.setWar(p.toUri().toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Webapp base using absolute location: {}", (Object)p);
                }
            } else {
                Resource r = bundleResource.resolve(pathToResourceBase);
                webApp.setWarResource(r);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Webapp base using path relative to bundle unpacked install location: {}", (Object)r);
                }
            }
            String tmp2 = (String)metadata.getAttributes().getAttribute("Jetty-WebXmlFilePath");
            if (!StringUtil.isBlank((String)tmp2) && (webXml = Util.resolvePathAsLocalizedURI((String)tmp2, (Bundle)metadata.getBundle(), (Path)jettyHomePath)) != null) {
                webApp.setDescriptor(webXml.toString());
            }
            if ((tmp2 = (String)metadata.getAttributes().getAttribute("Jetty-defaultWebXmlFilePath")) != null && (defaultWebXml = Util.resolvePathAsLocalizedURI((String)tmp2, (Bundle)metadata.getBundle(), (Path)jettyHomePath)) != null) {
                webApp.setDefaultsDescriptor(defaultWebXml.toString());
            }
            return webApp.getCoreContextHandler();
        }
    }

    public static class EE9ContextFactory
    implements ContextFactory {
        private Bundle _myBundle;

        public EE9ContextFactory(Bundle bundle) {
            this._myBundle = bundle;
        }

        public ContextHandler createContextHandler(AbstractContextProvider provider, BundleMetadata metadata) throws Exception {
            String jettyHome = (String)provider.getServer().getAttribute("jetty.home");
            Path jettyHomePath = StringUtil.isBlank((String)jettyHome) ? null : Paths.get(jettyHome, new String[0]);
            ContextHandler contextHandler = new ContextHandler();
            contextHandler.setAttribute("org.eclipse.jetty.osgi.bundle", (Object)metadata.getBundle());
            ResourceFactory resourceFactory = ResourceFactory.of((Container)contextHandler);
            contextHandler.setBaseResource(Util.newBundleResource((Bundle)metadata.getBundle(), (ResourceFactory)resourceFactory));
            ClassLoader coreLoader = (ClassLoader)provider.getServer().getAttribute("org.eclipse.jetty.osgi.server.classLoader");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Core classloader = {}", coreLoader.getClass());
            }
            OSGiClassLoader environmentLoader = new OSGiClassLoader(coreLoader, this._myBundle);
            OSGiClassLoader classLoader = new OSGiClassLoader((ClassLoader)environmentLoader, metadata.getBundle());
            contextHandler.setClassLoader((ClassLoader)classLoader);
            String tmp = (String)metadata.getAttributes().getAttribute("Jetty-ContextFilePath");
            URI contextXmlURI = Util.resolvePathAsLocalizedURI((String)tmp, (Bundle)metadata.getBundle(), (Path)jettyHomePath);
            if (contextXmlURI != null) {
                ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(contextHandler.getClassLoader());
                    WebAppClassLoader.runWithHiddenClassAccess(() -> {
                        Server server = provider.getServer();
                        XmlConfiguration xmlConfiguration = new XmlConfiguration(ResourceFactory.of((Container)contextHandler).newResource(contextXmlURI));
                        xmlConfiguration.setJettyStandardIdsAndProperties((Object)server, null);
                        WebAppClassLoader.runWithHiddenClassAccess(() -> {
                            HashMap<String, String> properties = new HashMap<String, String>();
                            properties.put("bundle.root", metadata.getPath().toUri().toString());
                            properties.put("jetty.home", (String)server.getAttribute("jetty.home"));
                            xmlConfiguration.getProperties().putAll(properties);
                            xmlConfiguration.configure((Object)contextHandler);
                            return null;
                        });
                        return null;
                    });
                }
                catch (Exception e) {
                    LOG.warn("Error applying context xml", (Throwable)e);
                    throw e;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldLoader);
                }
            }
            contextHandler.setAttribute("osgi-bundlecontext", (Object)metadata.getBundle().getBundleContext());
            String[] targets = contextHandler.getProtectedTargets();
            int length = targets == null ? 0 : targets.length;
            String[] updatedTargets = null;
            if (targets != null) {
                updatedTargets = new String[length + OSGiWebappConstants.DEFAULT_PROTECTED_OSGI_TARGETS.length];
                System.arraycopy(targets, 0, updatedTargets, 0, length);
            } else {
                updatedTargets = new String[OSGiWebappConstants.DEFAULT_PROTECTED_OSGI_TARGETS.length];
            }
            System.arraycopy(OSGiWebappConstants.DEFAULT_PROTECTED_OSGI_TARGETS, 0, updatedTargets, length, OSGiWebappConstants.DEFAULT_PROTECTED_OSGI_TARGETS.length);
            contextHandler.setProtectedTargets(updatedTargets);
            return contextHandler;
        }
    }
}

