/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.osgi.boot;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.jetty.ee8.webapp.WebAppClassLoader;
import org.eclipse.jetty.ee8.webapp.WebAppContext;
import org.eclipse.jetty.osgi.util.BundleClassLoaderHelperFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGiWebappClassLoader
extends WebAppClassLoader
implements BundleReference {
    private static final Logger LOG = LoggerFactory.getLogger((String)OSGiWebappClassLoader.class.getName());
    private ClassLoader _osgiBundleClassLoader;
    private Bundle _contributor;

    public OSGiWebappClassLoader(ClassLoader parent, WebAppContext context, Bundle contributor) throws IOException {
        super(parent, (WebAppClassLoader.Context)context);
        this._contributor = contributor;
        this._osgiBundleClassLoader = BundleClassLoaderHelperFactory.getFactory().getHelper().getBundleClassLoader(contributor);
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return this._osgiBundleClassLoader.loadClass(name);
        }
        catch (ClassNotFoundException cne) {
            try {
                return super.findClass(name);
            }
            catch (ClassNotFoundException cne2) {
                throw cne;
            }
        }
    }

    public Bundle getBundle() {
        return this._contributor;
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> osgiUrls = this._osgiBundleClassLoader.getResources(name);
        if (osgiUrls != null && osgiUrls.hasMoreElements()) {
            return osgiUrls;
        }
        Enumeration urls = super.getResources(name);
        return urls;
    }

    public URL getResource(String name) {
        URL url = this._osgiBundleClassLoader.getResource(name);
        return url != null ? url : super.getResource(name);
    }

    public URL findResource(String name) {
        URL url = this._osgiBundleClassLoader.getResource(name);
        return url != null ? url : super.findResource(name);
    }

    protected Class<?> loadAsResource(String name, boolean checkSystemResource) throws ClassNotFoundException {
        try {
            return this._osgiBundleClassLoader.loadClass(name);
        }
        catch (ClassNotFoundException cne) {
            try {
                return super.loadAsResource(name, checkSystemResource);
            }
            catch (ClassNotFoundException cne2) {
                throw cne;
            }
        }
    }
}

