/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.jar.Manifest;
import org.eclipse.jetty.util.ClassMatcher;
import org.eclipse.jetty.util.ClassVisibilityChecker;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollators;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject
public class WebAppClassLoader
extends URLClassLoader
implements ClassVisibilityChecker {
    private static final Logger LOG;
    private static final ThreadLocal<Boolean> __loadHiddenClasses;
    private final Context _context;
    private final ClassLoader _parent;
    private final Set<String> _extensions = new HashSet<String>();
    private String _name = String.valueOf(this.hashCode());
    private final List<ClassFileTransformer> _transformers = new CopyOnWriteArrayList<ClassFileTransformer>();
    private final ResourceFactory.Closeable _resourceFactory = ResourceFactory.closeable();

    public static <T> T runWithHiddenClassAccess(PrivilegedExceptionAction<T> action) throws Exception {
        Boolean lsc = __loadHiddenClasses.get();
        try {
            __loadHiddenClasses.set(true);
            T t = action.run();
            return t;
        }
        finally {
            if (lsc == null) {
                __loadHiddenClasses.remove();
            } else {
                __loadHiddenClasses.set(lsc);
            }
        }
    }

    public WebAppClassLoader(Context context) {
        this(null, context);
    }

    public WebAppClassLoader(ClassLoader parent, Context context) {
        super(new URL[]{}, parent != null ? parent : (Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : (WebAppClassLoader.class.getClassLoader() != null ? WebAppClassLoader.class.getClassLoader() : ClassLoader.getSystemClassLoader())));
        this._parent = this.getParent();
        this._context = context;
        if (this._parent == null) {
            throw new IllegalArgumentException("no parent classloader!");
        }
        this._extensions.add("jar");
        this._extensions.add("zip");
        String extensions = System.getProperty(WebAppClassLoader.class.getName() + ".extensions");
        if (extensions != null) {
            StringTokenizer tokenizer = new StringTokenizer(extensions, ",;");
            while (tokenizer.hasMoreTokens()) {
                this._extensions.add(tokenizer.nextToken().trim());
            }
        }
        for (Resource extra : context.getExtraClasspath()) {
            this.addClassPath(extra);
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Context getContext() {
        return this._context;
    }

    public void addClassPath(Resource resource) {
        for (Resource r : resource) {
            if (resource.exists()) {
                try {
                    this.addURL(r.getURI().toURL());
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("File not resolvable or incompatible with URLClassloader: " + String.valueOf(resource));
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Check resource exists and is not a nested jar: {}", (Object)resource);
            }
            throw new IllegalArgumentException("File not resolvable or incompatible with URLClassloader: " + String.valueOf(resource));
        }
    }

    public void addClassPath(String classPathList) throws IOException {
        if (classPathList == null) {
            return;
        }
        this._resourceFactory.split(classPathList).forEach(this::addClassPath);
    }

    private boolean isFileSupported(String file) {
        String ext = FileID.getExtension(file);
        return ext != null && this._extensions.contains(ext);
    }

    private boolean isFileSupported(Path path) {
        return this.isFileSupported(path.getFileName().toString());
    }

    public void addJars(Resource libs) {
        if (!Resources.isReadableDirectory(libs)) {
            return;
        }
        libs.list().stream().filter(r -> this.isFileSupported(r.getName())).sorted(ResourceCollators.byName(true)).forEach(this::addClassPath);
    }

    @Override
    public PermissionCollection getPermissions(CodeSource cs) {
        PermissionCollection permissions = this._context.getPermissions();
        return permissions == null ? super.getPermissions(cs) : permissions;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> resources;
        URL url;
        ArrayList<URL> fromParent = new ArrayList<URL>();
        ArrayList<URL> fromWebapp = new ArrayList<URL>();
        Enumeration<URL> urls = this._parent.getResources(name);
        while (urls != null && urls.hasMoreElements()) {
            url = urls.nextElement();
            if (!Boolean.TRUE.equals(__loadHiddenClasses.get()) && this._context.isHiddenResource(name, url)) continue;
            fromParent.add(url);
        }
        urls = this.findResources(name);
        while (urls != null && urls.hasMoreElements()) {
            url = urls.nextElement();
            if (this._context.isProtectedResource(name, url) && !fromParent.isEmpty()) continue;
            fromWebapp.add(url);
        }
        if (this._context.isParentLoaderPriority()) {
            fromParent.addAll(fromWebapp);
            resources = fromParent;
        } else {
            fromWebapp.addAll(fromParent);
            resources = fromWebapp;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getResources {} {}", (Object)name, (Object)resources);
        }
        return Collections.enumeration(resources);
    }

    @Override
    public URL getResource(String name) {
        URL resource = null;
        if (this._context.isParentLoaderPriority()) {
            URL parentUrl = this._parent.getResource(name);
            if (parentUrl != null && (Boolean.TRUE.equals(__loadHiddenClasses.get()) || !this._context.isHiddenResource(name, parentUrl))) {
                resource = parentUrl;
            } else {
                URL webappUrl = this.findResource(name);
                if (webappUrl != null) {
                    resource = webappUrl;
                }
            }
        } else {
            URL webappUrl = this.findResource(name);
            if (webappUrl != null && !this._context.isProtectedResource(name, webappUrl)) {
                resource = webappUrl;
            } else {
                URL parentUrl = this._parent.getResource(name);
                if (parentUrl != null && (Boolean.TRUE.equals(__loadHiddenClasses.get()) || !this._context.isHiddenResource(name, parentUrl))) {
                    resource = parentUrl;
                } else if (webappUrl != null) {
                    resource = webappUrl;
                }
            }
        }
        if (resource == null && name.startsWith("/")) {
            resource = this.getResource(name.substring(1));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getResource {} {}", (Object)name, (Object)resource);
        }
        return resource;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            ClassNotFoundException ex = null;
            Class<?> webappClass = this.findLoadedClass(name);
            if (webappClass != null) {
                return webappClass;
            }
            if (this._context.isParentLoaderPriority()) {
                try {
                    Class<?> parentClass = this._parent.loadClass(name);
                    if (parentClass == null) {
                        throw new ClassNotFoundException("Bad ClassLoader: returned null for loadClass(" + name + ")");
                    }
                    if (Boolean.TRUE.equals(__loadHiddenClasses.get()) || !this._context.isHiddenClass(parentClass)) {
                        return parentClass;
                    }
                }
                catch (ClassNotFoundException e) {
                    ex = e;
                }
                try {
                    webappClass = this.findClass(name);
                    if (resolve) {
                        this.resolveClass(webappClass);
                    }
                    return webappClass;
                }
                catch (ClassNotFoundException e) {
                    if (ex == null) {
                        ex = e;
                    } else if (e != ex) {
                        ex.addSuppressed(e);
                    }
                    throw ex;
                }
            }
            webappClass = this.loadAsResource(name, true);
            if (webappClass != null) {
                return webappClass;
            }
            try {
                Class<?> parentClass = this._parent.loadClass(name);
                if (Boolean.TRUE.equals(__loadHiddenClasses.get()) || !this._context.isHiddenClass(parentClass)) {
                    return parentClass;
                }
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
            webappClass = this.loadAsResource(name, false);
            if (webappClass != null) {
                return webappClass;
            }
            throw ex == null ? new ClassNotFoundException(name) : ex;
        }
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this._transformers.add(transformer);
    }

    public boolean removeTransformer(ClassFileTransformer transformer) {
        return this._transformers.remove(transformer);
    }

    protected Class<?> loadAsResource(String name, boolean checkSystemResource) throws ClassNotFoundException {
        Class<?> webappClass = null;
        String path = TypeUtil.toClassReference(name);
        URL webappUrl = this.findResource(path);
        if (!(webappUrl == null || checkSystemResource && this._context.isProtectedResource(name, webappUrl))) {
            webappClass = this.foundClass(name, webappUrl);
            this.resolveClass(webappClass);
            if (LOG.isDebugEnabled()) {
                LOG.debug("WAP webapp loaded {}", (Object)webappClass);
            }
        }
        return webappClass;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this._transformers.isEmpty()) {
            return super.findClass(name);
        }
        String path = TypeUtil.toClassReference(name);
        URL url = this.findResource(path);
        if (url == null) {
            throw new ClassNotFoundException(name);
        }
        return this.foundClass(name, url);
    }

    protected Class<?> foundClass(String name, URL url) throws ClassNotFoundException {
        if (this._transformers.isEmpty()) {
            return super.findClass(name);
        }
        InputStream content = null;
        try {
            content = url.openStream();
            byte[] bytes = IO.readBytes(content);
            for (ClassFileTransformer transformer : this._transformers) {
                byte[] tmp = transformer.transform(this, name, null, null, bytes);
                if (tmp == null) continue;
                bytes = tmp;
            }
            this.definePackageIfNecessary(name, url);
            Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
            return clazz;
        }
        catch (IOException | IllegalClassFormatException e) {
            throw new ClassNotFoundException(name, e);
        }
        finally {
            IO.close(content);
        }
    }

    private void definePackageIfNecessary(String className, URL url) throws IOException {
        int lastDotIndex = className.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return;
        }
        String packageName = className.substring(0, lastDotIndex);
        if (this.getDefinedPackage(packageName) == null) {
            try {
                String externalForm = url.toExternalForm();
                if (externalForm.startsWith("jar:file:") && externalForm.contains("!/")) {
                    URI jarURI = URIUtil.unwrapContainer(new URI(externalForm));
                    Resource manifestResource = this.getContext().newResource(URIUtil.uriJarPrefix(jarURI, "!/META-INF/MANIFEST.MF").toASCIIString());
                    if (manifestResource.exists()) {
                        try (InputStream is = manifestResource.newInputStream();){
                            Manifest manifest = new Manifest(is);
                            this.definePackage(packageName, manifest, jarURI.toURL());
                            return;
                        }
                    }
                }
            }
            catch (Throwable t) {
                LOG.trace("could not read manifest of {}", (Object)url, (Object)t);
            }
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        IO.close(this._resourceFactory);
    }

    public String toString() {
        return String.format("%s{%s}@%x", this.getClass().getSimpleName(), this._name, this.hashCode());
    }

    @Override
    public boolean isProtectedClass(Class<?> clazz) {
        return this._context.isProtectedClass(clazz);
    }

    @Override
    public boolean isHiddenClass(Class<?> clazz) {
        return this._context.isHiddenClass(clazz);
    }

    static {
        WebAppClassLoader.registerAsParallelCapable();
        LOG = LoggerFactory.getLogger(WebAppClassLoader.class);
        __loadHiddenClasses = new ThreadLocal();
    }

    public static interface Context
    extends ClassVisibilityChecker {
        public Resource newResource(String var1) throws IOException;

        public boolean isParentLoaderPriority();

        public List<Resource> getExtraClasspath();

        public ClassMatcher getHiddenClassMatcher();

        @Override
        default public boolean isHiddenClass(Class<?> clazz) {
            return this.getHiddenClassMatcher().match(clazz);
        }

        default public boolean isHiddenResource(String name, URL url) {
            return this.getHiddenClassMatcher().match(name, url);
        }

        @ManagedAttribute(value="classes and packages hidden by the context classloader", readonly=true)
        default public String[] getHiddenClasses() {
            return this.getHiddenClassMatcher().getPatterns();
        }

        public ClassMatcher getProtectedClassMatcher();

        @Override
        default public boolean isProtectedClass(Class<?> clazz) {
            return this.getProtectedClassMatcher().match(clazz);
        }

        default public boolean isProtectedResource(String name, URL url) {
            return this.getProtectedClassMatcher().match(name, url);
        }

        @ManagedAttribute(value="classes and packages protected by context classloader", readonly=true)
        default public String[] getProtectedClasses() {
            return this.getProtectedClassMatcher().getPatterns();
        }

        default public PermissionCollection getPermissions() {
            return null;
        }
    }
}

