/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.plus.webapp;

import java.util.Iterator;
import java.util.Objects;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.eclipse.jetty.ee8.servlet.ServletContextHandler;
import org.eclipse.jetty.ee8.webapp.Descriptor;
import org.eclipse.jetty.ee8.webapp.FragmentDescriptor;
import org.eclipse.jetty.ee8.webapp.IterativeDescriptorProcessor;
import org.eclipse.jetty.ee8.webapp.Origin;
import org.eclipse.jetty.ee8.webapp.WebAppContext;
import org.eclipse.jetty.plus.annotation.Injection;
import org.eclipse.jetty.plus.annotation.InjectionCollection;
import org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.eclipse.jetty.plus.annotation.PostConstructCallback;
import org.eclipse.jetty.plus.annotation.PreDestroyCallback;
import org.eclipse.jetty.plus.jndi.EnvEntry;
import org.eclipse.jetty.plus.jndi.Link;
import org.eclipse.jetty.plus.jndi.NamingEntry;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.jndi.NamingUtil;
import org.eclipse.jetty.xml.XmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlusDescriptorProcessor
extends IterativeDescriptorProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(PlusDescriptorProcessor.class);

    public PlusDescriptorProcessor() {
        try {
            this.registerVisitor("env-entry", this.getClass().getMethod("visitEnvEntry", __signature));
            this.registerVisitor("resource-ref", this.getClass().getMethod("visitResourceRef", __signature));
            this.registerVisitor("resource-env-ref", this.getClass().getMethod("visitResourceEnvRef", __signature));
            this.registerVisitor("message-destination-ref", this.getClass().getMethod("visitMessageDestinationRef", __signature));
            this.registerVisitor("post-construct", this.getClass().getMethod("visitPostConstruct", __signature));
            this.registerVisitor("pre-destroy", this.getClass().getMethod("visitPreDestroy", __signature));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void start(WebAppContext context, Descriptor descriptor) {
        LifeCycleCallbackCollection callbacks;
        InjectionCollection injections = (InjectionCollection)context.getAttribute("org.eclipse.jetty.injectionCollection");
        if (injections == null) {
            injections = new InjectionCollection();
            context.setAttribute("org.eclipse.jetty.injectionCollection", injections);
        }
        if ((callbacks = (LifeCycleCallbackCollection)context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")) == null) {
            callbacks = new LifeCycleCallbackCollection();
            context.setAttribute("org.eclipse.jetty.lifecyleCallbackCollection", callbacks);
        }
    }

    @Override
    public void end(WebAppContext context, Descriptor descriptor) {
    }

    public void visitEnvEntry(WebAppContext context, Descriptor descriptor, XmlParser.Node node) throws Exception {
        String name = node.getString("env-entry-name", false, true);
        String type = node.getString("env-entry-type", false, true);
        String valueStr = node.getString("env-entry-value", false, true);
        Origin o = context.getMetaData().getOrigin("env-entry." + name);
        switch (o) {
            case NotSet: {
                context.getMetaData().setOrigin("env-entry." + name, descriptor);
                this.makeEnvEntryInjectionsAndBindings(context, descriptor, node, name, type, valueStr);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (!(descriptor instanceof FragmentDescriptor)) {
                    context.getMetaData().setOrigin("env-entry." + name, descriptor);
                    this.makeEnvEntryInjectionsAndBindings(context, descriptor, node, name, type, valueStr);
                    break;
                }
                Descriptor d = context.getMetaData().getOriginDescriptor("env-entry." + name + ".injection");
                if (d != null && !(d instanceof FragmentDescriptor)) break;
                this.addInjections(context, descriptor, node, name, TypeUtil.fromName(type));
                break;
            }
            case WebFragment: {
                throw new IllegalStateException("Conflicting env-entry " + name + " in " + descriptor.getURI());
            }
        }
    }

    public void visitResourceRef(WebAppContext context, Descriptor descriptor, XmlParser.Node node) throws Exception {
        String jndiName = node.getString("res-ref-name", false, true);
        String type = node.getString("res-type", false, true);
        String auth = node.getString("res-auth", false, true);
        String shared = node.getString("res-sharing-scope", false, true);
        Origin o = context.getMetaData().getOrigin("resource-ref." + jndiName);
        switch (o) {
            case NotSet: {
                context.getMetaData().setOrigin("resource-ref." + jndiName, descriptor);
                Class<?> typeClass = TypeUtil.fromName(type);
                if (typeClass == null) {
                    typeClass = context.loadClass(type);
                }
                this.addInjections(context, descriptor, node, jndiName, typeClass);
                this.bindResourceRef(context, jndiName, typeClass);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (!(descriptor instanceof FragmentDescriptor)) {
                    context.getMetaData().setOrigin("resource-ref." + jndiName, descriptor);
                    Class<?> typeClass = TypeUtil.fromName(type);
                    if (typeClass == null) {
                        typeClass = context.loadClass(type);
                    }
                    this.addInjections(context, descriptor, node, jndiName, typeClass);
                    this.bindResourceRef(context, jndiName, typeClass);
                    break;
                }
                Descriptor d = context.getMetaData().getOriginDescriptor("resource-ref." + jndiName + ".injection");
                if (d != null && !(d instanceof FragmentDescriptor)) break;
                Class<?> typeClass = TypeUtil.fromName(type);
                if (typeClass == null) {
                    typeClass = context.loadClass(type);
                }
                this.addInjections(context, descriptor, node, jndiName, TypeUtil.fromName(type));
                break;
            }
            case WebFragment: {
                Descriptor otherFragment = context.getMetaData().getOriginDescriptor("resource-ref." + jndiName);
                XmlParser.Node otherFragmentRoot = otherFragment.getRoot();
                Iterator iter = otherFragmentRoot.iterator();
                XmlParser.Node otherNode = null;
                while (iter.hasNext() && otherNode == null) {
                    XmlParser.Node n;
                    Object obj = iter.next();
                    if (!(obj instanceof XmlParser.Node) || !"resource-ref".equals((n = (XmlParser.Node)obj).getTag()) || !jndiName.equals(n.getString("res-ref-name", false, true))) continue;
                    otherNode = n;
                }
                if (otherNode != null) {
                    String otherType = otherNode.getString("res-type", false, true);
                    otherType = otherType == null ? "" : otherType;
                    String otherAuth = otherNode.getString("res-auth", false, true);
                    otherAuth = otherAuth == null ? "" : otherAuth;
                    String otherShared = otherNode.getString("res-sharing-scope", false, true);
                    otherShared = otherShared == null ? "" : otherShared;
                    type = type == null ? "" : type;
                    auth = auth == null ? "" : auth;
                    String string = shared = shared == null ? "" : shared;
                    if (!(type.equals(otherType) && auth.equals(otherAuth) && shared.equals(otherShared))) {
                        throw new IllegalStateException("Conflicting resource-ref " + jndiName + " in " + descriptor.getURI());
                    }
                    this.addInjections(context, descriptor, node, jndiName, TypeUtil.fromName(type));
                    break;
                }
                throw new IllegalStateException("resource-ref." + jndiName + " not found in declaring descriptor " + String.valueOf(otherFragment));
            }
        }
    }

    public void visitResourceEnvRef(WebAppContext context, Descriptor descriptor, XmlParser.Node node) throws Exception {
        String jndiName = node.getString("resource-env-ref-name", false, true);
        String type = node.getString("resource-env-ref-type", false, true);
        Origin o = context.getMetaData().getOrigin("resource-env-ref." + jndiName);
        switch (o) {
            case NotSet: {
                Class<?> typeClass = TypeUtil.fromName(type);
                if (typeClass == null) {
                    typeClass = context.loadClass(type);
                }
                this.addInjections(context, descriptor, node, jndiName, typeClass);
                this.bindResourceEnvRef(context, jndiName, typeClass);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (!(descriptor instanceof FragmentDescriptor)) {
                    context.getMetaData().setOrigin("resource-env-ref." + jndiName, descriptor);
                    Class<?> typeClass = TypeUtil.fromName(type);
                    if (typeClass == null) {
                        typeClass = context.loadClass(type);
                    }
                    this.addInjections(context, descriptor, node, jndiName, typeClass);
                    this.bindResourceEnvRef(context, jndiName, typeClass);
                    break;
                }
                Descriptor d = context.getMetaData().getOriginDescriptor("resource-env-ref." + jndiName + ".injection");
                if (d != null && !(d instanceof FragmentDescriptor)) break;
                Class<?> typeClass = TypeUtil.fromName(type);
                if (typeClass == null) {
                    typeClass = context.loadClass(type);
                }
                this.addInjections(context, descriptor, node, jndiName, typeClass);
                break;
            }
            case WebFragment: {
                Descriptor otherFragment = context.getMetaData().getOriginDescriptor("resource-env-ref." + jndiName);
                XmlParser.Node otherFragmentRoot = otherFragment.getRoot();
                Iterator iter = otherFragmentRoot.iterator();
                XmlParser.Node otherNode = null;
                while (iter.hasNext() && otherNode == null) {
                    XmlParser.Node n;
                    Object obj = iter.next();
                    if (!(obj instanceof XmlParser.Node) || !"resource-env-ref".equals((n = (XmlParser.Node)obj).getTag()) || !jndiName.equals(n.getString("resource-env-ref-name", false, true))) continue;
                    otherNode = n;
                }
                if (otherNode != null) {
                    String otherType = otherNode.getString("resource-env-ref-type", false, true);
                    type = type == null ? "" : type;
                    String string = otherType = otherType == null ? "" : otherType;
                    if (!type.equals(otherType)) {
                        throw new IllegalStateException("Conflicting resource-env-ref " + jndiName + " in " + descriptor.getURI());
                    }
                    this.addInjections(context, descriptor, node, jndiName, TypeUtil.fromName(type));
                    break;
                }
                throw new IllegalStateException("resource-env-ref." + jndiName + " not found in declaring descriptor " + String.valueOf(otherFragment));
            }
        }
    }

    public void visitMessageDestinationRef(WebAppContext context, Descriptor descriptor, XmlParser.Node node) throws Exception {
        String jndiName = node.getString("message-destination-ref-name", false, true);
        String type = node.getString("message-destination-type", false, true);
        String usage = node.getString("message-destination-usage", false, true);
        Origin o = context.getMetaData().getOrigin("message-destination-ref." + jndiName);
        switch (o) {
            case NotSet: {
                Class<?> typeClass = TypeUtil.fromName(type);
                if (typeClass == null) {
                    typeClass = context.loadClass(type);
                }
                this.addInjections(context, descriptor, node, jndiName, typeClass);
                this.bindMessageDestinationRef(context, jndiName, typeClass);
                context.getMetaData().setOrigin("message-destination-ref." + jndiName, descriptor);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (!(descriptor instanceof FragmentDescriptor)) {
                    Class<?> typeClass = TypeUtil.fromName(type);
                    if (typeClass == null) {
                        typeClass = context.loadClass(type);
                    }
                    this.addInjections(context, descriptor, node, jndiName, typeClass);
                    this.bindMessageDestinationRef(context, jndiName, typeClass);
                    context.getMetaData().setOrigin("message-destination-ref." + jndiName, descriptor);
                    break;
                }
                Descriptor d = context.getMetaData().getOriginDescriptor("message-destination-ref." + jndiName + ".injection");
                if (d != null && !(d instanceof FragmentDescriptor)) break;
                Class<?> typeClass = TypeUtil.fromName(type);
                if (typeClass == null) {
                    typeClass = context.loadClass(type);
                }
                this.addInjections(context, descriptor, node, jndiName, typeClass);
                break;
            }
            case WebFragment: {
                Descriptor otherFragment = context.getMetaData().getOriginDescriptor("message-destination-ref." + jndiName);
                XmlParser.Node otherFragmentRoot = otherFragment.getRoot();
                Iterator iter = otherFragmentRoot.iterator();
                XmlParser.Node otherNode = null;
                while (iter.hasNext() && otherNode == null) {
                    XmlParser.Node n;
                    Object obj = iter.next();
                    if (!(obj instanceof XmlParser.Node) || !"message-destination-ref".equals((n = (XmlParser.Node)obj).getTag()) || !jndiName.equals(n.getString("message-destination-ref-name", false, true))) continue;
                    otherNode = n;
                }
                if (otherNode != null) {
                    String otherType = node.getString("message-destination-type", false, true);
                    String otherUsage = node.getString("message-destination-usage", false, true);
                    type = type == null ? "" : type;
                    String string = usage = usage == null ? "" : usage;
                    if (!type.equals(otherType) || !usage.equalsIgnoreCase(otherUsage)) {
                        throw new IllegalStateException("Conflicting message-destination-ref " + jndiName + " in " + descriptor.getURI());
                    }
                    this.addInjections(context, descriptor, node, jndiName, TypeUtil.fromName(type));
                    break;
                }
                throw new IllegalStateException("message-destination-ref." + jndiName + " not found in declaring descriptor " + String.valueOf(otherFragment));
            }
        }
    }

    public void visitPostConstruct(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String className = node.getString("lifecycle-callback-class", false, true);
        String methodName = node.getString("lifecycle-callback-method", false, true);
        if (className == null || className.isEmpty()) {
            LOG.warn("No lifecycle-callback-class specified");
            return;
        }
        if (methodName == null || methodName.isEmpty()) {
            LOG.warn("No lifecycle-callback-method specified for class {}", (Object)className);
            return;
        }
        Origin o = context.getMetaData().getOrigin("post-construct");
        switch (o) {
            case NotSet: {
                context.getMetaData().setOrigin("post-construct", descriptor);
                PostConstructCallback callback = new PostConstructCallback(className, methodName);
                ((LifeCycleCallbackCollection)context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")).add(callback);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (descriptor instanceof FragmentDescriptor) break;
                try {
                    Class<?> clazz = context.loadClass(className);
                    PostConstructCallback callback = new PostConstructCallback(clazz, methodName);
                    ((LifeCycleCallbackCollection)context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")).add(callback);
                }
                catch (ClassNotFoundException e) {
                    LOG.warn("Couldn't load post-construct target class {}", (Object)className);
                }
                break;
            }
            case WebFragment: {
                try {
                    Class<?> clazz = context.loadClass(className);
                    PostConstructCallback callback = new PostConstructCallback(clazz, methodName);
                    ((LifeCycleCallbackCollection)context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")).add(callback);
                }
                catch (ClassNotFoundException e) {
                    LOG.warn("Couldn't load post-construct target class {}", (Object)className);
                }
                break;
            }
        }
    }

    public void visitPreDestroy(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String className = node.getString("lifecycle-callback-class", false, true);
        String methodName = node.getString("lifecycle-callback-method", false, true);
        if (className == null || className.isEmpty()) {
            LOG.warn("No lifecycle-callback-class specified for pre-destroy");
            return;
        }
        if (methodName == null || methodName.isEmpty()) {
            LOG.warn("No lifecycle-callback-method specified for pre-destroy class {}", (Object)className);
            return;
        }
        Origin o = context.getMetaData().getOrigin("pre-destroy");
        switch (o) {
            case NotSet: {
                context.getMetaData().setOrigin("pre-destroy", descriptor);
                PreDestroyCallback callback = new PreDestroyCallback(className, methodName);
                ((LifeCycleCallbackCollection)context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")).add(callback);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (descriptor instanceof FragmentDescriptor) break;
                try {
                    Class<?> clazz = context.loadClass(className);
                    PreDestroyCallback callback = new PreDestroyCallback(clazz, methodName);
                    ((LifeCycleCallbackCollection)context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")).add(callback);
                }
                catch (ClassNotFoundException e) {
                    LOG.warn("Couldn't load pre-destroy target class {}", (Object)className);
                }
                break;
            }
            case WebFragment: {
                try {
                    Class<?> clazz = context.loadClass(className);
                    PreDestroyCallback callback = new PreDestroyCallback(clazz, methodName);
                    ((LifeCycleCallbackCollection)context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")).add(callback);
                }
                catch (ClassNotFoundException e) {
                    LOG.warn("Couldn't load pre-destroy target class {}", (Object)className);
                }
                break;
            }
        }
    }

    public void addInjections(WebAppContext context, Descriptor descriptor, XmlParser.Node node, String jndiName, Class<?> valueClass) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(node);
        Iterator<XmlParser.Node> itor = node.iterator("injection-target");
        while (itor.hasNext()) {
            XmlParser.Node injectionNode = itor.next();
            String targetClassName = injectionNode.getString("injection-target-class", false, true);
            String targetName = injectionNode.getString("injection-target-name", false, true);
            if (targetClassName == null || targetClassName.isEmpty()) {
                LOG.warn("No classname found in injection-target");
                continue;
            }
            if (targetName == null || targetName.isEmpty()) {
                LOG.warn("No field or method name in injection-target");
                continue;
            }
            InjectionCollection injections = (InjectionCollection)context.getAttribute("org.eclipse.jetty.injectionCollection");
            if (injections == null) {
                injections = new InjectionCollection();
                context.setAttribute("org.eclipse.jetty.injectionCollection", injections);
            }
            try {
                Class<?> clazz = context.loadClass(targetClassName);
                Injection injection = new Injection(clazz, targetName, valueClass, jndiName, null);
                injections.add(injection);
                String name = node.getTag() + "." + jndiName + ".injection";
                if (context.getMetaData().getOriginDescriptor(name) != null) continue;
                context.getMetaData().setOrigin(name, descriptor);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Couldn't load injection target class {}", (Object)targetClassName);
            }
        }
    }

    public void bindEnvEntry(String name, Object value) throws Exception {
        InitialContext ic = new InitialContext();
        Context envCtx = (Context)ic.lookup("java:comp/env");
        NamingUtil.bind(envCtx, name, value);
    }

    public void makeEnvEntryInjectionsAndBindings(WebAppContext context, Descriptor descriptor, XmlParser.Node node, String name, String type, String value) throws Exception {
        InitialContext ic = new InitialContext();
        try {
            EnvEntry envEntry = (EnvEntry)ic.lookup("java:comp/env/" + String.valueOf(NamingEntryUtil.makeNamingEntryName(ic.getNameParser(""), name)));
            if (StringUtil.isEmpty(value)) {
                if (envEntry != null && envEntry.isOverrideWebXml()) {
                    this.addInjections(context, descriptor, node, name, TypeUtil.fromName(type));
                }
            } else {
                this.addInjections(context, descriptor, node, name, TypeUtil.fromName(type));
                if (envEntry == null || !envEntry.isOverrideWebXml()) {
                    this.bindEnvEntry(name, TypeUtil.valueOf(type, value));
                }
            }
        }
        catch (NameNotFoundException e) {
            this.addInjections(context, descriptor, node, name, TypeUtil.fromName(type));
            this.bindEnvEntry(name, TypeUtil.valueOf(type, value));
        }
    }

    public void bindResourceRef(WebAppContext context, String name, Class<?> typeClass) throws Exception {
        this.bindEntry(context, name, typeClass);
    }

    public void bindResourceEnvRef(WebAppContext context, String name, Class<?> typeClass) throws Exception {
        this.bindEntry(context, name, typeClass);
    }

    public void bindMessageDestinationRef(WebAppContext context, String name, Class<?> typeClass) throws Exception {
        this.bindEntry(context, name, typeClass);
    }

    protected void bindEntry(WebAppContext context, String name, Class<?> typeClass) throws Exception {
        Object nameInEnvironment = name;
        boolean bound = false;
        Object scope = context;
        NamingEntry ne = NamingEntryUtil.lookupNamingEntry(scope, name);
        if (ne instanceof Link) {
            nameInEnvironment = ((Link)ne).getLink();
        }
        if (bound = NamingEntryUtil.bindToENC(scope, name, (String)nameInEnvironment)) {
            return;
        }
        scope = ServletContextHandler.ENVIRONMENT.getName();
        bound = NamingEntryUtil.bindToENC(scope, name, (String)nameInEnvironment);
        if (bound) {
            return;
        }
        scope = context.getServer();
        bound = NamingEntryUtil.bindToENC(scope, name, (String)nameInEnvironment);
        if (bound) {
            return;
        }
        bound = NamingEntryUtil.bindToENC(null, name, (String)nameInEnvironment);
        if (bound) {
            return;
        }
        nameInEnvironment = typeClass.getName() + "/default";
        NamingEntry defaultNE = NamingEntryUtil.lookupNamingEntry(context.getServer(), (String)nameInEnvironment);
        if (defaultNE == null) {
            defaultNE = NamingEntryUtil.lookupNamingEntry(null, (String)nameInEnvironment);
        }
        if (defaultNE == null) {
            throw new IllegalStateException("Nothing to bind for name " + name);
        }
        defaultNE.bindToENC(name);
    }
}

