/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.maven.plugin;

import java.nio.file.Path;
import org.eclipse.jetty.ee10.maven.plugin.MavenQuickStartConfiguration;
import org.eclipse.jetty.ee10.maven.plugin.MavenWebAppContext;
import org.eclipse.jetty.ee10.maven.plugin.WebAppPropertyConverter;
import org.eclipse.jetty.ee10.quickstart.QuickStartConfiguration;
import org.eclipse.jetty.ee10.webapp.Configuration;
import org.eclipse.jetty.ee10.webapp.Configurations;
import org.eclipse.jetty.maven.ServerSupport;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class QuickStartGenerator {
    private final Path quickstartXml;
    private final MavenWebAppContext webApp;
    private Path webAppProps;
    private String contextXml;
    private boolean prepared = false;
    private Server server;
    private QueuedThreadPool tpool;

    public QuickStartGenerator(Path quickstartXml, MavenWebAppContext webApp) {
        this.quickstartXml = quickstartXml;
        this.webApp = webApp == null ? new MavenWebAppContext() : webApp;
    }

    public MavenWebAppContext getWebApp() {
        return this.webApp;
    }

    public Path getQuickstartXml() {
        return this.quickstartXml;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public Path getWebAppProps() {
        return this.webAppProps;
    }

    public void setWebAppProps(Path webAppProps) {
        this.webAppProps = webAppProps;
    }

    public String getContextXml() {
        return this.contextXml;
    }

    public void setContextXml(String contextXml) {
        this.contextXml = contextXml;
    }

    private void prepareWebApp() {
        this.webApp.addConfiguration(new Configuration[]{new MavenQuickStartConfiguration()});
        this.webApp.setAttribute("org.eclipse.jetty.quickstart.mode", QuickStartConfiguration.Mode.GENERATE);
        this.webApp.setAttribute("org.eclipse.jetty.quickstart.xml", this.quickstartXml);
        this.webApp.setAttribute("org.eclipse.jetty.quickstart.origin", "o");
        this.webApp.setCopyWebDir(false);
        this.webApp.setCopyWebInf(false);
    }

    public void generate() throws Exception {
        if (this.quickstartXml == null) {
            throw new IllegalStateException("No quickstart xml output file");
        }
        if (!this.prepared) {
            this.prepared = true;
            this.prepareWebApp();
            if (this.server == null) {
                this.server = new Server();
            }
            ServerSupport.configureHandlers((Server)this.server, null, null);
            Configurations.setServerDefault((Server)this.server);
            if (this.tpool == null) {
                this.tpool = (QueuedThreadPool)this.server.getBean(QueuedThreadPool.class);
            }
            ServerSupport.addWebApplication((Server)this.server, (ContextHandler)this.webApp);
            this.webApp.setTempDirectoryPersistent(true);
        }
        try {
            if (this.tpool != null) {
                this.tpool.start();
            } else {
                this.webApp.setAttribute("org.eclipse.jetty.annotations.multiThreaded", Boolean.FALSE.toString());
            }
            this.webApp.start();
            if (this.webAppProps != null) {
                WebAppPropertyConverter.toProperties(this.webApp, this.webAppProps.toFile(), this.contextXml);
            }
        }
        finally {
            this.webApp.stop();
            if (this.tpool != null) {
                this.tpool.stop();
            }
        }
    }
}

