/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.zstandard;

import com.github.luben.zstd.ZstdInputStreamNoFinalizer;
import com.github.luben.zstd.ZstdOutputStreamNoFinalizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Objects;
import org.eclipse.jetty.compression.Compression;
import org.eclipse.jetty.compression.DecoderConfig;
import org.eclipse.jetty.compression.DecoderSource;
import org.eclipse.jetty.compression.EncoderConfig;
import org.eclipse.jetty.compression.EncoderSink;
import org.eclipse.jetty.compression.zstandard.ZstandardDecoderConfig;
import org.eclipse.jetty.compression.zstandard.ZstandardDecoderSource;
import org.eclipse.jetty.compression.zstandard.ZstandardEncoderConfig;
import org.eclipse.jetty.compression.zstandard.ZstandardEncoderSink;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZstandardCompression
extends Compression {
    private static final Logger LOG = LoggerFactory.getLogger(ZstandardCompression.class);
    private static final String ENCODING_NAME = "zstd";
    private static final HttpField X_CONTENT_ENCODING = new PreEncodedHttpField("X-Content-Encoding", "zstd");
    private static final HttpField CONTENT_ENCODING = new PreEncodedHttpField(HttpHeader.CONTENT_ENCODING, "zstd");
    private static final int DEFAULT_MIN_ZSTD_SIZE = 48;
    private static final List<String> EXTENSIONS = List.of("zst");
    private int minCompressSize = 48;
    private ZstandardEncoderConfig defaultEncoderConfig = new ZstandardEncoderConfig();
    private ZstandardDecoderConfig defaultDecoderConfig = new ZstandardDecoderConfig();

    public ZstandardCompression() {
        super(ENCODING_NAME);
    }

    public RetainableByteBuffer acquireByteBuffer() {
        return this.acquireByteBuffer(this.getBufferSize());
    }

    public RetainableByteBuffer acquireByteBuffer(int length) {
        if (length == 0) {
            return RetainableByteBuffer.EMPTY;
        }
        RetainableByteBuffer.Mutable buffer = this.getByteBufferPool().acquire(length, true);
        if (!buffer.getByteBuffer().isDirect()) {
            buffer.release();
            throw new IllegalStateException("ByteBufferPool does not return zstd-jni required direct ByteBuffer");
        }
        buffer.getByteBuffer().order(this.getByteOrder());
        return buffer;
    }

    public HttpField getContentEncodingField() {
        return CONTENT_ENCODING;
    }

    public DecoderConfig getDefaultDecoderConfig() {
        return this.defaultDecoderConfig;
    }

    public void setDefaultDecoderConfig(DecoderConfig config) {
        ZstandardDecoderConfig zstandardDecoderConfig = (ZstandardDecoderConfig)ZstandardDecoderConfig.class.cast(config);
        this.defaultDecoderConfig = Objects.requireNonNull(zstandardDecoderConfig);
    }

    public EncoderConfig getDefaultEncoderConfig() {
        return this.defaultEncoderConfig;
    }

    public void setDefaultEncoderConfig(EncoderConfig config) {
        ZstandardEncoderConfig zstandardEncoderConfig = (ZstandardEncoderConfig)ZstandardEncoderConfig.class.cast(config);
        this.defaultEncoderConfig = Objects.requireNonNull(zstandardEncoderConfig);
    }

    public List<String> getFileExtensionNames() {
        return EXTENSIONS;
    }

    public int getMinCompressSize() {
        return this.minCompressSize;
    }

    public void setMinCompressSize(int minCompressSize) {
        this.minCompressSize = Math.max(minCompressSize, 48);
    }

    public String getName() {
        return "zstandard";
    }

    public HttpField getXContentEncodingField() {
        return X_CONTENT_ENCODING;
    }

    public InputStream newDecoderInputStream(InputStream in, DecoderConfig config) throws IOException {
        ZstandardDecoderConfig zstandardDecoderConfig = (ZstandardDecoderConfig)ZstandardDecoderConfig.class.cast(config);
        ZstdInputStreamNoFinalizer inputStream = new ZstdInputStreamNoFinalizer(in);
        config.setBufferSize(zstandardDecoderConfig.getBufferSize());
        return inputStream;
    }

    public DecoderSource newDecoderSource(Content.Source source, DecoderConfig config) {
        ZstandardDecoderConfig zstandardDecoderConfig = (ZstandardDecoderConfig)ZstandardDecoderConfig.class.cast(config);
        return new ZstandardDecoderSource(this, source, zstandardDecoderConfig);
    }

    public OutputStream newEncoderOutputStream(OutputStream out, EncoderConfig config) throws IOException {
        ZstandardEncoderConfig zstandardEncoderConfig = (ZstandardEncoderConfig)ZstandardEncoderConfig.class.cast(config);
        ZstdOutputStreamNoFinalizer outputStream = new ZstdOutputStreamNoFinalizer(out, zstandardEncoderConfig.getCompressionLevel());
        if (zstandardEncoderConfig.getStrategy() >= 0) {
            outputStream.setStrategy(zstandardEncoderConfig.getStrategy());
        }
        return outputStream;
    }

    public EncoderSink newEncoderSink(Content.Sink sink, EncoderConfig config) {
        ZstandardEncoderConfig zstandardEncoderConfig = (ZstandardEncoderConfig)ZstandardEncoderConfig.class.cast(config);
        return new ZstandardEncoderSink(this, sink, zstandardEncoderConfig);
    }

    private ByteOrder getByteOrder() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

