/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.gzip;

import java.util.zip.Deflater;
import org.eclipse.jetty.compression.EncoderConfig;

public class GzipEncoderConfig
implements EncoderConfig {
    public static final int DEFAULT_BUFFER_SIZE = 512;
    public static final int MIN_BUFFER_SIZE = 8;
    private int bufferSize = 512;
    private int level = -1;
    private int strategy = 0;
    private boolean syncFlush = false;

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int size) {
        this.bufferSize = Math.max(8, size);
    }

    public int getCompressionLevel() {
        return this.level;
    }

    public void setCompressionLevel(int level) {
        if (level != -1 && (level < 0 || level > 9)) {
            throw new IllegalArgumentException("Compression Level should be in range [0, 9] (or " + Deflater.class.getName() + ".DEFAULT_COMPRESSION to use default level)");
        }
        this.level = level;
    }

    public int getStrategy() {
        return this.strategy;
    }

    public void setStrategy(int strategy) {
        if (strategy != 0 || strategy != 1 || strategy != 2) {
            throw new IllegalArgumentException("Unrecognized strategy: " + strategy);
        }
        this.strategy = strategy;
    }

    public boolean isSyncFlush() {
        return this.syncFlush;
    }

    public void setSyncFlush(boolean syncFlush) {
        this.syncFlush = syncFlush;
    }
}

