/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.gzip;

import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.eclipse.jetty.compression.DecoderSource;
import org.eclipse.jetty.compression.gzip.GzipCompression;
import org.eclipse.jetty.compression.gzip.GzipDecoderConfig;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.compression.CompressionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GzipDecoderSource
extends DecoderSource {
    private static final Logger LOG = LoggerFactory.getLogger(GzipDecoderSource.class);
    private static final long UINT_MAX = 0xFFFFFFFFL;
    private static final ByteBuffer EMPTY_BUFFER = BufferUtil.EMPTY_BUFFER;
    private final GzipCompression compression;
    private final int bufferSize;
    private CompressionPool.Entry inflaterEntry;
    private Inflater inflater;
    private State state;
    private int size;
    private long value;
    private byte flags;

    public GzipDecoderSource(GzipCompression compression, Content.Source source, GzipDecoderConfig config) {
        super(source);
        this.compression = compression;
        this.inflaterEntry = compression.getInflaterPool().acquire();
        this.inflater = (Inflater)this.inflaterEntry.get();
        this.inflater.reset();
        this.bufferSize = config.getBufferSize();
        this.state = State.INITIAL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Content.Chunk nextChunk(Content.Chunk readChunk) {
        Content.Chunk chunk;
        ByteBuffer compressed = readChunk.getByteBuffer();
        try {
            block25: while (compressed.hasRemaining()) {
                switch (this.state.ordinal()) {
                    case 0: {
                        this.inflater.reset();
                        this.state = State.ID;
                        break;
                    }
                    case 7: {
                        if ((this.flags & 4) == 4) {
                            this.state = State.EXTRA_LENGTH;
                            this.size = 0;
                            this.value = 0L;
                            break;
                        }
                        if ((this.flags & 8) == 8) {
                            this.state = State.NAME;
                            break;
                        }
                        if ((this.flags & 0x10) == 16) {
                            this.state = State.COMMENT;
                            break;
                        }
                        if ((this.flags & 2) == 2) {
                            this.state = State.HCRC;
                            this.size = 0;
                            this.value = 0L;
                            break;
                        }
                        this.state = State.DATA;
                        continue block25;
                    }
                    case 13: {
                        try {
                            RetainableByteBuffer buffer = this.compression.acquireByteBuffer(this.bufferSize);
                            ByteBuffer decoded = buffer.getByteBuffer();
                            int pos = BufferUtil.flipToFill((ByteBuffer)decoded);
                            this.inflater.inflate(decoded);
                            BufferUtil.flipToFlush((ByteBuffer)decoded, (int)pos);
                            if (buffer.hasRemaining()) {
                                return Content.Chunk.asChunk((ByteBuffer)decoded, (boolean)false, (Retainable)buffer);
                            }
                            buffer.release();
                        }
                        catch (DataFormatException x) {
                            throw new ZipException(x.getMessage());
                        }
                        if (this.inflater.needsInput()) {
                            if (!compressed.hasRemaining()) {
                                return Content.Chunk.EMPTY;
                            }
                            this.inflater.setInput(compressed);
                            continue block25;
                        }
                        if (!this.inflater.finished()) continue block25;
                        this.state = State.CRC;
                        this.size = 0;
                        this.value = 0L;
                        break;
                    }
                }
                byte currByte = compressed.get();
                switch (this.state.ordinal()) {
                    case 16: 
                    case 17: {
                        compressed.position(compressed.limit());
                        return Content.Chunk.EOF;
                    }
                    case 1: {
                        this.value += (long)((currByte & 0xFF) << 8 * this.size);
                        ++this.size;
                        if (this.size != 2) continue block25;
                        if (this.value != 35615L) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Skipping rest of input, no gzip magic number detected");
                            }
                            this.state = State.INITIAL;
                            compressed.position(compressed.limit());
                            return Content.Chunk.EOF;
                        }
                        this.state = State.CM;
                        continue block25;
                    }
                    case 2: {
                        if ((currByte & 0xFF) != 8) {
                            throw new ZipException("Invalid gzip compression method");
                        }
                        this.state = State.FLG;
                        continue block25;
                    }
                    case 3: {
                        this.flags = currByte;
                        this.state = State.MTIME;
                        this.size = 0;
                        this.value = 0L;
                        continue block25;
                    }
                    case 4: {
                        ++this.size;
                        if (this.size != 4) continue block25;
                        this.state = State.XFL;
                        continue block25;
                    }
                    case 5: {
                        this.state = State.OS;
                        continue block25;
                    }
                    case 6: {
                        this.state = State.FLAGS;
                        continue block25;
                    }
                    case 8: {
                        this.value += (long)((currByte & 0xFF) << 8 * this.size);
                        ++this.size;
                        if (this.size != 2) continue block25;
                        this.state = State.EXTRA;
                        continue block25;
                    }
                    case 9: {
                        --this.value;
                        if (this.value != 0L) continue block25;
                        this.flags = (byte)(this.flags & 0xFFFFFFFB);
                        this.state = State.FLAGS;
                        continue block25;
                    }
                    case 10: {
                        if (currByte != 0) continue block25;
                        this.flags = (byte)(this.flags & 0xFFFFFFF7);
                        this.state = State.FLAGS;
                        continue block25;
                    }
                    case 11: {
                        if (currByte != 0) continue block25;
                        this.flags = (byte)(this.flags & 0xFFFFFFEF);
                        this.state = State.FLAGS;
                        continue block25;
                    }
                    case 12: {
                        ++this.size;
                        if (this.size != 2) continue block25;
                        this.flags = (byte)(this.flags & 0xFFFFFFFD);
                        this.state = State.FLAGS;
                        continue block25;
                    }
                    case 14: {
                        this.value += (long)((currByte & 0xFF) << 8 * this.size);
                        ++this.size;
                        if (this.size != 4) continue block25;
                        this.state = State.ISIZE;
                        this.size = 0;
                        this.value = 0L;
                        continue block25;
                    }
                    case 15: {
                        this.value |= ((long)currByte & 0xFFL) << 8 * this.size;
                        ++this.size;
                        if (this.size != 4) continue block25;
                        if (this.value != (this.inflater.getBytesWritten() & 0xFFFFFFFFL)) {
                            throw new ZipException("Invalid input size");
                        }
                        this.state = State.INITIAL;
                        this.size = 0;
                        this.value = 0L;
                        return Content.Chunk.EOF;
                    }
                }
                throw new ZipException("Unknown state: " + String.valueOf((Object)this.state));
            }
        }
        catch (ZipException x) {
            this.state = State.ERROR;
            return Content.Chunk.from((Throwable)x, (boolean)true);
        }
        if (readChunk.isLast()) {
            chunk = Content.Chunk.EOF;
            return chunk;
        }
        chunk = Content.Chunk.EMPTY;
        return chunk;
    }

    protected void release() {
        this.inflaterEntry.release();
    }

    private static enum State {
        INITIAL,
        ID,
        CM,
        FLG,
        MTIME,
        XFL,
        OS,
        FLAGS,
        EXTRA_LENGTH,
        EXTRA,
        NAME,
        COMMENT,
        HCRC,
        DATA,
        CRC,
        ISIZE,
        FINISHED,
        ERROR;

    }
}

