/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.List;
import org.eclipse.jetty.compression.Compression;
import org.eclipse.jetty.compression.DecoderConfig;
import org.eclipse.jetty.compression.DecoderSource;
import org.eclipse.jetty.compression.EncoderConfig;
import org.eclipse.jetty.compression.EncoderSink;
import org.eclipse.jetty.compression.gzip.ConfiguredGzipInputStream;
import org.eclipse.jetty.compression.gzip.ConfiguredGzipOutputStream;
import org.eclipse.jetty.compression.gzip.GzipDecoderConfig;
import org.eclipse.jetty.compression.gzip.GzipDecoderSource;
import org.eclipse.jetty.compression.gzip.GzipEncoderConfig;
import org.eclipse.jetty.compression.gzip.GzipEncoderSink;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.compression.DeflaterPool;
import org.eclipse.jetty.util.compression.InflaterPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GzipCompression
extends Compression {
    public static final int DEFAULT_MIN_GZIP_SIZE = 32;
    public static final int BREAK_EVEN_GZIP_SIZE = 23;
    public static final List<String> EXTENSIONS = List.of("gz", "gzip");
    private static final Logger LOG = LoggerFactory.getLogger(GzipCompression.class);
    private static final String ENCODING_NAME = "gzip";
    public static final CompressedContentFormat GZIP = new CompressedContentFormat("gzip", ".gz");
    private static final HttpField X_CONTENT_ENCODING = new PreEncodedHttpField("X-Content-Encoding", "gzip");
    private static final HttpField CONTENT_ENCODING = new PreEncodedHttpField(HttpHeader.CONTENT_ENCODING, "gzip");
    private int minCompressSize = 32;
    private DeflaterPool deflaterPool;
    private InflaterPool inflaterPool;
    private GzipEncoderConfig defaultEncoderConfig = new GzipEncoderConfig();
    private GzipDecoderConfig defaultDecoderConfig = new GzipDecoderConfig();

    public GzipCompression() {
        super(ENCODING_NAME);
    }

    public RetainableByteBuffer acquireByteBuffer() {
        return this.acquireByteBuffer(this.getBufferSize());
    }

    public RetainableByteBuffer acquireByteBuffer(int length) {
        if (length == 0) {
            return RetainableByteBuffer.EMPTY;
        }
        RetainableByteBuffer.Mutable buffer = this.getByteBufferPool().acquire(length, false);
        buffer.getByteBuffer().order(this.getByteOrder());
        return buffer;
    }

    public HttpField getContentEncodingField() {
        return CONTENT_ENCODING;
    }

    public DecoderConfig getDefaultDecoderConfig() {
        return this.defaultDecoderConfig;
    }

    public void setDefaultDecoderConfig(DecoderConfig config) {
        GzipDecoderConfig gzipDecoderConfig;
        this.defaultDecoderConfig = gzipDecoderConfig = (GzipDecoderConfig)GzipDecoderConfig.class.cast(config);
    }

    public EncoderConfig getDefaultEncoderConfig() {
        return this.defaultEncoderConfig;
    }

    public void setDefaultEncoderConfig(EncoderConfig config) {
        GzipEncoderConfig gzipEncoderConfig;
        this.defaultEncoderConfig = gzipEncoderConfig = (GzipEncoderConfig)GzipEncoderConfig.class.cast(config);
    }

    public DeflaterPool getDeflaterPool() {
        return this.deflaterPool;
    }

    public void setDeflaterPool(DeflaterPool deflaterPool) {
        this.deflaterPool = deflaterPool;
    }

    public List<String> getFileExtensionNames() {
        return EXTENSIONS;
    }

    public InflaterPool getInflaterPool() {
        return this.inflaterPool;
    }

    public void setInflaterPool(InflaterPool inflaterPool) {
        this.inflaterPool = inflaterPool;
    }

    public int getMinCompressSize() {
        return this.minCompressSize;
    }

    public void setMinCompressSize(int minCompressSize) {
        this.minCompressSize = Math.max(minCompressSize, 32);
    }

    public String getName() {
        return ENCODING_NAME;
    }

    public HttpField getXContentEncodingField() {
        return X_CONTENT_ENCODING;
    }

    public InputStream newDecoderInputStream(InputStream in, DecoderConfig config) throws IOException {
        GzipDecoderConfig gzipDecoderConfig = (GzipDecoderConfig)GzipDecoderConfig.class.cast(config);
        return new ConfiguredGzipInputStream(in, gzipDecoderConfig);
    }

    public DecoderSource newDecoderSource(Content.Source source, DecoderConfig config) {
        GzipDecoderConfig gzipDecoderConfig = (GzipDecoderConfig)GzipDecoderConfig.class.cast(config);
        return new GzipDecoderSource(this, source, gzipDecoderConfig);
    }

    public OutputStream newEncoderOutputStream(OutputStream out, EncoderConfig config) throws IOException {
        GzipEncoderConfig gzipEncoderConfig = (GzipEncoderConfig)GzipEncoderConfig.class.cast(config);
        return new ConfiguredGzipOutputStream(out, gzipEncoderConfig);
    }

    public EncoderSink newEncoderSink(Content.Sink sink, EncoderConfig config) {
        GzipEncoderConfig gzipEncoderConfig = (GzipEncoderConfig)GzipEncoderConfig.class.cast(config);
        return new GzipEncoderSink(this, sink, gzipEncoderConfig);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.deflaterPool == null) {
            this.deflaterPool = DeflaterPool.ensurePool((Container)this.getContainer());
            this.addBean(this.deflaterPool);
        }
        if (this.inflaterPool == null) {
            this.inflaterPool = InflaterPool.ensurePool((Container)this.getContainer());
            this.addBean(this.inflaterPool);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this.inflaterPool);
        this.inflaterPool = null;
        this.removeBean(this.deflaterPool);
        this.deflaterPool = null;
    }

    private ByteOrder getByteOrder() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

