/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.cdi.websocket;

import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.eclipse.jetty.cdi.websocket.WebSocketCdiListener;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.ThreadClassLoaderScope;

public class WebSocketCdiInitializer
implements ServletContainerInitializer {
    public static void configureContext(ServletContextHandler context) throws ServletException {
        ThreadClassLoaderScope scope = new ThreadClassLoaderScope(context.getClassLoader());
        Throwable throwable = null;
        try {
            WebSocketCdiInitializer.addListeners((ContainerLifeCycle)context);
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                WebSocketCdiInitializer.$closeResource(throwable, (AutoCloseable)scope);
                throw throwable3;
            }
        }
        WebSocketCdiInitializer.$closeResource(throwable, (AutoCloseable)scope);
    }

    public void onStartup(Set<Class<?>> c, ServletContext context) throws ServletException {
        ContextHandler handler = ContextHandler.getContextHandler((ServletContext)context);
        if (handler == null) {
            throw new ServletException("Not running on Jetty, WebSocket+CDI support unavailable");
        }
        if (!(handler instanceof ServletContextHandler)) {
            throw new ServletException("Not running in Jetty ServletContextHandler, WebSocket+CDI support unavailable");
        }
        ServletContextHandler jettyContext = (ServletContextHandler)handler;
        ThreadClassLoaderScope scope = new ThreadClassLoaderScope(context.getClassLoader());
        Throwable throwable = null;
        try {
            WebSocketCdiInitializer.addListeners((ContainerLifeCycle)jettyContext);
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                WebSocketCdiInitializer.$closeResource(throwable, (AutoCloseable)scope);
                throw throwable3;
            }
        }
        WebSocketCdiInitializer.$closeResource(throwable, (AutoCloseable)scope);
    }

    private static void addListeners(ContainerLifeCycle container) {
        WebSocketCdiListener listener = new WebSocketCdiListener();
        container.addLifeCycleListener((LifeCycle.Listener)listener);
        container.addEventListener((Container.Listener)listener);
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

