/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationThrowable;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AsyncContext;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.Timeout;

public class AsyncContinuation
implements AsyncContext,
Continuation {
    private static final long DEFAULT_TIMEOUT = 30000L;
    private static final ContinuationThrowable __exception = new ContinuationThrowable();
    private static final int __IDLE = 0;
    private static final int __DISPATCHED = 1;
    private static final int __ASYNCSTARTED = 2;
    private static final int __REDISPATCHING = 3;
    private static final int __ASYNCWAIT = 4;
    private static final int __REDISPATCH = 5;
    private static final int __REDISPATCHED = 6;
    private static final int __COMPLETING = 7;
    private static final int __UNCOMPLETED = 8;
    private static final int __COMPLETED = 9;
    protected HttpConnection _connection;
    private Object _listeners;
    private int _state = 0;
    private boolean _initial = true;
    private boolean _resumed;
    private boolean _expired;
    private volatile boolean _responseWrapped;
    private long _timeoutMs = 30000L;
    private AsyncEventState _event;
    private volatile long _expireAt;

    protected AsyncContinuation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConnection(HttpConnection connection) {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            this._connection = connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContinuationListener(ContinuationListener listener) {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            this._listeners = LazyList.add(this._listeners, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsyncTimeout(long ms) {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            this._timeoutMs = ms;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAsyncTimeout() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            return this._timeoutMs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncEventState getAsyncEventState() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            return this._event;
        }
    }

    public boolean isResponseWrapped() {
        return this._responseWrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitial() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            return this._initial;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            switch (this._state) {
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            return super.toString() + "@" + this.getStatusString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatusString() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            return (this._state == 0 ? "IDLE" : (this._state == 1 ? "DISPATCHED" : (this._state == 2 ? "ASYNCSTARTED" : (this._state == 4 ? "ASYNCWAIT" : (this._state == 3 ? "REDISPATCHING" : (this._state == 5 ? "REDISPATCH" : (this._state == 6 ? "REDISPATCHED" : (this._state == 7 ? "COMPLETING" : (this._state == 8 ? "UNCOMPLETED" : (this._state == 9 ? "COMPLETE" : "UNKNOWN?" + this._state)))))))))) + (this._initial ? ",initial" : "") + (this._resumed ? ",resumed" : "") + (this._expired ? ",expired" : "");
        }
    }

    protected boolean handling() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            this._responseWrapped = false;
            switch (this._state) {
                case 1: 
                case 6: 
                case 9: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case 0: {
                    this._initial = true;
                    this._state = 1;
                    return true;
                }
                case 2: 
                case 3: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case 7: {
                    this._state = 8;
                    return false;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    this._state = 6;
                    return true;
                }
            }
            throw new IllegalStateException("" + this._state);
        }
    }

    protected void suspend(ServletContext context, ServletRequest request, ServletResponse response) {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            this._resumed = false;
            this._expired = false;
            if (this._event == null || request != this._event.getRequest() || response != this._event.getResponse() || context != this._event.getServletContext()) {
                this._event = new AsyncEventState(context, request, response);
            } else {
                this._event._dispatchContext = null;
                this._event._path = null;
            }
            switch (this._state) {
                case 1: 
                case 6: {
                    this._state = 2;
                    return;
                }
                case 0: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case 2: 
                case 3: {
                    return;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
            throw new IllegalStateException("" + this._state);
        }
    }

    protected boolean unhandle() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            switch (this._state) {
                case 1: 
                case 6: {
                    this._state = 8;
                    return true;
                }
                case 0: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case 2: {
                    this._initial = false;
                    this._state = 4;
                    this.scheduleTimeout();
                    if (this._state == 4) {
                        return true;
                    }
                    if (this._state == 7) {
                        this._state = 8;
                        return true;
                    }
                    this._initial = false;
                    this._state = 6;
                    return false;
                }
                case 3: {
                    this._initial = false;
                    this._state = 6;
                    return false;
                }
                case 7: {
                    this._initial = false;
                    this._state = 8;
                    return true;
                }
            }
            throw new IllegalStateException(this.getStatusString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch() {
        boolean dispatch = false;
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            switch (this._state) {
                case 0: 
                case 1: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return;
                }
                case 2: {
                    this._state = 3;
                    this._resumed = true;
                    return;
                }
                case 4: {
                    dispatch = !this._expired;
                    this._state = 5;
                    this._resumed = true;
                    break;
                }
                case 5: {
                    return;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        if (dispatch) {
            this.cancelTimeout();
            this.scheduleDispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expired() {
        Object listeners = null;
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            switch (this._state) {
                case 2: 
                case 4: {
                    listeners = this._listeners;
                    break;
                }
                default: {
                    return;
                }
            }
            this._expired = true;
        }
        if (listeners != null) {
            for (int i = 0; i < LazyList.size(listeners); ++i) {
                try {
                    ContinuationListener listener = (ContinuationListener)LazyList.get(listeners, i);
                    listener.onTimeout(this);
                    continue;
                }
                catch (Exception e) {
                    Log.warn(e);
                }
            }
        }
        AsyncContinuation asyncContinuation2 = this;
        synchronized (asyncContinuation2) {
            switch (this._state) {
                case 2: 
                case 4: {
                    this.dispatch();
                }
            }
        }
        this.scheduleDispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        boolean dispatch = false;
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            switch (this._state) {
                case 0: 
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    return;
                }
                case 1: 
                case 6: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case 2: {
                    this._state = 7;
                    return;
                }
                case 4: {
                    this._state = 7;
                    dispatch = !this._expired;
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        if (dispatch) {
            this.cancelTimeout();
            this.scheduleDispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doComplete() {
        Object listeners = null;
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            switch (this._state) {
                case 8: {
                    this._state = 9;
                    listeners = this._listeners;
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        if (listeners != null) {
            for (int i = 0; i < LazyList.size(listeners); ++i) {
                try {
                    ((ContinuationListener)LazyList.get(listeners, i)).onComplete(this);
                    continue;
                }
                catch (Exception e) {
                    Log.warn(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycle() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            switch (this._state) {
                case 1: 
                case 6: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
            this._state = 0;
            this._initial = true;
            this._resumed = false;
            this._expired = false;
            this._responseWrapped = false;
            this.cancelTimeout();
            this._timeoutMs = 30000L;
            this._listeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            this.cancelTimeout();
            this._listeners = null;
        }
    }

    protected void scheduleDispatch() {
        EndPoint endp = this._connection.getEndPoint();
        if (!endp.isBlocking()) {
            ((AsyncEndPoint)endp).dispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleTimeout() {
        EndPoint endp = this._connection.getEndPoint();
        if (endp.isBlocking()) {
            AsyncContinuation asyncContinuation = this;
            synchronized (asyncContinuation) {
                this._expireAt = System.currentTimeMillis() + this._timeoutMs;
                long wait = this._timeoutMs;
                while (this._expireAt > 0L && wait > 0L) {
                    try {
                        this.wait(wait);
                    }
                    catch (InterruptedException e) {
                        Log.ignore(e);
                    }
                    wait = this._expireAt - System.currentTimeMillis();
                }
                if (this._expireAt > 0L && wait <= 0L) {
                    this.expired();
                }
            }
        }
        this._connection.scheduleTimeout(this._event._timeout, this._timeoutMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelTimeout() {
        EndPoint endp = this._connection.getEndPoint();
        if (endp.isBlocking()) {
            AsyncContinuation asyncContinuation = this;
            synchronized (asyncContinuation) {
                this._expireAt = 0L;
                this.notifyAll();
            }
        } else {
            AsyncEventState event = this._event;
            if (event != null) {
                this._connection.cancelTimeout(event._timeout);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompleting() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            return this._state == 7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isUncompleted() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            return this._state == 8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isComplete() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            return this._state == 9;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAsyncStarted() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            switch (this._state) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAsync() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            switch (this._state) {
                case 0: 
                case 1: 
                case 8: 
                case 9: {
                    return false;
                }
            }
            return true;
        }
    }

    public void dispatch(ServletContext context, String path) {
        this._event._dispatchContext = context;
        this._event._path = path;
        this.dispatch();
    }

    public void dispatch(String path) {
        this._event._path = path;
        this.dispatch();
    }

    public ServletRequest getRequest() {
        if (this._event != null) {
            return this._event.getRequest();
        }
        return this._connection.getRequest();
    }

    public ServletResponse getResponse() {
        if (this._event != null) {
            return this._event.getResponse();
        }
        return this._connection.getResponse();
    }

    public void start(Runnable run) {
        AsyncEventState event = this._event;
        if (event != null) {
            ((ContextHandler.Context)event.getServletContext()).getContextHandler().handle(run);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasOriginalRequestAndResponse() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            return this._event != null && this._event.getRequest() == this._connection._request && this._event.getResponse() == this._connection._response;
        }
    }

    public ContextHandler getContextHandler() {
        AsyncEventState event = this._event;
        if (event != null) {
            return ((ContextHandler.Context)event.getServletContext()).getContextHandler();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResumed() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            return this._resumed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpired() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            return this._expired;
        }
    }

    public void resume() {
        this.dispatch();
    }

    public void setTimeout(long timeoutMs) {
        this.setAsyncTimeout(timeoutMs);
    }

    public void suspend(ServletResponse response) {
        if (response instanceof ServletResponseWrapper) {
            this._responseWrapped = true;
            this.suspend(this._connection.getRequest().getServletContext(), (ServletRequest)this._connection.getRequest(), response);
        } else {
            this._responseWrapped = false;
            this.suspend(this._connection.getRequest().getServletContext(), (ServletRequest)this._connection.getRequest(), (ServletResponse)this._connection.getResponse());
        }
    }

    public void suspend() {
        this._responseWrapped = false;
        this.suspend(this._connection.getRequest().getServletContext(), (ServletRequest)this._connection.getRequest(), (ServletResponse)this._connection.getResponse());
    }

    public ServletResponse getServletResponse() {
        if (this._responseWrapped && this._event != null && this._event.getResponse() != null) {
            return this._event.getResponse();
        }
        return this._connection.getResponse();
    }

    public Object getAttribute(String name) {
        return this._connection.getRequest().getAttribute(name);
    }

    public void removeAttribute(String name) {
        this._connection.getRequest().removeAttribute(name);
    }

    public void setAttribute(String name, Object attribute) {
        this._connection.getRequest().setAttribute(name, attribute);
    }

    public void undispatch() {
        if (this.isSuspended()) {
            if (Log.isDebugEnabled()) {
                throw new ContinuationThrowable();
            }
            throw __exception;
        }
        throw new IllegalStateException("!suspended");
    }

    public String getHistory() {
        return null;
    }

    public class AsyncEventState {
        private final ServletContext _suspendedContext;
        private final ServletRequest _request;
        private final ServletResponse _response;
        ServletContext _dispatchContext;
        String _path;
        final Timeout.Task _timeout = new Timeout.Task(){

            public void expired() {
                AsyncContinuation.this.expired();
            }
        };

        public AsyncEventState(ServletContext context, ServletRequest request, ServletResponse response) {
            this._suspendedContext = context;
            this._request = request;
            this._response = response;
        }

        public ServletContext getSuspendedContext() {
            return this._suspendedContext;
        }

        public ServletContext getDispatchContext() {
            return this._dispatchContext;
        }

        public ServletContext getServletContext() {
            return this._dispatchContext == null ? this._suspendedContext : this._dispatchContext;
        }

        public ServletRequest getRequest() {
            return this._request;
        }

        public ServletResponse getResponse() {
            return this._response;
        }

        public String getPath() {
            return this._path;
        }
    }
}

