/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.RolloverFileOutputStream;

public class DebugHandler
extends HandlerWrapper {
    private DateCache _date = new DateCache("HH:mm:ss", Locale.US);
    private OutputStream _out;
    private PrintStream _print;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        int ms3;
        String d3;
        String name;
        Response base_response;
        block7: {
            base_response = baseRequest.getResponse();
            Thread thread = Thread.currentThread();
            String old_name = thread.getName();
            boolean suspend = false;
            boolean retry = false;
            name = (String)request.getAttribute("org.mortbay.jetty.thread.name");
            if (name == null) {
                name = old_name + "://" + baseRequest.getHeader("Host") + baseRequest.getUri();
            } else {
                retry = true;
            }
            try {
                String d2 = this._date.now();
                int ms2 = this._date.lastMs();
                if (retry) {
                    this._print.println(d2 + (ms2 > 99 ? "." : (ms2 > 9 ? ".0" : ".00")) + ms2 + ":" + name + " RETRY");
                } else {
                    this._print.println(d2 + (ms2 > 99 ? "." : (ms2 > 9 ? ".0" : ".00")) + ms2 + ":" + name + " " + baseRequest.getRemoteAddr() + " " + request.getMethod() + " " + baseRequest.getHeader("Cookie") + "; " + baseRequest.getHeader("User-Agent"));
                }
                thread.setName(name);
                this.getHandler().handle(target, baseRequest, request, response);
                Object var14_13 = null;
                thread.setName(old_name);
                d3 = this._date.now();
                ms3 = this._date.lastMs();
                suspend = baseRequest.getAsyncContinuation().isSuspended();
                if (!suspend) break block7;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                thread.setName(old_name);
                String d3 = this._date.now();
                int ms3 = this._date.lastMs();
                suspend = baseRequest.getAsyncContinuation().isSuspended();
                if (suspend) {
                    request.setAttribute("org.mortbay.jetty.thread.name", (Object)name);
                    this._print.println(d3 + (ms3 > 99 ? "." : (ms3 > 9 ? ".0" : ".00")) + ms3 + ":" + name + " SUSPEND");
                    throw throwable;
                }
                this._print.println(d3 + (ms3 > 99 ? "." : (ms3 > 9 ? ".0" : ".00")) + ms3 + ":" + name + " " + base_response.getStatus() + " " + base_response.getContentType() + " " + base_response.getContentCount());
                throw throwable;
            }
            request.setAttribute("org.mortbay.jetty.thread.name", (Object)name);
            this._print.println(d3 + (ms3 > 99 ? "." : (ms3 > 9 ? ".0" : ".00")) + ms3 + ":" + name + " SUSPEND");
            return;
        }
        this._print.println(d3 + (ms3 > 99 ? "." : (ms3 > 9 ? ".0" : ".00")) + ms3 + ":" + name + " " + base_response.getStatus() + " " + base_response.getContentType() + " " + base_response.getContentCount());
    }

    protected void doStart() throws Exception {
        if (this._out == null) {
            this._out = new RolloverFileOutputStream("./logs/yyyy_mm_dd.debug.log", true);
        }
        this._print = new PrintStream(this._out);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this._print.close();
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    public void setOutputStream(OutputStream out) {
        this._out = out;
    }
}

