/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.jetty.http.security.Credential;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.MappedLoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;

public class JDBCLoginService
extends MappedLoginService {
    private String _config;
    private String _jdbcDriver;
    private String _url;
    private String _userName;
    private String _password;
    private String _userTableKey;
    private String _userTablePasswordField;
    private String _roleTableRoleField;
    private int _cacheTime;
    private long _lastHashPurge;
    private Connection _con;
    private String _userSql;
    private String _roleSql;

    public JDBCLoginService() throws IOException {
    }

    public JDBCLoginService(String name) throws IOException {
        this.setName(name);
    }

    public JDBCLoginService(String name, String config) throws IOException {
        this.setName(name);
        this.setConfig(config);
    }

    public JDBCLoginService(String name, IdentityService identityService, String config) throws IOException {
        this.setName(name);
        this.setIdentityService(identityService);
        this.setConfig(config);
    }

    @Override
    protected void doStart() throws Exception {
        Properties properties = new Properties();
        Resource resource = Resource.newResource(this._config);
        properties.load(resource.getInputStream());
        this._jdbcDriver = properties.getProperty("jdbcdriver");
        this._url = properties.getProperty("url");
        this._userName = properties.getProperty("username");
        this._password = properties.getProperty("password");
        String _userTable = properties.getProperty("usertable");
        this._userTableKey = properties.getProperty("usertablekey");
        String _userTableUserField = properties.getProperty("usertableuserfield");
        this._userTablePasswordField = properties.getProperty("usertablepasswordfield");
        String _roleTable = properties.getProperty("roletable");
        String _roleTableKey = properties.getProperty("roletablekey");
        this._roleTableRoleField = properties.getProperty("roletablerolefield");
        String _userRoleTable = properties.getProperty("userroletable");
        String _userRoleTableUserKey = properties.getProperty("userroletableuserkey");
        String _userRoleTableRoleKey = properties.getProperty("userroletablerolekey");
        this._cacheTime = new Integer(properties.getProperty("cachetime"));
        if ((this._jdbcDriver == null || this._jdbcDriver.equals("") || this._url == null || this._url.equals("") || this._userName == null || this._userName.equals("") || this._password == null || this._cacheTime < 0) && Log.isDebugEnabled()) {
            Log.debug("UserRealm " + this.getName() + " has not been properly configured");
        }
        this._cacheTime *= 1000;
        this._lastHashPurge = 0L;
        this._userSql = "select " + this._userTableKey + "," + this._userTablePasswordField + " from " + _userTable + " where " + _userTableUserField + " = ?";
        this._roleSql = "select r." + this._roleTableRoleField + " from " + _roleTable + " r, " + _userRoleTable + " u where u." + _userRoleTableUserKey + " = ?" + " and r." + _roleTableKey + " = u." + _userRoleTableRoleKey;
        Loader.loadClass(this.getClass(), this._jdbcDriver).newInstance();
        super.doStart();
    }

    public String getConfig() {
        return this._config;
    }

    public void setConfig(String config) {
        if (this.isRunning()) {
            throw new IllegalStateException("Running");
        }
        this._config = config;
    }

    public void connectDatabase() {
        try {
            Class.forName(this._jdbcDriver);
            this._con = DriverManager.getConnection(this._url, this._userName, this._password);
        }
        catch (SQLException e) {
            Log.warn("UserRealm " + this.getName() + " could not connect to database; will try later", e);
        }
        catch (ClassNotFoundException e) {
            Log.warn("UserRealm " + this.getName() + " could not connect to database; will try later", e);
        }
    }

    @Override
    public UserIdentity login(String username, Object credentials) {
        long now = System.currentTimeMillis();
        if (now - this._lastHashPurge > (long)this._cacheTime || this._cacheTime == 0) {
            this._users.clear();
            this._lastHashPurge = now;
            this.closeConnection();
        }
        return super.login(username, credentials);
    }

    @Override
    protected void loadUsers() {
    }

    @Override
    protected UserIdentity loadUser(String username) {
        try {
            if (null == this._con) {
                this.connectDatabase();
            }
            if (null == this._con) {
                throw new SQLException("Can't connect to database");
            }
            PreparedStatement stat = this._con.prepareStatement(this._userSql);
            stat.setObject(1, username);
            ResultSet rs = stat.executeQuery();
            if (rs.next()) {
                int key = rs.getInt(this._userTableKey);
                String credentials = rs.getString(this._userTablePasswordField);
                stat.close();
                stat = this._con.prepareStatement(this._roleSql);
                stat.setInt(1, key);
                rs = stat.executeQuery();
                ArrayList<String> roles = new ArrayList<String>();
                while (rs.next()) {
                    roles.add(rs.getString(this._roleTableRoleField));
                }
                stat.close();
                return this.putUser(username, Credential.getCredential(credentials), roles.toArray(new String[roles.size()]));
            }
        }
        catch (SQLException e) {
            Log.warn("UserRealm " + this.getName() + " could not load user information from database", e);
            this.closeConnection();
        }
        return null;
    }

    private void closeConnection() {
        if (this._con != null) {
            if (Log.isDebugEnabled()) {
                Log.debug("Closing db connection for JDBCUserRealm");
            }
            try {
                this._con.close();
            }
            catch (Exception e) {
                Log.ignore(e);
            }
        }
        this._con = null;
    }
}

