/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.gzip;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclipse.jetty.http.gzip.AbstractCompressedStream;
import org.eclipse.jetty.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompressedResponseWrapper
extends HttpServletResponseWrapper {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int DEFAULT_MIN_COMPRESS_SIZE = 256;
    private Set<String> _mimeTypes;
    private int _bufferSize = 8192;
    private int _minCompressSize = 256;
    protected HttpServletRequest _request;
    private PrintWriter _writer;
    private AbstractCompressedStream _compressedStream;
    private long _contentLength = -1L;
    private boolean _noCompression;

    public CompressedResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
        super(response);
        this._request = request;
    }

    public void setMimeTypes(Set<String> mimeTypes) {
        this._mimeTypes = mimeTypes;
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public void setMinCompressSize(int minCompressSize) {
        this._minCompressSize = minCompressSize;
    }

    public void setContentType(String ct) {
        int colon;
        super.setContentType(ct);
        if (ct != null && (colon = ct.indexOf(";")) > 0) {
            ct = ct.substring(0, colon);
        }
        if ((this._compressedStream == null || this._compressedStream.getOutputStream() == null) && (this._mimeTypes == null && ct != null && ct.contains("gzip") || this._mimeTypes != null && (ct == null || !this._mimeTypes.contains(StringUtil.asciiToLowerCase(ct))))) {
            this.noCompression();
        }
    }

    public void setStatus(int sc, String sm) {
        super.setStatus(sc, sm);
        if (sc < 200 || sc == 204 || sc == 205 || sc >= 300) {
            this.noCompression();
        }
    }

    public void setStatus(int sc) {
        super.setStatus(sc);
        if (sc < 200 || sc == 204 || sc == 205 || sc >= 300) {
            this.noCompression();
        }
    }

    public void setContentLength(int length) {
        this.setContentLength((long)length);
    }

    protected void setContentLength(long length) {
        this._contentLength = length;
        if (this._compressedStream != null) {
            this._compressedStream.setContentLength(length);
        } else if (this._noCompression && this._contentLength >= 0L) {
            HttpServletResponse response = (HttpServletResponse)this.getResponse();
            if (this._contentLength < Integer.MAX_VALUE) {
                response.setContentLength((int)this._contentLength);
            } else {
                response.setHeader("Content-Length", Long.toString(this._contentLength));
            }
        }
    }

    public void addHeader(String name, String value) {
        if ("content-length".equalsIgnoreCase(name)) {
            this._contentLength = Long.parseLong(value);
            if (this._compressedStream != null) {
                this._compressedStream.setContentLength(this._contentLength);
            }
        } else if ("content-type".equalsIgnoreCase(name)) {
            this.setContentType(value);
        } else if ("content-encoding".equalsIgnoreCase(name)) {
            super.addHeader(name, value);
            if (!this.isCommitted()) {
                this.noCompression();
            }
        } else {
            super.addHeader(name, value);
        }
    }

    public void flushBuffer() throws IOException {
        if (this._writer != null) {
            this._writer.flush();
        }
        if (this._compressedStream != null) {
            this._compressedStream.finish();
        } else {
            this.getResponse().flushBuffer();
        }
    }

    public void reset() {
        super.reset();
        if (this._compressedStream != null) {
            this._compressedStream.resetBuffer();
        }
        this._writer = null;
        this._compressedStream = null;
        this._noCompression = false;
        this._contentLength = -1L;
    }

    public void resetBuffer() {
        super.resetBuffer();
        if (this._compressedStream != null) {
            this._compressedStream.resetBuffer();
        }
        this._writer = null;
        this._compressedStream = null;
    }

    public void sendError(int sc, String msg) throws IOException {
        this.resetBuffer();
        super.sendError(sc, msg);
    }

    public void sendError(int sc) throws IOException {
        this.resetBuffer();
        super.sendError(sc);
    }

    public void sendRedirect(String location) throws IOException {
        this.resetBuffer();
        super.sendRedirect(location);
    }

    public void noCompression() {
        this._noCompression = true;
        if (this._compressedStream != null) {
            try {
                this._compressedStream.doNotCompress();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void finish() throws IOException {
        if (this._writer != null && !this._compressedStream.isClosed()) {
            this._writer.flush();
        }
        if (this._compressedStream != null) {
            this._compressedStream.finish();
        }
    }

    public void setHeader(String name, String value) {
        if ("content-length".equalsIgnoreCase(name)) {
            this.setContentLength(Long.parseLong(value));
        } else if ("content-type".equalsIgnoreCase(name)) {
            this.setContentType(value);
        } else if ("content-encoding".equalsIgnoreCase(name)) {
            super.setHeader(name, value);
            if (!this.isCommitted()) {
                this.noCompression();
            }
        } else {
            super.setHeader(name, value);
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this._compressedStream == null) {
            if (this.getResponse().isCommitted() || this._noCompression) {
                this.setContentLength(this._contentLength);
                return this.getResponse().getOutputStream();
            }
            this._compressedStream = this.newCompressedStream(this._request, (HttpServletResponse)this.getResponse(), this._contentLength, this._bufferSize, this._minCompressSize);
        } else if (this._writer != null) {
            throw new IllegalStateException("getWriter() called");
        }
        return this._compressedStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this._writer == null) {
            if (this._compressedStream != null) {
                throw new IllegalStateException("getOutputStream() called");
            }
            if (this.getResponse().isCommitted() || this._noCompression) {
                this.setContentLength(this._contentLength);
                return this.getResponse().getWriter();
            }
            this._compressedStream = this.newCompressedStream(this._request, (HttpServletResponse)this.getResponse(), this._contentLength, this._bufferSize, this._minCompressSize);
            this._writer = this.newWriter((OutputStream)((Object)this._compressedStream), this.getCharacterEncoding());
        }
        return this._writer;
    }

    public void setIntHeader(String name, int value) {
        if ("content-length".equalsIgnoreCase(name)) {
            this._contentLength = value;
            if (this._compressedStream != null) {
                this._compressedStream.setContentLength(this._contentLength);
            }
        } else {
            super.setIntHeader(name, value);
        }
    }

    protected PrintWriter newWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
        return encoding == null ? new PrintWriter(out) : new PrintWriter(new OutputStreamWriter(out, encoding));
    }

    protected abstract AbstractCompressedStream newCompressedStream(HttpServletRequest var1, HttpServletResponse var2, long var3, int var5, int var6) throws IOException;
}

