/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import org.eclipse.jetty.io.nio.NIOBuffer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Timeout;

public class SslConnection
extends AbstractConnection
implements AsyncConnection {
    static final Logger LOG = Log.getLogger("org.eclipse.jetty.io.nio.ssl");
    private static final NIOBuffer __ZERO_BUFFER = new IndirectNIOBuffer(0);
    private static final ThreadLocal<SslBuffers> __buffers = new ThreadLocal();
    private final SSLEngine _engine;
    private final SSLSession _session;
    private AsyncConnection _connection;
    private final SslEndPoint _sslEndPoint;
    private int _allocations;
    private SslBuffers _buffers;
    private NIOBuffer _inbound;
    private NIOBuffer _unwrapBuf;
    private NIOBuffer _outbound;
    private AsyncEndPoint _aEndp;
    private boolean _allowRenegotiate = true;
    private boolean _handshook;
    private boolean _ishut;
    private boolean _oshut;
    private final AtomicBoolean _progressed = new AtomicBoolean();

    public SslConnection(SSLEngine engine, EndPoint endp) {
        this(engine, endp, System.currentTimeMillis());
    }

    public SslConnection(SSLEngine engine, EndPoint endp, long timeStamp) {
        super(endp, timeStamp);
        this._engine = engine;
        this._session = this._engine.getSession();
        this._aEndp = (AsyncEndPoint)endp;
        this._sslEndPoint = this.newSslEndPoint();
    }

    protected SslEndPoint newSslEndPoint() {
        return new SslEndPoint();
    }

    public boolean isAllowRenegotiate() {
        return this._allowRenegotiate;
    }

    public void setAllowRenegotiate(boolean allowRenegotiate) {
        this._allowRenegotiate = allowRenegotiate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allocateBuffers() {
        SslConnection sslConnection = this;
        synchronized (sslConnection) {
            if (this._allocations++ == 0 && this._buffers == null) {
                this._buffers = __buffers.get();
                if (this._buffers == null) {
                    this._buffers = new SslBuffers(this._session.getPacketBufferSize() * 2, this._session.getApplicationBufferSize() * 2);
                }
                this._inbound = this._buffers._in;
                this._outbound = this._buffers._out;
                this._unwrapBuf = this._buffers._unwrap;
                __buffers.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseBuffers() {
        SslConnection sslConnection = this;
        synchronized (sslConnection) {
            if (--this._allocations == 0 && this._buffers != null && this._inbound.length() == 0 && this._outbound.length() == 0 && this._unwrapBuf.length() == 0) {
                this._inbound = null;
                this._outbound = null;
                this._unwrapBuf = null;
                __buffers.set(this._buffers);
                this._buffers = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection handle() throws IOException {
        try {
            this.allocateBuffers();
            boolean progress = true;
            while (progress) {
                progress = false;
                if (this._engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                    progress = this.process(null, null);
                } else {
                    AsyncConnection next = (AsyncConnection)this._connection.handle();
                    if (next != this._connection && next != null) {
                        this._connection = next;
                        progress = true;
                    }
                }
                LOG.debug("{} handle {} progress={}", this._session, this, progress);
            }
        }
        finally {
            this.releaseBuffers();
            if (!this._ishut && this._sslEndPoint.isInputShutdown() && this._sslEndPoint.isOpen()) {
                this._ishut = true;
                try {
                    this._connection.onInputShutdown();
                }
                catch (Throwable x) {
                    LOG.warn("onInputShutdown failed", x);
                    try {
                        this._sslEndPoint.close();
                    }
                    catch (IOException e2) {
                        LOG.ignore(e2);
                    }
                }
            }
        }
        return this;
    }

    public boolean isIdle() {
        return false;
    }

    public boolean isSuspended() {
        return false;
    }

    public void onClose() {
    }

    public void onIdleExpired(long idleForMs) {
        try {
            LOG.debug("onIdleExpired {}ms on {}", idleForMs, this);
            if (this._endp.isOutputShutdown()) {
                this._sslEndPoint.close();
            } else {
                this._sslEndPoint.shutdownOutput();
            }
        }
        catch (IOException e) {
            LOG.warn(e);
            super.onIdleExpired(idleForMs);
        }
    }

    public void onInputShutdown() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean process(Buffer toFill, Buffer toFlush) throws IOException {
        boolean some_progress = false;
        try {
            this.allocateBuffers();
            if (toFill == null) {
                this._unwrapBuf.compact();
                toFill = this._unwrapBuf;
            } else {
                if (toFill.capacity() < this._session.getApplicationBufferSize()) {
                    boolean progress = this.process(null, toFlush);
                    if (this._unwrapBuf != null && this._unwrapBuf.hasContent()) {
                        this._unwrapBuf.skip(toFill.put(this._unwrapBuf));
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = progress;
                    return bl;
                }
                if (this._unwrapBuf != null && this._unwrapBuf.hasContent()) {
                    this._unwrapBuf.skip(toFill.put(this._unwrapBuf));
                    boolean progress = true;
                    return progress;
                }
            }
            if (toFlush == null) {
                toFlush = __ZERO_BUFFER;
            }
            boolean progress = true;
            while (progress) {
                progress = false;
                int filled = 0;
                int flushed = 0;
                try {
                    if (this._inbound.space() > 0 && (filled = this._endp.fill(this._inbound)) > 0) {
                        progress = true;
                    }
                    if (this._outbound.hasContent() && (flushed = this._endp.flush(this._outbound)) > 0) {
                        progress = true;
                    }
                }
                catch (IOException e) {
                    try {
                        this._endp.close();
                        throw e;
                    }
                    catch (Throwable throwable) {
                        LOG.debug("{} {} {} filled={}/{} flushed={}/{}", new Object[]{this._session, this, this._engine.getHandshakeStatus(), filled, this._inbound.length(), flushed, this._outbound.length()});
                        throw throwable;
                    }
                }
                LOG.debug("{} {} {} filled={}/{} flushed={}/{}", new Object[]{this._session, this, this._engine.getHandshakeStatus(), filled, this._inbound.length(), flushed, this._outbound.length()});
                switch (this._engine.getHandshakeStatus()) {
                    case FINISHED: {
                        throw new IllegalStateException();
                    }
                    case NOT_HANDSHAKING: {
                        if (toFill.space() > 0 && this._inbound.hasContent() && this.unwrap(toFill)) {
                            progress = true;
                        }
                        if (!toFlush.hasContent() || this._outbound.space() <= 0 || !this.wrap(toFlush)) break;
                        progress = true;
                        break;
                    }
                    case NEED_TASK: {
                        Runnable task;
                        while ((task = this._engine.getDelegatedTask()) != null) {
                            progress = true;
                            task.run();
                        }
                        break;
                    }
                    case NEED_WRAP: {
                        if (this._handshook && !this._allowRenegotiate) {
                            this._endp.close();
                            break;
                        }
                        if (!this.wrap(toFlush)) break;
                        progress = true;
                        break;
                    }
                    case NEED_UNWRAP: {
                        if (this._handshook && !this._allowRenegotiate) {
                            this._endp.close();
                            break;
                        }
                        if (!this.unwrap(toFill)) break;
                        progress = true;
                    }
                }
                if (this._endp.isOpen() && this._endp.isInputShutdown() && !this._inbound.hasContent()) {
                    this._engine.closeInbound();
                }
                if (this._endp.isOpen() && this._engine.isOutboundDone() && !this._outbound.hasContent()) {
                    this._endp.shutdownOutput();
                }
                some_progress |= progress;
            }
            if (toFill.hasContent()) {
                this._aEndp.asyncDispatch();
            }
        }
        finally {
            this.releaseBuffers();
            if (some_progress) {
                this._progressed.set(true);
            }
        }
        return some_progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean wrap(Buffer buffer) throws IOException {
        SSLEngineResult result;
        ByteBuffer bbuf;
        ByteBuffer byteBuffer = bbuf = this.extractByteBuffer(buffer);
        synchronized (byteBuffer) {
            ByteBuffer out_buffer;
            this._outbound.compact();
            ByteBuffer byteBuffer2 = out_buffer = this._outbound.getByteBuffer();
            synchronized (byteBuffer2) {
                try {
                    bbuf.position(buffer.getIndex());
                    bbuf.limit(buffer.putIndex());
                    out_buffer.position(this._outbound.putIndex());
                    out_buffer.limit(out_buffer.capacity());
                    result = this._engine.wrap(bbuf, out_buffer);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} wrap {} {} consumed={} produced={}", new Object[]{this._session, result.getStatus(), result.getHandshakeStatus(), result.bytesConsumed(), result.bytesProduced()});
                    }
                    buffer.skip(result.bytesConsumed());
                    this._outbound.setPutIndex(this._outbound.putIndex() + result.bytesProduced());
                }
                catch (SSLException e) {
                    LOG.warn(String.valueOf(this._endp), e);
                    this._endp.close();
                    throw e;
                }
                finally {
                    out_buffer.position(0);
                    out_buffer.limit(out_buffer.capacity());
                    bbuf.position(0);
                    bbuf.limit(bbuf.capacity());
                }
            }
        }
        switch (result.getStatus()) {
            case BUFFER_UNDERFLOW: {
                throw new IllegalStateException();
            }
            case BUFFER_OVERFLOW: {
                break;
            }
            case OK: {
                if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) break;
                this._handshook = true;
                break;
            }
            case CLOSED: {
                LOG.debug("wrap CLOSE {} {}", this, result);
                if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) break;
                this._endp.close();
                break;
            }
            default: {
                LOG.warn("{} wrap default {}", this._session, result);
                throw new IOException(result.toString());
            }
        }
        return result.bytesConsumed() > 0 || result.bytesProduced() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean unwrap(Buffer buffer) throws IOException {
        SSLEngineResult result;
        ByteBuffer bbuf;
        if (!this._inbound.hasContent()) {
            return false;
        }
        ByteBuffer byteBuffer = bbuf = this.extractByteBuffer(buffer);
        synchronized (byteBuffer) {
            ByteBuffer in_buffer;
            ByteBuffer byteBuffer2 = in_buffer = this._inbound.getByteBuffer();
            synchronized (byteBuffer2) {
                try {
                    bbuf.position(buffer.putIndex());
                    bbuf.limit(buffer.capacity());
                    in_buffer.position(this._inbound.getIndex());
                    in_buffer.limit(this._inbound.putIndex());
                    result = this._engine.unwrap(in_buffer, bbuf);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} unwrap {} {} consumed={} produced={}", new Object[]{this._session, result.getStatus(), result.getHandshakeStatus(), result.bytesConsumed(), result.bytesProduced()});
                    }
                    this._inbound.skip(result.bytesConsumed());
                    this._inbound.compact();
                    buffer.setPutIndex(buffer.putIndex() + result.bytesProduced());
                }
                catch (SSLException e) {
                    LOG.warn(String.valueOf(this._endp), e);
                    this._endp.close();
                    throw e;
                }
                finally {
                    in_buffer.position(0);
                    in_buffer.limit(in_buffer.capacity());
                    bbuf.position(0);
                    bbuf.limit(bbuf.capacity());
                }
            }
        }
        switch (result.getStatus()) {
            case BUFFER_UNDERFLOW: {
                break;
            }
            case BUFFER_OVERFLOW: {
                LOG.debug("{} unwrap {} {}->{}", new Object[]{this._session, result.getStatus(), this._inbound.toDetailString(), buffer.toDetailString()});
                break;
            }
            case OK: {
                if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) break;
                this._handshook = true;
                break;
            }
            case CLOSED: {
                LOG.debug("unwrap CLOSE {} {}", this, result);
                if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) break;
                this._endp.close();
                break;
            }
            default: {
                LOG.warn("{} wrap default {}", this._session, result);
                throw new IOException(result.toString());
            }
        }
        return result.bytesConsumed() > 0 || result.bytesProduced() > 0;
    }

    private ByteBuffer extractByteBuffer(Buffer buffer) {
        if (buffer.buffer() instanceof NIOBuffer) {
            return ((NIOBuffer)buffer.buffer()).getByteBuffer();
        }
        return ByteBuffer.wrap(buffer.array());
    }

    public AsyncEndPoint getSslEndPoint() {
        return this._sslEndPoint;
    }

    public String toString() {
        return String.format("%s %s", super.toString(), this._sslEndPoint);
    }

    public class SslEndPoint
    implements AsyncEndPoint {
        public SSLEngine getSslEngine() {
            return SslConnection.this._engine;
        }

        public AsyncEndPoint getEndpoint() {
            return SslConnection.this._aEndp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdownOutput() throws IOException {
            SslConnection sslConnection = SslConnection.this;
            synchronized (sslConnection) {
                LOG.debug("{} ssl endp.oshut {}", SslConnection.this._session, this);
                SslConnection.this._engine.closeOutbound();
                SslConnection.this._oshut = true;
            }
            this.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isOutputShutdown() {
            SslConnection sslConnection = SslConnection.this;
            synchronized (sslConnection) {
                return SslConnection.this._oshut || !this.isOpen() || SslConnection.this._engine.isOutboundDone();
            }
        }

        public void shutdownInput() throws IOException {
            LOG.debug("{} ssl endp.ishut!", SslConnection.this._session);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isInputShutdown() {
            SslConnection sslConnection = SslConnection.this;
            synchronized (sslConnection) {
                return !(!SslConnection.this._endp.isInputShutdown() || SslConnection.this._unwrapBuf != null && SslConnection.this._unwrapBuf.hasContent() || SslConnection.this._inbound != null && SslConnection.this._inbound.hasContent());
            }
        }

        public void close() throws IOException {
            LOG.debug("{} ssl endp.close", SslConnection.this._session);
            SslConnection.this._endp.close();
        }

        public int fill(Buffer buffer) throws IOException {
            int size = buffer.length();
            SslConnection.this.process(buffer, null);
            int filled = buffer.length() - size;
            if (filled == 0 && this.isInputShutdown()) {
                return -1;
            }
            return filled;
        }

        public int flush(Buffer buffer) throws IOException {
            int size = buffer.length();
            SslConnection.this.process(null, buffer);
            return size - buffer.length();
        }

        public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
            if (header != null && header.hasContent()) {
                return this.flush(header);
            }
            if (buffer != null && buffer.hasContent()) {
                return this.flush(buffer);
            }
            if (trailer != null && trailer.hasContent()) {
                return this.flush(trailer);
            }
            return 0;
        }

        public boolean blockReadable(long millisecs) throws IOException {
            long end;
            long now = System.currentTimeMillis();
            long l = end = millisecs > 0L ? now + millisecs : Long.MAX_VALUE;
            while (now < end && !SslConnection.this.process(null, null)) {
                SslConnection.this._endp.blockReadable(end - now);
                now = System.currentTimeMillis();
            }
            return now < end;
        }

        public boolean blockWritable(long millisecs) throws IOException {
            return SslConnection.this._endp.blockWritable(millisecs);
        }

        public boolean isOpen() {
            return SslConnection.this._endp.isOpen();
        }

        public Object getTransport() {
            return SslConnection.this._endp;
        }

        public void flush() throws IOException {
            SslConnection.this.process(null, null);
        }

        public void asyncDispatch() {
            SslConnection.this._aEndp.asyncDispatch();
        }

        public void scheduleWrite() {
            SslConnection.this._aEndp.scheduleWrite();
        }

        public void onIdleExpired(long idleForMs) {
            SslConnection.this._aEndp.onIdleExpired(idleForMs);
        }

        public void setCheckForIdle(boolean check) {
            SslConnection.this._aEndp.setCheckForIdle(check);
        }

        public boolean isCheckForIdle() {
            return SslConnection.this._aEndp.isCheckForIdle();
        }

        public void scheduleTimeout(Timeout.Task task, long timeoutMs) {
            SslConnection.this._aEndp.scheduleTimeout(task, timeoutMs);
        }

        public void cancelTimeout(Timeout.Task task) {
            SslConnection.this._aEndp.cancelTimeout(task);
        }

        public boolean isWritable() {
            return SslConnection.this._aEndp.isWritable();
        }

        public boolean hasProgressed() {
            return SslConnection.this._progressed.getAndSet(false);
        }

        public String getLocalAddr() {
            return SslConnection.this._aEndp.getLocalAddr();
        }

        public String getLocalHost() {
            return SslConnection.this._aEndp.getLocalHost();
        }

        public int getLocalPort() {
            return SslConnection.this._aEndp.getLocalPort();
        }

        public String getRemoteAddr() {
            return SslConnection.this._aEndp.getRemoteAddr();
        }

        public String getRemoteHost() {
            return SslConnection.this._aEndp.getRemoteHost();
        }

        public int getRemotePort() {
            return SslConnection.this._aEndp.getRemotePort();
        }

        public boolean isBlocking() {
            return false;
        }

        public int getMaxIdleTime() {
            return SslConnection.this._aEndp.getMaxIdleTime();
        }

        public void setMaxIdleTime(int timeMs) throws IOException {
            SslConnection.this._aEndp.setMaxIdleTime(timeMs);
        }

        public Connection getConnection() {
            return SslConnection.this._connection;
        }

        public void setConnection(Connection connection) {
            SslConnection.this._connection = (AsyncConnection)connection;
        }

        public String toString() {
            NIOBuffer inbound = SslConnection.this._inbound;
            NIOBuffer outbound = SslConnection.this._outbound;
            NIOBuffer unwrap = SslConnection.this._unwrapBuf;
            int i = inbound == null ? -1 : inbound.length();
            int o = outbound == null ? -1 : outbound.length();
            int u = unwrap == null ? -1 : unwrap.length();
            return String.format("SSL %s i/o/u=%d/%d/%d ishut=%b oshut=%b {%s}", new Object[]{SslConnection.this._engine.getHandshakeStatus(), i, o, u, SslConnection.this._ishut, SslConnection.this._oshut, SslConnection.this._connection});
        }
    }

    private static class SslBuffers {
        final NIOBuffer _in;
        final NIOBuffer _out;
        final NIOBuffer _unwrap;

        SslBuffers(int packetSize, int appSize) {
            this._in = new IndirectNIOBuffer(packetSize);
            this._out = new IndirectNIOBuffer(packetSize);
            this._unwrap = new IndirectNIOBuffer(appSize);
        }
    }
}

