/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.jetty.http.security.Password;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.bio.SocketEndPoint;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.ssl.SslCertificates;
import org.eclipse.jetty.server.ssl.SslConnector;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;

public class SslSocketConnector
extends SocketConnector
implements SslConnector {
    private String[] _excludeCipherSuites = null;
    private String[] _includeCipherSuites = null;
    private String _keystorePath = DEFAULT_KEYSTORE;
    private String _keystoreType = "JKS";
    private boolean _needClientAuth = false;
    private transient Password _password;
    private transient Password _keyPassword;
    private transient Password _trustPassword;
    private String _protocol = "TLS";
    private String _provider;
    private String _secureRandomAlgorithm;
    private String _sslKeyManagerFactoryAlgorithm = DEFAULT_KEYSTORE_ALGORITHM;
    private String _sslTrustManagerFactoryAlgorithm = DEFAULT_TRUSTSTORE_ALGORITHM;
    private String _truststorePath;
    private String _truststoreType = "JKS";
    private boolean _wantClientAuth = false;
    private int _handshakeTimeout = 0;
    private SSLContext _context;
    private boolean _allowRenegotiate = false;

    public boolean isAllowRenegotiate() {
        return this._allowRenegotiate;
    }

    public void setAllowRenegotiate(boolean allowRenegotiate) {
        this._allowRenegotiate = allowRenegotiate;
    }

    public void accept(int acceptorID) throws IOException, InterruptedException {
        Socket socket = this._serverSocket.accept();
        this.configure(socket);
        SslConnectorEndPoint connection = new SslConnectorEndPoint(socket);
        ((SocketConnector.ConnectorEndPoint)connection).dispatch();
    }

    protected void configure(Socket socket) throws IOException {
        super.configure(socket);
    }

    protected SSLContext createSSLContext() throws Exception {
        KeyManager[] keyManagers = this.getKeyManagers();
        TrustManager[] trustManagers = this.getTrustManagers();
        SecureRandom secureRandom = this._secureRandomAlgorithm == null ? null : SecureRandom.getInstance(this._secureRandomAlgorithm);
        SSLContext context = this._provider == null ? SSLContext.getInstance(this._protocol) : SSLContext.getInstance(this._protocol, this._provider);
        context.init(keyManagers, trustManagers, secureRandom);
        return context;
    }

    protected SSLServerSocketFactory createFactory() throws Exception {
        if (this._context == null) {
            this._context = this.createSSLContext();
        }
        return this._context.getServerSocketFactory();
    }

    protected KeyManager[] getKeyManagers() throws Exception {
        KeyStore keyStore = this.getKeyStore(this._keystorePath, this._keystoreType, this._password == null ? null : this._password.toString());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this._sslKeyManagerFactoryAlgorithm);
        keyManagerFactory.init(keyStore, this._keyPassword == null ? (this._password == null ? null : this._password.toString().toCharArray()) : this._keyPassword.toString().toCharArray());
        return keyManagerFactory.getKeyManagers();
    }

    protected TrustManager[] getTrustManagers() throws Exception {
        if (this._truststorePath == null) {
            this._truststorePath = this._keystorePath;
            this._truststoreType = this._keystoreType;
            this._trustPassword = this._password;
            this._sslTrustManagerFactoryAlgorithm = this._sslKeyManagerFactoryAlgorithm;
        }
        KeyStore trustStore = this.getKeyStore(this._truststorePath, this._truststoreType, this._trustPassword == null ? null : this._trustPassword.toString());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this._sslTrustManagerFactoryAlgorithm);
        trustManagerFactory.init(trustStore);
        return trustManagerFactory.getTrustManagers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyStore getKeyStore(String keystorePath, String keystoreType, String keystorePassword) throws Exception {
        InputStream keystoreInputStream = null;
        try {
            if (keystorePath != null) {
                keystoreInputStream = Resource.newResource(keystorePath).getInputStream();
            }
            KeyStore keystore = KeyStore.getInstance(keystoreType);
            keystore.load(keystoreInputStream, keystorePassword == null ? null : keystorePassword.toString().toCharArray());
            KeyStore keyStore = keystore;
            return keyStore;
        }
        finally {
            if (keystoreInputStream != null) {
                keystoreInputStream.close();
            }
        }
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        super.customize(endpoint, request);
        request.setScheme("https");
        SocketEndPoint socket_end_point = (SocketEndPoint)endpoint;
        SSLSocket sslSocket = (SSLSocket)socket_end_point.getTransport();
        SSLSession sslSession = sslSocket.getSession();
        SslCertificates.customize(sslSession, endpoint, request);
    }

    public String[] getExcludeCipherSuites() {
        return this._excludeCipherSuites;
    }

    public String[] getIncludeCipherSuites() {
        return this._includeCipherSuites;
    }

    public String getKeystore() {
        return this._keystorePath;
    }

    public String getKeystoreType() {
        return this._keystoreType;
    }

    public boolean getNeedClientAuth() {
        return this._needClientAuth;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public String getProvider() {
        return this._provider;
    }

    public String getSecureRandomAlgorithm() {
        return this._secureRandomAlgorithm;
    }

    public String getSslKeyManagerFactoryAlgorithm() {
        return this._sslKeyManagerFactoryAlgorithm;
    }

    public String getSslTrustManagerFactoryAlgorithm() {
        return this._sslTrustManagerFactoryAlgorithm;
    }

    public String getTruststore() {
        return this._truststorePath;
    }

    public String getTruststoreType() {
        return this._truststoreType;
    }

    public boolean getWantClientAuth() {
        return this._wantClientAuth;
    }

    public boolean isConfidential(Request request) {
        int confidentialPort = this.getConfidentialPort();
        return confidentialPort == 0 || confidentialPort == request.getServerPort();
    }

    public boolean isIntegral(Request request) {
        int integralPort = this.getIntegralPort();
        return integralPort == 0 || integralPort == request.getServerPort();
    }

    protected ServerSocket newServerSocket(String host, int port, int backlog) throws IOException {
        SSLServerSocketFactory factory = null;
        SSLServerSocket socket = null;
        try {
            factory = this.createFactory();
            socket = (SSLServerSocket)(host == null ? factory.createServerSocket(port, backlog) : factory.createServerSocket(port, backlog, InetAddress.getByName(host)));
            if (this._wantClientAuth) {
                socket.setWantClientAuth(this._wantClientAuth);
            }
            if (this._needClientAuth) {
                socket.setNeedClientAuth(this._needClientAuth);
            }
            if (this._excludeCipherSuites != null && this._excludeCipherSuites.length > 0 || this._includeCipherSuites != null && this._includeCipherSuites.length > 0) {
                List<String> includedCSList = this._includeCipherSuites != null ? Arrays.asList(this._includeCipherSuites) : new ArrayList<String>();
                List<String> excludedCSList = this._excludeCipherSuites != null ? Arrays.asList(this._excludeCipherSuites) : new ArrayList<String>();
                String[] enabledCipherSuites = socket.getEnabledCipherSuites();
                ArrayList<String> enabledCSList = new ArrayList<String>(Arrays.asList(enabledCipherSuites));
                String[] supportedCipherSuites = socket.getSupportedCipherSuites();
                List<String> supportedCSList = Arrays.asList(supportedCipherSuites);
                for (String cipherName : includedCSList) {
                    if (enabledCSList.contains(cipherName) || !supportedCSList.contains(cipherName)) continue;
                    enabledCSList.add(cipherName);
                }
                for (String cipherName : excludedCSList) {
                    if (!enabledCSList.contains(cipherName)) continue;
                    enabledCSList.remove(cipherName);
                }
                enabledCipherSuites = enabledCSList.toArray(new String[enabledCSList.size()]);
                socket.setEnabledCipherSuites(enabledCipherSuites);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            Log.warn(e.toString());
            Log.debug(e);
            throw new IOException("!JsseListener: " + e);
        }
        return socket;
    }

    public void setExcludeCipherSuites(String[] cipherSuites) {
        this._excludeCipherSuites = cipherSuites;
    }

    public void setIncludeCipherSuites(String[] cipherSuites) {
        this._includeCipherSuites = cipherSuites;
    }

    public void setKeyPassword(String password) {
        this._keyPassword = Password.getPassword("org.eclipse.jetty.ssl.keypassword", password, null);
    }

    public void setKeystore(String keystore) {
        this._keystorePath = keystore;
    }

    public void setKeystoreType(String keystoreType) {
        this._keystoreType = keystoreType;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this._needClientAuth = needClientAuth;
    }

    public void setPassword(String password) {
        this._password = Password.getPassword("org.eclipse.jetty.ssl.password", password, null);
    }

    public void setTrustPassword(String password) {
        this._trustPassword = Password.getPassword("org.eclipse.jetty.ssl.password", password, null);
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public void setProvider(String _provider) {
        this._provider = _provider;
    }

    public void setSecureRandomAlgorithm(String algorithm) {
        this._secureRandomAlgorithm = algorithm;
    }

    public void setSslKeyManagerFactoryAlgorithm(String algorithm) {
        this._sslKeyManagerFactoryAlgorithm = algorithm;
    }

    public void setSslTrustManagerFactoryAlgorithm(String algorithm) {
        this._sslTrustManagerFactoryAlgorithm = algorithm;
    }

    public void setTruststore(String truststore) {
        this._truststorePath = truststore;
    }

    public void setTruststoreType(String truststoreType) {
        this._truststoreType = truststoreType;
    }

    public void setSslContext(SSLContext sslContext) {
        this._context = sslContext;
    }

    public SSLContext getSslContext() {
        try {
            if (this._context == null) {
                this._context = this.createSSLContext();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this._context;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this._wantClientAuth = wantClientAuth;
    }

    public void setHandshakeTimeout(int msec) {
        this._handshakeTimeout = msec;
    }

    public int getHandshakeTimeout() {
        return this._handshakeTimeout;
    }

    public String getAlgorithm() {
        throw new UnsupportedOperationException();
    }

    public void setAlgorithm(String algorithm) {
        throw new UnsupportedOperationException();
    }

    public class SslConnectorEndPoint
    extends SocketConnector.ConnectorEndPoint {
        public SslConnectorEndPoint(Socket socket) throws IOException {
            super(socket);
        }

        public void shutdownOutput() throws IOException {
        }

        public void run() {
            try {
                int handshakeTimeout = SslSocketConnector.this.getHandshakeTimeout();
                int oldTimeout = this._socket.getSoTimeout();
                if (handshakeTimeout > 0) {
                    this._socket.setSoTimeout(handshakeTimeout);
                }
                final SSLSocket ssl = (SSLSocket)this._socket;
                ssl.addHandshakeCompletedListener(new HandshakeCompletedListener(){
                    boolean handshook = false;

                    public void handshakeCompleted(HandshakeCompletedEvent event) {
                        if (this.handshook) {
                            if (!SslSocketConnector.this._allowRenegotiate) {
                                Log.warn("SSL renegotiate denied: " + ssl);
                                try {
                                    ssl.close();
                                }
                                catch (IOException e) {
                                    Log.warn(e);
                                }
                            }
                        } else {
                            this.handshook = true;
                        }
                    }
                });
                ssl.startHandshake();
                if (handshakeTimeout > 0) {
                    this._socket.setSoTimeout(oldTimeout);
                }
                super.run();
            }
            catch (SSLException e) {
                Log.debug(e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    Log.ignore(e2);
                }
            }
            catch (IOException e) {
                Log.debug(e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    Log.ignore(e2);
                }
            }
        }
    }
}

