/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.continuation;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.eclipse.jetty.continuation.ContinuationThrowable;
import org.eclipse.jetty.continuation.FauxContinuation;

public class ContinuationFilter
implements Filter {
    static boolean __debug;
    private boolean _faux;
    private boolean _partial;
    ServletContext _context;
    private boolean _debug;

    public void init(FilterConfig filterConfig) throws ServletException {
        boolean jetty_7_or_greater = "org.eclipse.jetty.servlet".equals(filterConfig.getClass().getPackage().getName());
        this._context = filterConfig.getServletContext();
        String param = filterConfig.getInitParameter("debug");
        boolean bl = this._debug = param != null && Boolean.parseBoolean(param);
        if (this._debug) {
            __debug = true;
        }
        this._partial = (param = filterConfig.getInitParameter("partial")) != null ? Boolean.parseBoolean(param) : ContinuationSupport.__jetty6 && !jetty_7_or_greater;
        param = filterConfig.getInitParameter("faux");
        if (param != null) {
            this._faux = Boolean.parseBoolean(param);
        } else {
            boolean bl2 = this._faux = !jetty_7_or_greater && !this._partial && this._context.getMajorVersion() < 3;
        }
        if (this._debug) {
            this._context.log("ContinuationFilter  jetty=" + jetty_7_or_greater + " partial=" + this._partial + " jetty6=" + ContinuationSupport.__jetty6 + " faux=" + this._faux + " servlet3=" + ContinuationSupport.__servlet3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this._faux) {
            FauxContinuation fc = new FauxContinuation(request);
            request.setAttribute("org.eclipse.jetty.continuation", (Object)fc);
            boolean complete = false;
            while (!complete) {
                try {
                    chain.doFilter(request, response);
                }
                catch (ContinuationThrowable e) {
                    this.debug("faux", e);
                }
                finally {
                    complete = fc.handleSuspension();
                }
            }
            fc.onComplete();
            return;
        }
        if (this._partial) {
            Continuation c = (Continuation)request.getAttribute("org.eclipse.jetty.continuation");
            try {
                if (c != null && c instanceof PartialContinuation && !((PartialContinuation)c).enter()) return;
                chain.doFilter(request, response);
                return;
            }
            finally {
                if (c == null) {
                    c = (Continuation)request.getAttribute("org.eclipse.jetty.continuation");
                }
                if (c != null && c instanceof PartialContinuation) {
                    ((PartialContinuation)c).exit();
                }
            }
        }
        try {
            chain.doFilter(request, response);
            return;
        }
        catch (ContinuationThrowable e) {
            this.debug("caught", e);
        }
    }

    private void debug(String string) {
        if (this._debug) {
            this._context.log(string);
        }
    }

    private void debug(String string, Throwable th) {
        if (this._debug) {
            if (th instanceof ContinuationThrowable) {
                this._context.log(string + ":" + th);
            } else {
                this._context.log(string, th);
            }
        }
    }

    public void destroy() {
    }

    public static interface PartialContinuation
    extends Continuation {
        public boolean enter();

        public void exit();
    }
}

