/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpHeaderValues;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.BufferCache;
import org.eclipse.jetty.io.BufferDateCache;
import org.eclipse.jetty.io.BufferUtil;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.View;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpFields {
    public static final TimeZone __GMT = TimeZone.getTimeZone("GMT");
    public static final BufferDateCache __dateCache = new BufferDateCache("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
    public static final String __separators = ", \t";
    private static final String[] DAYS;
    private static final String[] MONTHS;
    private static final ThreadLocal<DateGenerator> __dateGenerator;
    private static final String[] __dateReceiveFmt;
    private static final ThreadLocal<DateParser> __dateParser;
    public static final String __01Jan1970;
    public static final Buffer __01Jan1970_BUFFER;
    protected final ArrayList<Field> _fields = new ArrayList(20);
    protected final HashMap<Buffer, Field> _bufferMap = new HashMap(32);
    protected int _revision;
    private static final Float __one;
    private static final Float __zero;
    private static final StringMap __qualities;

    public static String formatDate(long date) {
        return __dateGenerator.get().formatDate(date);
    }

    public static void formatCookieDate(StringBuilder buf, long date) {
        __dateGenerator.get().formatCookieDate(buf, date);
    }

    public static long parseDate(String date) {
        return __dateParser.get().parse(date);
    }

    public Enumeration<String> getFieldNames() {
        final int revision = this._revision;
        return new Enumeration<String>(){
            int i = 0;
            Field field = null;

            @Override
            public boolean hasMoreElements() {
                if (this.field != null) {
                    return true;
                }
                while (this.i < HttpFields.this._fields.size()) {
                    Field f;
                    if ((f = HttpFields.this._fields.get(this.i++)) == null || f._prev != null || f._revision != revision) continue;
                    this.field = f;
                    return true;
                }
                return false;
            }

            @Override
            public String nextElement() throws NoSuchElementException {
                if (this.field != null || this.hasMoreElements()) {
                    String n = BufferUtil.to8859_1_String(this.field._name);
                    this.field = null;
                    return n;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public int size() {
        return this._fields.size();
    }

    public Field getField(int i) {
        Field field = this._fields.get(i);
        if (field._revision != this._revision) {
            return null;
        }
        return field;
    }

    private Field getField(String name) {
        return this._bufferMap.get(HttpHeaders.CACHE.lookup(name));
    }

    private Field getField(Buffer name) {
        return this._bufferMap.get(name);
    }

    public boolean containsKey(Buffer name) {
        Field f = this.getField(name);
        return f != null && f._revision == this._revision;
    }

    public boolean containsKey(String name) {
        Field f = this.getField(name);
        return f != null && f._revision == this._revision;
    }

    public String getStringField(String name) {
        Field field = this.getField(name);
        if (field != null && field._revision == this._revision) {
            return field.getValue();
        }
        return null;
    }

    public String getStringField(Buffer name) {
        Field field = this.getField(name);
        if (field != null && field._revision == this._revision) {
            return BufferUtil.to8859_1_String(field._value);
        }
        return null;
    }

    public Buffer get(Buffer name) {
        Field field = this.getField(name);
        if (field != null && field._revision == this._revision) {
            return field._value;
        }
        return null;
    }

    public Enumeration<String> getValues(String name) {
        final Field field = this.getField(name);
        if (field == null) {
            return null;
        }
        final int revision = this._revision;
        return new Enumeration<String>(){
            Field f;
            {
                this.f = field;
            }

            @Override
            public boolean hasMoreElements() {
                while (this.f != null && this.f._revision != revision) {
                    this.f = this.f._next;
                }
                return this.f != null;
            }

            @Override
            public String nextElement() throws NoSuchElementException {
                if (this.f == null) {
                    throw new NoSuchElementException();
                }
                Field n = this.f;
                do {
                    this.f = this.f._next;
                } while (this.f != null && this.f._revision != revision);
                return n.getValue();
            }
        };
    }

    public Enumeration<String> getValues(Buffer name) {
        final Field field = this.getField(name);
        if (field == null) {
            return null;
        }
        final int revision = this._revision;
        return new Enumeration<String>(){
            Field f;
            {
                this.f = field;
            }

            @Override
            public boolean hasMoreElements() {
                while (this.f != null && this.f._revision != revision) {
                    this.f = this.f._next;
                }
                return this.f != null;
            }

            @Override
            public String nextElement() throws NoSuchElementException {
                if (this.f == null) {
                    throw new NoSuchElementException();
                }
                Field n = this.f;
                this.f = this.f._next;
                while (this.f != null && this.f._revision != revision) {
                    this.f = this.f._next;
                }
                return n.getValue();
            }
        };
    }

    public Enumeration<String> getValues(String name, final String separators) {
        final Enumeration<String> e = this.getValues(name);
        if (e == null) {
            return null;
        }
        return new Enumeration<String>(){
            QuotedStringTokenizer tok = null;

            @Override
            public boolean hasMoreElements() {
                if (this.tok != null && this.tok.hasMoreElements()) {
                    return true;
                }
                while (e.hasMoreElements()) {
                    String value = (String)e.nextElement();
                    this.tok = new QuotedStringTokenizer(value, separators, false, false);
                    if (!this.tok.hasMoreElements()) continue;
                    return true;
                }
                this.tok = null;
                return false;
            }

            @Override
            public String nextElement() throws NoSuchElementException {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String next = (String)this.tok.nextElement();
                if (next != null) {
                    next = next.trim();
                }
                return next;
            }
        };
    }

    public void put(String name, String value) {
        Buffer n = HttpHeaders.CACHE.lookup(name);
        Buffer v = null;
        if (value != null) {
            v = HttpHeaderValues.CACHE.lookup(value);
        }
        this.put(n, v, -1L);
    }

    public void put(Buffer name, String value) {
        Buffer v = HttpHeaderValues.CACHE.lookup(value);
        this.put(name, v, -1L);
    }

    public void put(Buffer name, Buffer value) {
        this.put(name, value, -1L);
    }

    public void put(Buffer name, Buffer value, long numValue) {
        Field field;
        if (value == null) {
            this.remove(name);
            return;
        }
        if (!(name instanceof BufferCache.CachedBuffer)) {
            name = HttpHeaders.CACHE.lookup(name);
        }
        if ((field = this._bufferMap.get(name)) != null) {
            field.reset(value, numValue, this._revision);
            field = field._next;
            while (field != null) {
                field.clear();
                field = field._next;
            }
        } else {
            field = new Field(name, value, numValue, this._revision);
            this._fields.add(field);
            this._bufferMap.put(field.getNameBuffer(), field);
        }
    }

    public void put(String name, List<?> list) {
        if (list == null || list.size() == 0) {
            this.remove(name);
            return;
        }
        Buffer n = HttpHeaders.CACHE.lookup(name);
        Object v = list.get(0);
        if (v != null) {
            this.put(n, HttpHeaderValues.CACHE.lookup(v.toString()));
        } else {
            this.remove(n);
        }
        if (list.size() > 1) {
            Iterator<?> iter = list.iterator();
            iter.next();
            while (iter.hasNext()) {
                v = iter.next();
                if (v == null) continue;
                this.put(n, HttpHeaderValues.CACHE.lookup(v.toString()));
            }
        }
    }

    public void add(String name, String value) throws IllegalArgumentException {
        Buffer n = HttpHeaders.CACHE.lookup(name);
        Buffer v = HttpHeaderValues.CACHE.lookup(value);
        this.add(n, v, -1L);
    }

    public void add(Buffer name, Buffer value) throws IllegalArgumentException {
        this.add(name, value, -1L);
    }

    private void add(Buffer name, Buffer value, long numValue) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        if (!(name instanceof BufferCache.CachedBuffer)) {
            name = HttpHeaders.CACHE.lookup(name);
        }
        Field field = this._bufferMap.get(name);
        Field last = null;
        if (field != null) {
            while (field != null && field._revision == this._revision) {
                last = field;
                field = field._next;
            }
        }
        if (field != null) {
            field.reset(value, numValue, this._revision);
        } else {
            field = new Field(name, value, numValue, this._revision);
            if (last != null) {
                field._prev = last;
                last._next = field;
            } else {
                this._bufferMap.put(field.getNameBuffer(), field);
            }
            this._fields.add(field);
        }
    }

    public void remove(String name) {
        this.remove(HttpHeaders.CACHE.lookup(name));
    }

    public void remove(Buffer name) {
        Field field = this._bufferMap.get(name);
        if (field != null) {
            while (field != null) {
                field.clear();
                field = field._next;
            }
        }
    }

    public long getLongField(String name) throws NumberFormatException {
        Field field = this.getField(name);
        if (field != null && field._revision == this._revision) {
            return field.getLongValue();
        }
        return -1L;
    }

    public long getLongField(Buffer name) throws NumberFormatException {
        Field field = this.getField(name);
        if (field != null && field._revision == this._revision) {
            return field.getLongValue();
        }
        return -1L;
    }

    public long getDateField(String name) {
        Field field = this.getField(name);
        if (field == null || field._revision != this._revision) {
            return -1L;
        }
        if (field._numValue != -1L) {
            return field._numValue;
        }
        String val = HttpFields.valueParameters(BufferUtil.to8859_1_String(field._value), null);
        if (val == null) {
            return -1L;
        }
        long date = __dateParser.get().parse(val);
        if (date < 0L) {
            throw new IllegalArgumentException("Cannot convert date: " + val);
        }
        field._numValue = date;
        return date;
    }

    public void putLongField(Buffer name, long value) {
        Buffer v = BufferUtil.toBuffer(value);
        this.put(name, v, value);
    }

    public void putLongField(String name, long value) {
        Buffer n = HttpHeaders.CACHE.lookup(name);
        Buffer v = BufferUtil.toBuffer(value);
        this.put(n, v, value);
    }

    public void addLongField(String name, long value) {
        Buffer n = HttpHeaders.CACHE.lookup(name);
        Buffer v = BufferUtil.toBuffer(value);
        this.add(n, v, value);
    }

    public void addLongField(Buffer name, long value) {
        Buffer v = BufferUtil.toBuffer(value);
        this.add(name, v, value);
    }

    public void putDateField(Buffer name, long date) {
        String d = HttpFields.formatDate(date);
        ByteArrayBuffer v = new ByteArrayBuffer(d);
        this.put(name, v, date);
    }

    public void putDateField(String name, long date) {
        Buffer n = HttpHeaders.CACHE.lookup(name);
        this.putDateField(n, date);
    }

    public void addDateField(String name, long date) {
        String d = HttpFields.formatDate(date);
        Buffer n = HttpHeaders.CACHE.lookup(name);
        ByteArrayBuffer v = new ByteArrayBuffer(d);
        this.add(n, v, date);
    }

    public void addSetCookie(HttpCookie cookie) {
        this.addSetCookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), cookie.getMaxAge(), cookie.getComment(), cookie.isSecure(), cookie.isHttpOnly(), cookie.getVersion());
    }

    public void addSetCookie(String name, String value, String domain, String path, long maxAge, String comment, boolean isSecure, boolean isHttpOnly, int version) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Bad cookie name");
        }
        StringBuilder buf = new StringBuilder(128);
        QuotedStringTokenizer.quoteIfNeeded(buf, name);
        buf.append('=');
        if (value != null && value.length() > 0) {
            QuotedStringTokenizer.quoteIfNeeded(buf, value);
        }
        if (version > 0) {
            buf.append(";Version=");
            buf.append(version);
            if (comment != null && comment.length() > 0) {
                buf.append(";Comment=");
                QuotedStringTokenizer.quoteIfNeeded(buf, comment);
            }
        }
        if (path != null && path.length() > 0) {
            buf.append(";Path=");
            if (path.trim().startsWith("\"")) {
                buf.append(path);
            } else {
                QuotedStringTokenizer.quoteIfNeeded(buf, path);
            }
        }
        if (domain != null && domain.length() > 0) {
            buf.append(";Domain=");
            QuotedStringTokenizer.quoteIfNeeded(buf, domain.toLowerCase());
        }
        if (maxAge >= 0L) {
            if (version == 0) {
                buf.append(";Expires=");
                if (maxAge == 0L) {
                    buf.append(__01Jan1970);
                } else {
                    HttpFields.formatCookieDate(buf, System.currentTimeMillis() + 1000L * maxAge);
                }
            } else {
                buf.append(";Max-Age=");
                buf.append(maxAge);
            }
        } else if (version > 0) {
            buf.append(";Discard");
        }
        if (isSecure) {
            buf.append(";Secure");
        }
        if (isHttpOnly) {
            buf.append(";HttpOnly");
        }
        String name_value_params = buf.toString();
        this.put(HttpHeaders.EXPIRES_BUFFER, __01Jan1970_BUFFER);
        this.add(HttpHeaders.SET_COOKIE_BUFFER, new ByteArrayBuffer(name_value_params));
    }

    public void put(Buffer buffer) throws IOException {
        for (int i = 0; i < this._fields.size(); ++i) {
            Field field = this._fields.get(i);
            if (field == null || field._revision != this._revision) continue;
            field.put(buffer);
        }
        BufferUtil.putCRLF(buffer);
    }

    public String toString() {
        try {
            ByteArrayBuffer buffer = new ByteArrayBuffer(4096);
            this.put(buffer);
            return BufferUtil.to8859_1_String(buffer);
        }
        catch (Exception e) {
            Log.warn(e);
            return e.toString();
        }
    }

    public void clear() {
        ++this._revision;
        if (this._revision > 1000000) {
            this._revision = 0;
            int i = this._fields.size();
            while (i-- > 0) {
                Field field = this._fields.get(i);
                if (field == null) continue;
                field.clear();
            }
        }
    }

    public void destroy() {
        if (this._fields != null) {
            int i = this._fields.size();
            while (i-- > 0) {
                Field field = this._fields.get(i);
                if (field == null) continue;
                field.destroy();
            }
            this._fields.clear();
        }
    }

    public void add(HttpFields fields) {
        if (fields == null) {
            return;
        }
        Enumeration<String> e = fields.getFieldNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            Enumeration<String> values = fields.getValues(name);
            while (values.hasMoreElements()) {
                this.add(name, values.nextElement());
            }
        }
    }

    public static String valueParameters(String value, Map<String, String> parameters) {
        if (value == null) {
            return null;
        }
        int i = value.indexOf(59);
        if (i < 0) {
            return value;
        }
        if (parameters == null) {
            return value.substring(0, i).trim();
        }
        QuotedStringTokenizer tok1 = new QuotedStringTokenizer(value.substring(i), ";", false, true);
        while (((StringTokenizer)tok1).hasMoreTokens()) {
            String token = ((StringTokenizer)tok1).nextToken();
            QuotedStringTokenizer tok2 = new QuotedStringTokenizer(token, "= ");
            if (!((StringTokenizer)tok2).hasMoreTokens()) continue;
            String paramName = ((StringTokenizer)tok2).nextToken();
            String paramVal = null;
            if (((StringTokenizer)tok2).hasMoreTokens()) {
                paramVal = ((StringTokenizer)tok2).nextToken();
            }
            parameters.put(paramName, paramVal);
        }
        return value.substring(0, i).trim();
    }

    public static Float getQuality(String value) {
        Map.Entry entry;
        if (value == null) {
            return __zero;
        }
        int qe = value.indexOf(";");
        if (qe++ < 0 || qe == value.length()) {
            return __one;
        }
        if (value.charAt(qe++) == 'q' && (entry = __qualities.getEntry(value, ++qe, value.length() - qe)) != null) {
            return (Float)entry.getValue();
        }
        HashMap<String, String> params = new HashMap<String, String>(3);
        HttpFields.valueParameters(value, params);
        String qs = params.get("q");
        Float q = (Float)__qualities.get(qs);
        if (q == null) {
            try {
                q = new Float(qs);
            }
            catch (Exception e) {
                q = __one;
            }
        }
        return q;
    }

    public static List qualityList(Enumeration e) {
        if (e == null || !e.hasMoreElements()) {
            return Collections.EMPTY_LIST;
        }
        Object list = null;
        Object qual = null;
        while (e.hasMoreElements()) {
            String v = e.nextElement().toString();
            Float q = HttpFields.getQuality(v);
            if (!((double)q.floatValue() >= 0.001)) continue;
            list = LazyList.add(list, v);
            qual = LazyList.add(qual, q);
        }
        List vl = LazyList.getList(list, false);
        if (vl.size() < 2) {
            return vl;
        }
        List ql = LazyList.getList(qual, false);
        Float last = __zero;
        int i = vl.size();
        while (i-- > 0) {
            Float q = (Float)ql.get(i);
            if (last.compareTo(q) > 0) {
                Object tmp = vl.get(i);
                vl.set(i, vl.get(i + 1));
                vl.set(i + 1, tmp);
                ql.set(i, ql.get(i + 1));
                ql.set(i + 1, q);
                last = __zero;
                i = vl.size();
                continue;
            }
            last = q;
        }
        ql.clear();
        return vl;
    }

    static {
        __GMT.setID("GMT");
        __dateCache.setTimeZone(__GMT);
        DAYS = new String[]{"Sat", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "Jan"};
        __dateGenerator = new ThreadLocal<DateGenerator>(){

            @Override
            protected DateGenerator initialValue() {
                return new DateGenerator();
            }
        };
        __dateReceiveFmt = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss", "EEE MMM dd HH:mm:ss yyyy", "EEE, dd MMM yyyy HH:mm:ss", "EEE dd MMM yyyy HH:mm:ss zzz", "EEE dd MMM yyyy HH:mm:ss", "EEE MMM dd yyyy HH:mm:ss zzz", "EEE MMM dd yyyy HH:mm:ss", "EEE MMM-dd-yyyy HH:mm:ss zzz", "EEE MMM-dd-yyyy HH:mm:ss", "dd MMM yyyy HH:mm:ss zzz", "dd MMM yyyy HH:mm:ss", "dd-MMM-yy HH:mm:ss zzz", "dd-MMM-yy HH:mm:ss", "MMM dd HH:mm:ss yyyy zzz", "MMM dd HH:mm:ss yyyy", "EEE MMM dd HH:mm:ss yyyy zzz", "EEE, MMM dd HH:mm:ss yyyy zzz", "EEE, MMM dd HH:mm:ss yyyy", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE dd-MMM-yy HH:mm:ss zzz", "EEE dd-MMM-yy HH:mm:ss"};
        __dateParser = new ThreadLocal<DateParser>(){

            @Override
            protected DateParser initialValue() {
                return new DateParser();
            }
        };
        __01Jan1970 = HttpFields.formatDate(0L).trim();
        __01Jan1970_BUFFER = new ByteArrayBuffer(__01Jan1970);
        __one = new Float("1.0");
        __zero = new Float("0.0");
        __qualities = new StringMap();
        __qualities.put(null, (Object)__one);
        __qualities.put("1.0", (Object)__one);
        __qualities.put("1", (Object)__one);
        __qualities.put("0.9", (Object)new Float("0.9"));
        __qualities.put("0.8", (Object)new Float("0.8"));
        __qualities.put("0.7", (Object)new Float("0.7"));
        __qualities.put("0.66", (Object)new Float("0.66"));
        __qualities.put("0.6", (Object)new Float("0.6"));
        __qualities.put("0.5", (Object)new Float("0.5"));
        __qualities.put("0.4", (Object)new Float("0.4"));
        __qualities.put("0.33", (Object)new Float("0.33"));
        __qualities.put("0.3", (Object)new Float("0.3"));
        __qualities.put("0.2", (Object)new Float("0.2"));
        __qualities.put("0.1", (Object)new Float("0.1"));
        __qualities.put("0", (Object)__zero);
        __qualities.put("0.0", (Object)__zero);
    }

    public static final class Field {
        private Buffer _name;
        private Buffer _value;
        private String _stringValue;
        private long _numValue;
        private Field _next;
        private Field _prev;
        private int _revision;

        private Field(Buffer name, Buffer value, long numValue, int revision) {
            this._name = name.asImmutableBuffer();
            this._value = value.isImmutable() ? value : new View(value);
            this._next = null;
            this._prev = null;
            this._revision = revision;
            this._numValue = numValue;
            this._stringValue = null;
        }

        private void clear() {
            this._revision = -1;
        }

        private void destroy() {
            this._name = null;
            this._value = null;
            this._next = null;
            this._prev = null;
            this._stringValue = null;
        }

        private void reset(Buffer value, long numValue, int revision) {
            this._revision = revision;
            if (this._value == null) {
                this._value = value.isImmutable() ? value : new View(value);
                this._numValue = numValue;
                this._stringValue = null;
            } else if (value.isImmutable()) {
                this._value = value;
                this._numValue = numValue;
                this._stringValue = null;
            } else {
                if (this._value instanceof View) {
                    ((View)this._value).update(value);
                } else {
                    this._value = new View(value);
                }
                this._numValue = numValue;
                if (this._stringValue != null) {
                    if (this._stringValue.length() != value.length()) {
                        this._stringValue = null;
                    } else {
                        int i = value.length();
                        while (i-- > 0) {
                            if (value.peek(value.getIndex() + i) == this._stringValue.charAt(i)) continue;
                            this._stringValue = null;
                            break;
                        }
                    }
                }
            }
        }

        public void put(Buffer buffer) throws IOException {
            byte b;
            int e;
            int s;
            int o;
            int n = o = this._name instanceof BufferCache.CachedBuffer ? ((BufferCache.CachedBuffer)this._name).getOrdinal() : -1;
            if (o >= 0) {
                buffer.put(this._name);
            } else {
                s = this._name.getIndex();
                e = this._name.putIndex();
                block6: while (s < e) {
                    b = this._name.peek(s++);
                    switch (b) {
                        case 10: 
                        case 13: 
                        case 58: {
                            continue block6;
                        }
                    }
                    buffer.put(b);
                }
            }
            buffer.put((byte)58);
            buffer.put((byte)32);
            int n2 = o = this._value instanceof BufferCache.CachedBuffer ? ((BufferCache.CachedBuffer)this._value).getOrdinal() : -1;
            if (o >= 0 || this._numValue >= 0L) {
                buffer.put(this._value);
            } else {
                s = this._value.getIndex();
                e = this._value.putIndex();
                block7: while (s < e) {
                    b = this._value.peek(s++);
                    switch (b) {
                        case 10: 
                        case 13: {
                            continue block7;
                        }
                    }
                    buffer.put(b);
                }
            }
            BufferUtil.putCRLF(buffer);
        }

        public String getName() {
            return BufferUtil.to8859_1_String(this._name);
        }

        Buffer getNameBuffer() {
            return this._name;
        }

        public int getNameOrdinal() {
            return HttpHeaders.CACHE.getOrdinal(this._name);
        }

        public String getValue() {
            if (this._stringValue == null) {
                this._stringValue = this._value instanceof BufferCache.CachedBuffer ? this._value.toString() : BufferUtil.to8859_1_String(this._value);
            }
            return this._stringValue;
        }

        public Buffer getValueBuffer() {
            return this._value;
        }

        public int getValueOrdinal() {
            return HttpHeaderValues.CACHE.getOrdinal(this._value);
        }

        public int getIntValue() {
            return (int)this.getLongValue();
        }

        public long getLongValue() {
            if (this._numValue == -1L) {
                this._numValue = BufferUtil.toLong(this._value);
            }
            return this._numValue;
        }

        public String toString() {
            return "[" + (this._prev == null ? "" : "<-") + this.getName() + "=" + this._revision + "=" + this._value + (this._next == null ? "" : "->") + "]";
        }
    }

    private static class DateParser {
        final SimpleDateFormat[] _dateReceive = new SimpleDateFormat[HttpFields.access$300().length];

        private DateParser() {
        }

        long parse(String dateVal) {
            for (int i = 0; i < this._dateReceive.length; ++i) {
                if (this._dateReceive[i] == null) {
                    this._dateReceive[i] = new SimpleDateFormat(__dateReceiveFmt[i], Locale.US);
                    this._dateReceive[i].setTimeZone(__GMT);
                }
                try {
                    Date date = (Date)this._dateReceive[i].parseObject(dateVal);
                    return date.getTime();
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (dateVal.endsWith(" GMT")) {
                String val = dateVal.substring(0, dateVal.length() - 4);
                for (int i = 0; i < this._dateReceive.length; ++i) {
                    try {
                        Date date = (Date)this._dateReceive[i].parseObject(val);
                        return date.getTime();
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
            }
            return -1L;
        }
    }

    private static class DateGenerator {
        private final StringBuilder buf = new StringBuilder(32);
        private final GregorianCalendar gc = new GregorianCalendar(__GMT);

        private DateGenerator() {
        }

        public String formatDate(long date) {
            this.buf.setLength(0);
            this.gc.setTimeInMillis(date);
            int day_of_week = this.gc.get(7);
            int day_of_month = this.gc.get(5);
            int month = this.gc.get(2);
            int year = this.gc.get(1);
            int century = year / 100;
            year %= 100;
            int epoch = (int)(date / 1000L % 86400L);
            int seconds = epoch % 60;
            int minutes = (epoch /= 60) % 60;
            int hours = epoch / 60;
            this.buf.append(DAYS[day_of_week]);
            this.buf.append(',');
            this.buf.append(' ');
            StringUtil.append2digits(this.buf, day_of_month);
            this.buf.append(' ');
            this.buf.append(MONTHS[month]);
            this.buf.append(' ');
            StringUtil.append2digits(this.buf, century);
            StringUtil.append2digits(this.buf, year);
            this.buf.append(' ');
            StringUtil.append2digits(this.buf, hours);
            this.buf.append(':');
            StringUtil.append2digits(this.buf, minutes);
            this.buf.append(':');
            StringUtil.append2digits(this.buf, seconds);
            this.buf.append(" GMT");
            return this.buf.toString();
        }

        public void formatCookieDate(StringBuilder buf, long date) {
            this.gc.setTimeInMillis(date);
            int day_of_week = this.gc.get(7);
            int day_of_month = this.gc.get(5);
            int month = this.gc.get(2);
            int year = this.gc.get(1);
            year %= 100;
            int epoch = (int)(date / 1000L % 86400L);
            int seconds = epoch % 60;
            int minutes = (epoch /= 60) % 60;
            int hours = epoch / 60;
            buf.append(DAYS[day_of_week]);
            buf.append(',');
            buf.append(' ');
            StringUtil.append2digits(buf, day_of_month);
            buf.append('-');
            buf.append(MONTHS[month]);
            buf.append('-');
            StringUtil.append2digits(buf, year);
            buf.append(' ');
            StringUtil.append2digits(buf, hours);
            buf.append(':');
            StringUtil.append2digits(buf, minutes);
            buf.append(':');
            StringUtil.append2digits(buf, seconds);
            buf.append(" GMT");
        }
    }
}

