/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.View;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class ResourceCache
extends AbstractLifeCycle {
    protected final Map _cache = new HashMap();
    private final MimeTypes _mimeTypes;
    private int _maxCachedFileSize = 0x100000;
    private int _maxCachedFiles = 2048;
    private int _maxCacheSize = 0x1000000;
    protected int _cachedSize;
    protected int _cachedFiles;
    protected Content _mostRecentlyUsed;
    protected Content _leastRecentlyUsed;

    public ResourceCache(MimeTypes mimeTypes) {
        this._mimeTypes = mimeTypes;
    }

    public int getCachedSize() {
        return this._cachedSize;
    }

    public int getCachedFiles() {
        return this._cachedFiles;
    }

    public int getMaxCachedFileSize() {
        return this._maxCachedFileSize;
    }

    public void setMaxCachedFileSize(int maxCachedFileSize) {
        this._maxCachedFileSize = maxCachedFileSize;
        this.flushCache();
    }

    public int getMaxCacheSize() {
        return this._maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this._maxCacheSize = maxCacheSize;
        this.flushCache();
    }

    public int getMaxCachedFiles() {
        return this._maxCachedFiles;
    }

    public void setMaxCachedFiles(int maxCachedFiles) {
        this._maxCachedFiles = maxCachedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCache() {
        if (this._cache != null) {
            ResourceCache resourceCache = this;
            synchronized (resourceCache) {
                ArrayList values = new ArrayList(this._cache.values());
                for (Content content : values) {
                    content.invalidate();
                }
                this._cache.clear();
                this._cachedSize = 0;
                this._cachedFiles = 0;
                this._mostRecentlyUsed = null;
                this._leastRecentlyUsed = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Content lookup(String pathInContext, ResourceFactory factory) throws IOException {
        Content content = null;
        Map map = this._cache;
        synchronized (map) {
            content = (Content)this._cache.get(pathInContext);
            if (content != null && content.isValid()) {
                return content;
            }
        }
        Resource resource = factory.getResource(pathInContext);
        return this.load(pathInContext, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Content lookup(String pathInContext, Resource resource) throws IOException {
        Content content = null;
        Map map = this._cache;
        synchronized (map) {
            content = (Content)this._cache.get(pathInContext);
            if (content != null && content.isValid()) {
                return content;
            }
        }
        return this.load(pathInContext, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Content load(String pathInContext, Resource resource) throws IOException {
        long len;
        Content content = null;
        if (resource != null && resource.exists() && !resource.isDirectory() && (len = resource.length()) > 0L && len < (long)this._maxCachedFileSize && len < (long)this._maxCacheSize) {
            int must_be_smaller_than = this._maxCacheSize - (int)len;
            Map map = this._cache;
            synchronized (map) {
                while (this._leastRecentlyUsed != null && (this._cachedSize > must_be_smaller_than || this._maxCachedFiles > 0 && this._cachedFiles >= this._maxCachedFiles)) {
                    this._leastRecentlyUsed.invalidate();
                }
                if (this._cachedSize > must_be_smaller_than || this._maxCachedFiles > 0 && this._cachedFiles >= this._maxCachedFiles) {
                    return null;
                }
            }
            content = new Content(resource);
            this.fill(content);
            map = this._cache;
            synchronized (map) {
                Content content2 = (Content)this._cache.get(pathInContext);
                if (content2 != null) {
                    content.release();
                    return content2;
                }
                while (this._leastRecentlyUsed != null && (this._cachedSize > must_be_smaller_than || this._maxCachedFiles > 0 && this._cachedFiles >= this._maxCachedFiles)) {
                    this._leastRecentlyUsed.invalidate();
                }
                if (this._cachedSize > must_be_smaller_than || this._maxCachedFiles > 0 && this._cachedFiles >= this._maxCachedFiles) {
                    return null;
                }
                content.cache(pathInContext);
                return content;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void miss(String pathInContext, Resource resource) throws IOException {
        Map map = this._cache;
        synchronized (map) {
            while (this._maxCachedFiles > 0 && this._cachedFiles >= this._maxCachedFiles && this._leastRecentlyUsed != null) {
                this._leastRecentlyUsed.invalidate();
            }
            if (this._maxCachedFiles > 0 && this._cachedFiles >= this._maxCachedFiles) {
                return;
            }
            Miss miss = new Miss(resource);
            Content content2 = (Content)this._cache.get(pathInContext);
            if (content2 != null) {
                miss.release();
                return;
            }
            miss.cache(pathInContext);
        }
    }

    public synchronized void doStart() throws Exception {
        this._cache.clear();
        this._cachedSize = 0;
        this._cachedFiles = 0;
    }

    public void doStop() throws InterruptedException {
        this.flushCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fill(Content content) throws IOException {
        try {
            InputStream in = content.getResource().getInputStream();
            int len = (int)content.getResource().length();
            ByteArrayBuffer buffer = new ByteArrayBuffer(len);
            buffer.readFrom(in, len);
            in.close();
            content.setBuffer(buffer);
            Object var6_5 = null;
            content.getResource().release();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            content.getResource().release();
            throw throwable;
        }
    }

    public class Miss
    extends Content {
        Miss(Resource resource) {
            super(resource);
        }

        boolean isValid() {
            if (this._resource.exists()) {
                this.invalidate();
                return false;
            }
            return true;
        }
    }

    public class Content
    implements HttpContent {
        final Resource _resource;
        final long _lastModified;
        boolean _locked;
        String _key;
        Content _prev;
        Content _next;
        Buffer _lastModifiedBytes;
        Buffer _contentType;
        Buffer _buffer;

        Content(Resource resource) {
            this._resource = resource;
            this._next = this;
            this._prev = this;
            this._contentType = ResourceCache.this._mimeTypes.getMimeByExtension(this._resource.toString());
            this._lastModified = resource.lastModified();
        }

        public boolean isLocked() {
            return this._locked;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLocked(boolean locked) {
            Map map = ResourceCache.this._cache;
            synchronized (map) {
                if (this._locked && !locked) {
                    this._locked = locked;
                    this._next = ResourceCache.this._mostRecentlyUsed;
                    ResourceCache.this._mostRecentlyUsed = this;
                    if (this._next != null) {
                        this._next._prev = this;
                    }
                    this._prev = null;
                    if (ResourceCache.this._leastRecentlyUsed == null) {
                        ResourceCache.this._leastRecentlyUsed = this;
                    }
                } else if (!this._locked && locked) {
                    if (this._prev != null) {
                        this._prev._next = this._next;
                    }
                    if (this._next != null) {
                        this._next._prev = this._prev;
                    }
                    this._prev = null;
                    this._next = null;
                } else {
                    this._locked = locked;
                }
            }
        }

        void cache(String pathInContext) {
            this._key = pathInContext;
            if (!this._locked) {
                this._next = ResourceCache.this._mostRecentlyUsed;
                ResourceCache.this._mostRecentlyUsed = this;
                if (this._next != null) {
                    this._next._prev = this;
                }
                this._prev = null;
                if (ResourceCache.this._leastRecentlyUsed == null) {
                    ResourceCache.this._leastRecentlyUsed = this;
                }
            }
            ResourceCache.this._cache.put(this._key, this);
            if (this._buffer != null) {
                ResourceCache.this._cachedSize += this._buffer.length();
            }
            ++ResourceCache.this._cachedFiles;
            if (this._lastModified != -1L) {
                this._lastModifiedBytes = new ByteArrayBuffer(HttpFields.formatDate(this._lastModified));
            }
        }

        public String getKey() {
            return this._key;
        }

        public boolean isCached() {
            return this._key != null;
        }

        public Resource getResource() {
            return this._resource;
        }

        boolean isValid() {
            if (this._lastModified == this._resource.lastModified()) {
                if (!this._locked && ResourceCache.this._mostRecentlyUsed != this) {
                    Content tp = this._prev;
                    Content tn = this._next;
                    this._next = ResourceCache.this._mostRecentlyUsed;
                    ResourceCache.this._mostRecentlyUsed = this;
                    if (this._next != null) {
                        this._next._prev = this;
                    }
                    this._prev = null;
                    if (tp != null) {
                        tp._next = tn;
                    }
                    if (tn != null) {
                        tn._prev = tp;
                    }
                    if (ResourceCache.this._leastRecentlyUsed == this && tp != null) {
                        ResourceCache.this._leastRecentlyUsed = tp;
                    }
                }
                return true;
            }
            this.invalidate();
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidate() {
            Content content = this;
            synchronized (content) {
                ResourceCache.this._cache.remove(this._key);
                this._key = null;
                if (this._buffer != null) {
                    ResourceCache.this._cachedSize -= this._buffer.length();
                }
                --ResourceCache.this._cachedFiles;
                if (ResourceCache.this._mostRecentlyUsed == this) {
                    ResourceCache.this._mostRecentlyUsed = this._next;
                } else {
                    this._prev._next = this._next;
                }
                if (ResourceCache.this._leastRecentlyUsed == this) {
                    ResourceCache.this._leastRecentlyUsed = this._prev;
                } else {
                    this._next._prev = this._prev;
                }
                this._prev = null;
                this._next = null;
                this._resource.release();
            }
        }

        public Buffer getLastModified() {
            return this._lastModifiedBytes;
        }

        public Buffer getContentType() {
            return this._contentType;
        }

        public void setContentType(Buffer type) {
            this._contentType = type;
        }

        public void release() {
        }

        public Buffer getBuffer() {
            if (this._buffer == null) {
                return null;
            }
            return new View(this._buffer);
        }

        public void setBuffer(Buffer buffer) {
            this._buffer = buffer;
        }

        public long getContentLength() {
            if (this._buffer == null) {
                return -1L;
            }
            return this._buffer.length();
        }

        public InputStream getInputStream() throws IOException {
            return this._resource.getInputStream();
        }

        public String toString() {
            return "{" + this._resource + "," + this._contentType + "," + this._lastModifiedBytes + "}";
        }
    }
}

