/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.server;

import java.util.concurrent.Executor;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.common.events.EventDriverFactory;
import org.eclipse.jetty.websocket.jsr356.ClientContainer;
import org.eclipse.jetty.websocket.jsr356.JsrSessionFactory;
import org.eclipse.jetty.websocket.jsr356.annotations.AnnotatedEndpointScanner;
import org.eclipse.jetty.websocket.jsr356.endpoints.EndpointInstance;
import org.eclipse.jetty.websocket.jsr356.metadata.EndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.server.AnnotatedServerEndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.server.BasicServerEndpointConfig;
import org.eclipse.jetty.websocket.jsr356.server.JsrCreator;
import org.eclipse.jetty.websocket.jsr356.server.JsrServerEndpointImpl;
import org.eclipse.jetty.websocket.jsr356.server.JsrServerExtendsEndpointImpl;
import org.eclipse.jetty.websocket.jsr356.server.ServerEndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.server.SimpleServerEndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.server.pathmap.WebSocketPathSpec;
import org.eclipse.jetty.websocket.server.MappedWebSocketCreator;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;

public class ServerContainer
extends ClientContainer
implements javax.websocket.server.ServerContainer {
    private static final Logger LOG = Log.getLogger(ServerContainer.class);
    private final MappedWebSocketCreator mappedCreator;
    private final WebSocketServerFactory webSocketServerFactory;

    public ServerContainer(MappedWebSocketCreator creator, WebSocketServerFactory factory, Executor executor) {
        super(executor);
        this.mappedCreator = creator;
        this.webSocketServerFactory = factory;
        EventDriverFactory eventDriverFactory = this.webSocketServerFactory.getEventDriverFactory();
        eventDriverFactory.addImplementation(new JsrServerEndpointImpl());
        eventDriverFactory.addImplementation(new JsrServerExtendsEndpointImpl());
        this.webSocketServerFactory.addSessionFactory(new JsrSessionFactory(this, this));
    }

    public EndpointInstance newClientEndpointInstance(Object endpoint, ServerEndpointConfig config, String path) {
        EndpointMetadata metadata = this.getClientEndpointMetadata(endpoint.getClass());
        Object cec = config;
        if (config == null) {
            cec = metadata instanceof AnnotatedServerEndpointMetadata ? ((AnnotatedServerEndpointMetadata)metadata).getConfig() : new BasicServerEndpointConfig(endpoint.getClass(), path);
        }
        return new EndpointInstance(endpoint, (EndpointConfig)cec, metadata);
    }

    public void addEndpoint(Class<?> endpointClass) throws DeploymentException {
        ServerEndpointMetadata metadata = this.getServerEndpointMetadata(endpointClass, null);
        this.addEndpoint(metadata);
    }

    public void addEndpoint(ServerEndpointMetadata metadata) throws DeploymentException {
        JsrCreator creator = new JsrCreator(metadata, this.webSocketServerFactory.getExtensionFactory());
        this.mappedCreator.addMapping(new WebSocketPathSpec(metadata.getPath()), creator);
    }

    public void addEndpoint(ServerEndpointConfig config) throws DeploymentException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("addEndpoint({}) path={} endpoint={}", config, config.getPath(), config.getEndpointClass());
        }
        ServerEndpointMetadata metadata = this.getServerEndpointMetadata(config.getEndpointClass(), config);
        this.addEndpoint(metadata);
    }

    public ServerEndpointMetadata getServerEndpointMetadata(Class<?> endpoint, ServerEndpointConfig config) throws DeploymentException {
        ServerEndpointMetadata metadata = null;
        ServerEndpoint anno = endpoint.getAnnotation(ServerEndpoint.class);
        if (anno != null) {
            AnnotatedServerEndpointMetadata ametadata = new AnnotatedServerEndpointMetadata(endpoint, config);
            AnnotatedEndpointScanner<ServerEndpoint, ServerEndpointConfig> scanner = new AnnotatedEndpointScanner<ServerEndpoint, ServerEndpointConfig>(ametadata);
            metadata = ametadata;
            scanner.scan();
        } else if (Endpoint.class.isAssignableFrom(endpoint)) {
            Class<?> eendpoint = endpoint;
            metadata = new SimpleServerEndpointMetadata(eendpoint, config);
        } else {
            StringBuilder err = new StringBuilder();
            err.append("Not a recognized websocket [");
            err.append(endpoint.getName());
            err.append("] does not extend @").append(ServerEndpoint.class.getName());
            err.append(" or extend from ").append(Endpoint.class.getName());
            throw new DeploymentException("Unable to identify as valid Endpoint: " + endpoint);
        }
        return metadata;
    }

    @Override
    public long getDefaultAsyncSendTimeout() {
        return this.webSocketServerFactory.getPolicy().getAsyncWriteTimeout();
    }

    @Override
    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.webSocketServerFactory.getPolicy().getMaxBinaryMessageSize();
    }

    @Override
    public long getDefaultMaxSessionIdleTimeout() {
        return this.webSocketServerFactory.getPolicy().getIdleTimeout();
    }

    @Override
    public int getDefaultMaxTextMessageBufferSize() {
        return this.webSocketServerFactory.getPolicy().getMaxTextMessageSize();
    }

    @Override
    public void setAsyncSendTimeout(long ms) {
        super.setAsyncSendTimeout(ms);
        this.webSocketServerFactory.getPolicy().setAsyncWriteTimeout(ms);
    }

    @Override
    public void setDefaultMaxBinaryMessageBufferSize(int max) {
        super.setDefaultMaxBinaryMessageBufferSize(max);
        this.webSocketServerFactory.getPolicy().setMaxBinaryMessageSize(max);
        this.webSocketServerFactory.getPolicy().setMaxBinaryMessageBufferSize(max);
    }

    @Override
    public void setDefaultMaxSessionIdleTimeout(long ms) {
        super.setDefaultMaxSessionIdleTimeout(ms);
        this.webSocketServerFactory.getPolicy().setIdleTimeout(ms);
    }

    @Override
    public void setDefaultMaxTextMessageBufferSize(int max) {
        super.setDefaultMaxTextMessageBufferSize(max);
        this.webSocketServerFactory.getPolicy().setMaxTextMessageSize(max);
        this.webSocketServerFactory.getPolicy().setMaxTextMessageBufferSize(max);
    }
}

