/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.annotations;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.nio.ByteBuffer;
import java.util.Map;
import javax.websocket.CloseReason;
import javax.websocket.DecodeException;
import javax.websocket.EndpointConfig;
import javax.websocket.RemoteEndpoint;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.jsr356.JsrSession;
import org.eclipse.jetty.websocket.jsr356.annotations.AnnotatedEndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.annotations.OnCloseCallable;
import org.eclipse.jetty.websocket.jsr356.annotations.OnErrorCallable;
import org.eclipse.jetty.websocket.jsr356.annotations.OnMessageBinaryCallable;
import org.eclipse.jetty.websocket.jsr356.annotations.OnMessageBinaryStreamCallable;
import org.eclipse.jetty.websocket.jsr356.annotations.OnMessagePongCallable;
import org.eclipse.jetty.websocket.jsr356.annotations.OnMessageTextCallable;
import org.eclipse.jetty.websocket.jsr356.annotations.OnMessageTextStreamCallable;
import org.eclipse.jetty.websocket.jsr356.annotations.OnOpenCallable;

public class JsrEvents<T extends Annotation, C extends EndpointConfig> {
    private static final Logger LOG = Log.getLogger(JsrEvents.class);
    private final AnnotatedEndpointMetadata<T, C> metadata;
    private final OnOpenCallable onOpen;
    private final OnCloseCallable onClose;
    private final OnErrorCallable onError;
    private final OnMessageTextCallable onText;
    private final OnMessageTextStreamCallable onTextStream;
    private final OnMessageBinaryCallable onBinary;
    private final OnMessageBinaryStreamCallable onBinaryStream;
    private OnMessagePongCallable onPong;
    private Map<String, String> pathParameters;

    public JsrEvents(AnnotatedEndpointMetadata<T, C> metadata) {
        this.metadata = metadata;
        this.onOpen = metadata.onOpen == null ? null : new OnOpenCallable(metadata.onOpen);
        this.onClose = metadata.onClose == null ? null : new OnCloseCallable(metadata.onClose);
        this.onError = metadata.onError == null ? null : new OnErrorCallable(metadata.onError);
        this.onBinary = metadata.onBinary == null ? null : new OnMessageBinaryCallable(metadata.onBinary);
        this.onBinaryStream = metadata.onBinaryStream == null ? null : new OnMessageBinaryStreamCallable(metadata.onBinaryStream);
        this.onText = metadata.onText == null ? null : new OnMessageTextCallable(metadata.onText);
        this.onTextStream = metadata.onTextStream == null ? null : new OnMessageTextStreamCallable(metadata.onTextStream);
        this.onPong = metadata.onPong == null ? null : new OnMessagePongCallable(metadata.onPong);
    }

    public void callBinary(RemoteEndpoint.Async endpoint, Object websocket, ByteBuffer buf, boolean fin) throws DecodeException {
        if (this.onBinary == null) {
            return;
        }
        Object ret = this.onBinary.call(websocket, buf, fin);
        if (ret != null) {
            LOG.debug("returning: {}", ret);
            endpoint.sendObject(ret);
        }
    }

    public void callBinaryStream(RemoteEndpoint.Async endpoint, Object websocket, InputStream stream) throws DecodeException, IOException {
        if (this.onBinaryStream == null) {
            return;
        }
        Object ret = this.onBinaryStream.call(websocket, stream);
        if (ret != null) {
            LOG.debug("returning: {}", ret);
            endpoint.sendObject(ret);
        }
    }

    public void callClose(Object websocket, CloseReason close) {
        if (this.onClose == null) {
            return;
        }
        this.onClose.call(websocket, close);
    }

    public void callError(Object websocket, Throwable cause) {
        if (this.onError == null) {
            return;
        }
        this.onError.call(websocket, cause);
    }

    public void callOpen(Object websocket, EndpointConfig config) {
        if (this.onOpen == null) {
            return;
        }
        this.onOpen.call(websocket, config);
    }

    public void callPong(RemoteEndpoint.Async endpoint, Object websocket, ByteBuffer pong) throws DecodeException, IOException {
        if (this.onPong == null) {
            return;
        }
        Object ret = this.onPong.call(websocket, pong);
        if (ret != null) {
            LOG.debug("returning: {}", ret);
            endpoint.sendObject(ret);
        }
    }

    public void callText(RemoteEndpoint.Async endpoint, Object websocket, String text, boolean fin) throws DecodeException {
        if (this.onText == null) {
            return;
        }
        Object ret = this.onText.call(websocket, text, fin);
        if (ret != null) {
            LOG.debug("returning: {}", ret);
            endpoint.sendObject(ret);
        }
    }

    public void callTextStream(RemoteEndpoint.Async endpoint, Object websocket, Reader reader) throws DecodeException, IOException {
        if (this.onTextStream == null) {
            return;
        }
        Object ret = this.onTextStream.call(websocket, reader);
        if (ret != null) {
            LOG.debug("returning: {}", ret);
            endpoint.sendObject(ret);
        }
    }

    public AnnotatedEndpointMetadata<T, C> getMetadata() {
        return this.metadata;
    }

    public boolean hasBinary() {
        return this.onBinary != null;
    }

    public boolean hasBinaryStream() {
        return this.onBinaryStream != null;
    }

    public boolean hasText() {
        return this.onText != null;
    }

    public boolean hasTextStream() {
        return this.onTextStream != null;
    }

    public void init(JsrSession session) {
        session.setPathParameters(this.pathParameters);
        if (this.onOpen != null) {
            this.onOpen.init(session);
        }
        if (this.onClose != null) {
            this.onClose.init(session);
        }
        if (this.onError != null) {
            this.onError.init(session);
        }
        if (this.onText != null) {
            this.onText.init(session);
        }
        if (this.onTextStream != null) {
            this.onTextStream.init(session);
        }
        if (this.onBinary != null) {
            this.onBinary.init(session);
        }
        if (this.onBinaryStream != null) {
            this.onBinaryStream.init(session);
        }
        if (this.onPong != null) {
            this.onPong.init(session);
        }
    }

    public boolean isBinaryPartialSupported() {
        if (this.onBinary == null) {
            return false;
        }
        return this.onBinary.isPartialMessageSupported();
    }

    public boolean isTextPartialSupported() {
        if (this.onText == null) {
            return false;
        }
        return this.onText.isPartialMessageSupported();
    }

    public void setPathParameters(Map<String, String> pathParameters) {
        this.pathParameters = pathParameters;
    }
}

