/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;

public abstract class BufferingResponseListener
extends Response.Listener.Adapter {
    private final int maxLength;
    private volatile byte[] buffer = new byte[0];
    private volatile String encoding;

    public BufferingResponseListener() {
        this(0x200000);
    }

    public BufferingResponseListener(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public void onHeaders(Response response) {
        HttpFields headers = response.getHeaders();
        long length = headers.getLongField(HttpHeader.CONTENT_LENGTH.asString());
        if (length > (long)this.maxLength) {
            response.abort(new IllegalArgumentException("Buffering capacity exceeded"));
        } else {
            String contentType = headers.get(HttpHeader.CONTENT_TYPE);
            if (contentType != null) {
                String charset = "charset=";
                int index = contentType.toLowerCase(Locale.ENGLISH).indexOf(charset);
                if (index > 0) {
                    String encoding = contentType.substring(index + charset.length());
                    if ((index = encoding.indexOf(59)) > 0) {
                        encoding = encoding.substring(0, index);
                    }
                    this.encoding = encoding;
                }
            }
        }
    }

    @Override
    public void onContent(Response response, ByteBuffer content) {
        long newLength = this.buffer.length + content.remaining();
        if (newLength > (long)this.maxLength) {
            response.abort(new IllegalArgumentException("Buffering capacity exceeded"));
        } else {
            byte[] newBuffer = new byte[(int)newLength];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            content.get(newBuffer, this.buffer.length, content.remaining());
            this.buffer = newBuffer;
        }
    }

    @Override
    public abstract void onComplete(Result var1);

    public String getEncoding() {
        return this.encoding;
    }

    public byte[] getContent() {
        return this.buffer;
    }

    public String getContentAsString() {
        String encoding = this.encoding;
        if (encoding == null) {
            return this.getContentAsString(StandardCharsets.UTF_8);
        }
        return this.getContentAsString(encoding);
    }

    public String getContentAsString(String encoding) {
        try {
            return new String(this.getContent(), encoding);
        }
        catch (UnsupportedEncodingException x) {
            throw new UnsupportedCharsetException(encoding);
        }
    }

    public String getContentAsString(Charset encoding) {
        return new String(this.getContent(), encoding);
    }
}

