/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketHandler;

public class TestServer
extends Server {
    boolean _verbose;
    WebSocket _websocket;
    SelectChannelConnector _connector;
    WebSocketHandler _handler;
    ConcurrentLinkedQueue<TestWebSocket> _webSockets = new ConcurrentLinkedQueue();

    public TestServer(int port) {
        this._connector = new SelectChannelConnector();
        this._connector.setPort(port);
        this.addConnector(this._connector);
        this._handler = new WebSocketHandler(){

            public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
                if ("org.ietf.websocket.test-echo".equals(protocol) || "echo".equals(protocol) || "lws-mirror-protocol".equals(protocol)) {
                    TestServer.this._websocket = new TestEchoWebSocket();
                } else if ("org.ietf.websocket.test-echo-broadcast".equals(protocol)) {
                    TestServer.this._websocket = new TestEchoBroadcastWebSocket();
                } else if ("org.ietf.websocket.test-echo-assemble".equals(protocol)) {
                    TestServer.this._websocket = new TestEchoAssembleWebSocket();
                } else if ("org.ietf.websocket.test-echo-fragment".equals(protocol)) {
                    TestServer.this._websocket = new TestEchoFragmentWebSocket();
                } else if (protocol == null) {
                    TestServer.this._websocket = new TestWebSocket();
                }
                return TestServer.this._websocket;
            }
        };
        this.setHandler(this._handler);
    }

    public boolean isVerbose() {
        return this._verbose;
    }

    public void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }

    private static void usage() {
        System.err.println("java -cp CLASSPATH " + TestServer.class + " [ OPTIONS ]");
        System.err.println("  -p|--port PORT ");
        System.err.println("  -v|--verbose ");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            int port = 8080;
            boolean verbose = false;
            for (int i = 0; i < args.length; ++i) {
                String a = args[i];
                if ("-p".equals(a) || "--port".equals(a)) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-v".equals(a) || "--verbose".equals(a)) {
                    verbose = true;
                    continue;
                }
                if (!a.startsWith("-")) continue;
                TestServer.usage();
            }
            TestServer server = new TestServer(port);
            server.setVerbose(verbose);
            server.start();
            server.join();
        }
        catch (Exception e) {
            Log.warn(e);
        }
    }

    class TestEchoFragmentWebSocket
    extends TestWebSocket {
        TestEchoFragmentWebSocket() {
        }

        public void onConnect(WebSocket.Connection connection) {
            super.onConnect(connection);
            connection.setMaxTextMessageSize(65536);
            connection.setMaxBinaryMessageSize(65536);
        }

        public void onMessage(byte[] data, int offset, int length) {
            super.onMessage(data, offset, length);
            try {
                this.getOutbound().sendFrame((byte)0, (byte)5, data, offset, length / 2);
                this.getOutbound().sendFrame((byte)8, (byte)5, data, offset + length / 2, length - length / 2);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void onMessage(String message) {
            super.onMessage(message);
            try {
                byte[] data = message.getBytes("UTF-8");
                int offset = 0;
                int length = data.length;
                this.getOutbound().sendFrame((byte)0, (byte)4, data, offset, length / 2);
                this.getOutbound().sendFrame((byte)8, (byte)4, data, offset + length / 2, length - length / 2);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class TestEchoAssembleWebSocket
    extends TestWebSocket {
        TestEchoAssembleWebSocket() {
        }

        public void onConnect(WebSocket.Connection connection) {
            super.onConnect(connection);
            connection.setMaxTextMessageSize(65536);
            connection.setMaxBinaryMessageSize(65536);
        }

        public void onMessage(byte[] data, int offset, int length) {
            super.onMessage(data, offset, length);
            try {
                this.getOutbound().sendMessage(data, offset, length);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void onMessage(String data) {
            super.onMessage(data);
            try {
                this.getOutbound().sendMessage(data);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class TestEchoBroadcastWebSocket
    extends TestWebSocket {
        TestEchoBroadcastWebSocket() {
        }

        public void onMessage(byte[] data, int offset, int length) {
            super.onMessage(data, offset, length);
            for (TestWebSocket ws : TestServer.this._webSockets) {
                try {
                    ws.getOutbound().sendMessage(data, offset, length);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public void onMessage(String data) {
            super.onMessage(data);
            for (TestWebSocket ws : TestServer.this._webSockets) {
                try {
                    ws.getOutbound().sendMessage(data);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class TestEchoWebSocket
    extends TestWebSocket {
        TestEchoWebSocket() {
        }

        public void onConnect(WebSocket.Connection connection) {
            super.onConnect(connection);
            connection.setMaxTextMessageSize(-1);
            connection.setMaxBinaryMessageSize(-1);
        }

        public boolean onFrame(byte flags, byte opcode, byte[] data, int offset, int length) {
            super.onFrame(flags, opcode, data, offset, length);
            try {
                switch (opcode) {
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                    default: {
                        this.getOutbound().sendFrame(flags, opcode, data, offset, length);
                        break;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }
    }

    class TestWebSocket
    implements WebSocket,
    WebSocket.OnFrame,
    WebSocket.OnBinaryMessage,
    WebSocket.OnTextMessage,
    WebSocket.OnControl {
        protected WebSocket.Connection _connection;

        TestWebSocket() {
        }

        public WebSocket.Connection getOutbound() {
            return this._connection;
        }

        public void onConnect(WebSocket.Connection connection) {
            this._connection = connection;
            TestServer.this._webSockets.add(this);
        }

        public void onDisconnect(int code, String message) {
            TestServer.this._webSockets.remove(this);
        }

        public boolean onFrame(byte flags, byte opcode, byte[] data, int offset, int length) {
            if (TestServer.this._verbose) {
                System.err.printf("%s#onFrame %s|%s %s\n", this.getClass().getSimpleName(), TypeUtil.toHexString(flags), TypeUtil.toHexString(opcode), TypeUtil.toHexString(data, offset, length));
            }
            return false;
        }

        public boolean onControl(byte controlCode, byte[] data, int offset, int length) {
            if (TestServer.this._verbose) {
                System.err.printf("%s#onControl  %s %s\n", this.getClass().getSimpleName(), TypeUtil.toHexString(controlCode), TypeUtil.toHexString(data, offset, length));
            }
            return false;
        }

        public void onMessage(String data) {
            if (TestServer.this._verbose) {
                System.err.printf("%s#onMessage     %s\n", this.getClass().getSimpleName(), data);
            }
        }

        public void onMessage(byte[] data, int offset, int length) {
            if (TestServer.this._verbose) {
                System.err.printf("%s#onMessage     %s\n", this.getClass().getSimpleName(), TypeUtil.toHexString(data, offset, length));
            }
        }
    }
}

