/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.View;
import org.eclipse.jetty.io.nio.DirectNIOBuffer;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class ResourceCache {
    private final ConcurrentMap<String, Content> _cache;
    private final AtomicInteger _cachedSize;
    private final AtomicInteger _cachedFiles;
    private final boolean _useFileMappedBuffer;
    private final ResourceFactory _factory;
    private final MimeTypes _mimeTypes;
    private int _maxCachedFileSize = 0x400000;
    private int _maxCachedFiles = 2048;
    private int _maxCacheSize = 0x2000000;

    public ResourceCache(ResourceFactory factory, MimeTypes mimeTypes, boolean fileMappedBuffers) {
        this._factory = factory;
        this._cache = new ConcurrentHashMap<String, Content>();
        this._cachedSize = new AtomicInteger();
        this._cachedFiles = new AtomicInteger();
        this._useFileMappedBuffer = fileMappedBuffers;
        this._mimeTypes = mimeTypes;
    }

    public int getCachedSize() {
        return this._cachedSize.get();
    }

    public int getCachedFiles() {
        return this._cachedFiles.get();
    }

    public int getMaxCachedFileSize() {
        return this._maxCachedFileSize;
    }

    public void setMaxCachedFileSize(int maxCachedFileSize) {
        this._maxCachedFileSize = maxCachedFileSize;
        this.shrinkCache();
    }

    public int getMaxCacheSize() {
        return this._maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this._maxCacheSize = maxCacheSize;
        this.shrinkCache();
    }

    public int getMaxCachedFiles() {
        return this._maxCachedFiles;
    }

    public void setMaxCachedFiles(int maxCachedFiles) {
        this._maxCachedFiles = maxCachedFiles;
        this.shrinkCache();
    }

    public void flushCache() {
        if (this._cache != null) {
            while (this._cache.size() > 0) {
                for (String path : this._cache.keySet()) {
                    Content content = (Content)this._cache.remove(path);
                    if (content == null) continue;
                    content.invalidate();
                }
            }
        }
    }

    public Content lookup(String pathInContext) throws IOException {
        Content content = null;
        content = (Content)this._cache.get(pathInContext);
        if (content != null && content.isValid()) {
            return content;
        }
        Resource resource = this._factory.getResource(pathInContext);
        Content loaded = this.load(pathInContext, resource);
        return loaded;
    }

    private Content load(String pathInContext, Resource resource) throws IOException {
        long len;
        Content content = null;
        if (resource != null && resource.exists() && !resource.isDirectory() && (len = resource.length()) > 0L && len < (long)this._maxCachedFileSize && len < (long)this._maxCacheSize) {
            content = new Content(pathInContext, resource);
            this.shrinkCache();
            Content added = this._cache.putIfAbsent(pathInContext, content);
            if (added != null) {
                content.invalidate();
                content = added;
            }
            return content;
        }
        return null;
    }

    private void shrinkCache() {
        block0: while (this._cache.size() > 0 && (this._cachedFiles.get() > this._maxCachedFiles || this._cachedSize.get() > this._maxCacheSize)) {
            TreeSet<Content> sorted = new TreeSet<Content>(new Comparator<Content>(){

                @Override
                public int compare(Content c1, Content c2) {
                    if (c1._lastAccessed < c2._lastAccessed) {
                        return -1;
                    }
                    if (c1._lastAccessed > c2._lastAccessed) {
                        return 1;
                    }
                    if (c1._length < c2._length) {
                        return -1;
                    }
                    return c1._key.compareTo(c2._key);
                }
            });
            for (Content content : this._cache.values()) {
                sorted.add(content);
            }
            for (Content content : sorted) {
                if (this._cachedFiles.get() <= this._maxCachedFiles && this._cachedSize.get() <= this._maxCacheSize) continue block0;
                if (content != this._cache.remove(content.getKey())) continue;
                content.invalidate();
            }
        }
    }

    public void miss(String pathInContext, Resource resource) {
        if (this._maxCachedFiles > 0 && this._cachedFiles.get() >= this._maxCachedFiles) {
            return;
        }
        Miss miss = new Miss(pathInContext, resource);
        if (this._cache.putIfAbsent(pathInContext, miss) != null) {
            miss.invalidate();
        }
    }

    protected Buffer getIndirectBuffer(Resource resource) {
        try {
            int len = (int)resource.length();
            IndirectNIOBuffer buffer = new IndirectNIOBuffer(len);
            InputStream is = resource.getInputStream();
            buffer.readFrom(is, len);
            is.close();
            return buffer;
        }
        catch (IOException e) {
            Log.warn(e);
            return null;
        }
    }

    protected Buffer getDirectBuffer(Resource resource) {
        try {
            if (this._useFileMappedBuffer && resource.getFile() != null) {
                return new DirectNIOBuffer(resource.getFile());
            }
            int len = (int)resource.length();
            DirectNIOBuffer buffer = new DirectNIOBuffer(len);
            InputStream is = resource.getInputStream();
            buffer.readFrom(is, len);
            is.close();
            return buffer;
        }
        catch (IOException e) {
            Log.warn(e);
            return null;
        }
    }

    public class Miss
    extends Content {
        Miss(String pathInContext, Resource resource) {
            super(pathInContext, resource);
        }

        boolean isValid() {
            if (this._resource.exists()) {
                if (this == ResourceCache.this._cache.remove(this._key)) {
                    this.invalidate();
                }
                return false;
            }
            return true;
        }
    }

    public class Content
    implements HttpContent {
        final Resource _resource;
        final int _length;
        final String _key;
        final long _lastModified;
        final Buffer _lastModifiedBytes;
        final Buffer _contentType;
        volatile long _lastAccessed;
        AtomicReference<Buffer> _indirectBuffer = new AtomicReference();
        AtomicReference<Buffer> _directBuffer = new AtomicReference();

        Content(String pathInContext, Resource resource) {
            this._key = pathInContext;
            this._resource = resource;
            this._contentType = ResourceCache.this._mimeTypes.getMimeByExtension(this._resource.toString());
            boolean exists = resource.exists();
            this._lastModified = exists ? resource.lastModified() : -1L;
            this._lastModifiedBytes = this._lastModified < 0L ? null : new ByteArrayBuffer(HttpFields.formatDate(this._lastModified));
            this._length = exists ? (int)resource.length() : 0;
            ResourceCache.this._cachedSize.addAndGet(this._length);
            ResourceCache.this._cachedFiles.incrementAndGet();
            this._lastAccessed = System.currentTimeMillis();
        }

        public String getKey() {
            return this._key;
        }

        public boolean isCached() {
            return this._key != null;
        }

        public Resource getResource() {
            return this._resource;
        }

        boolean isValid() {
            if (this._lastModified == this._resource.lastModified()) {
                this._lastAccessed = System.currentTimeMillis();
                return true;
            }
            if (this == ResourceCache.this._cache.remove(this._key)) {
                this.invalidate();
            }
            return false;
        }

        protected void invalidate() {
            ResourceCache.this._cachedSize.addAndGet(-this._length);
            ResourceCache.this._cachedFiles.decrementAndGet();
            this._resource.release();
        }

        public Buffer getLastModified() {
            return this._lastModifiedBytes;
        }

        public Buffer getContentType() {
            return this._contentType;
        }

        public void release() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Buffer getIndirectBuffer() {
            Buffer buffer = this._indirectBuffer.get();
            if (buffer == null) {
                AtomicReference<Buffer> atomicReference = this._indirectBuffer;
                synchronized (atomicReference) {
                    if (this._indirectBuffer.get() == null) {
                        buffer = ResourceCache.this.getIndirectBuffer(this._resource);
                        this._indirectBuffer.set(buffer);
                    }
                }
            }
            if (buffer == null) {
                return null;
            }
            return new View(buffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Buffer getDirectBuffer() {
            Buffer buffer = this._directBuffer.get();
            if (buffer == null) {
                AtomicReference<Buffer> atomicReference = this._directBuffer;
                synchronized (atomicReference) {
                    if (this._directBuffer.get() == null) {
                        buffer = ResourceCache.this.getDirectBuffer(this._resource);
                        this._directBuffer.set(buffer);
                    }
                }
            }
            if (buffer == null) {
                return null;
            }
            return new View(buffer);
        }

        public long getContentLength() {
            return this._length;
        }

        public InputStream getInputStream() throws IOException {
            Buffer indirect = this.getIndirectBuffer();
            if (indirect != null && indirect.array() != null) {
                return new ByteArrayInputStream(indirect.array(), indirect.getIndex(), indirect.length());
            }
            return this._resource.getInputStream();
        }

        public String toString() {
            return "{" + this._resource + "," + this._contentType + "," + this._lastModifiedBytes + "}";
        }
    }
}

